/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common.widget;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.apps.common.util.PagedSmoothScroller;

public class PagedSnapHelper
extends LinearSnapHelper {
    private final Context mContext;
    private RecyclerView mRecyclerView;
    @Nullable
    private OrientationHelper mVerticalHelper;
    @Nullable
    private OrientationHelper mHorizontalHelper;

    public PagedSnapHelper(Context context) {
        this.mContext = context;
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[]{layoutManager.canScrollHorizontally() ? this.distanceToTopMargin(layoutManager, targetView, this.getHorizontalHelper(layoutManager)) : 0, layoutManager.canScrollVertically() ? this.distanceToTopMargin(layoutManager, targetView, this.getVerticalHelper(layoutManager)) : 0};
        return out;
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        OrientationHelper orientationHelper = this.getOrientationHelper(layoutManager);
        if (this.mRecyclerView.computeVerticalScrollRange() - this.mRecyclerView.computeVerticalScrollOffset() <= orientationHelper.getTotalSpace() + this.mRecyclerView.getPaddingTop() + this.mRecyclerView.getPaddingBottom()) {
            return null;
        }
        if (layoutManager.canScrollVertically()) {
            return this.findTopView(layoutManager, this.getVerticalHelper(layoutManager));
        }
        if (layoutManager.canScrollHorizontally()) {
            return this.findTopView(layoutManager, this.getHorizontalHelper(layoutManager));
        }
        return null;
    }

    private int distanceToTopMargin(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView, OrientationHelper helper) {
        int childTop = helper.getDecoratedStart(targetView);
        int containerTop = helper.getStartAfterPadding();
        return childTop - containerTop;
    }

    private View findTopView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        int childCount = layoutManager.getChildCount();
        if (childCount == 0) {
            return null;
        }
        View closestChild = null;
        int absClosest = Integer.MAX_VALUE;
        for (int i = 0; i < childCount; ++i) {
            int absDistance;
            View child = layoutManager.getChildAt(i);
            if (child == null || (absDistance = Math.abs(this.distanceToTopMargin(layoutManager, child, helper))) >= absClosest) continue;
            absClosest = absDistance;
            closestChild = child;
        }
        return closestChild;
    }

    private float getPercentageVisible(View view, OrientationHelper helper) {
        int start = helper.getStartAfterPadding();
        int end = helper.getEndAfterPadding();
        int viewHeight = helper.getDecoratedMeasurement(view);
        int viewStart = helper.getDecoratedStart(view);
        int viewEnd = helper.getDecoratedEnd(view);
        if (viewEnd < start) {
            return 0.0f;
        }
        if (viewStart >= start && viewEnd <= end) {
            return 1.0f;
        }
        if (viewStart <= start && viewEnd >= end) {
            return 1.0f - (float)(Math.abs(viewStart) + Math.abs(viewEnd)) / (float)viewHeight;
        }
        if (viewStart < start) {
            return 1.0f - (float)Math.abs(viewStart) / (float)helper.getDecoratedMeasurement(view);
        }
        return 1.0f - (float)Math.abs(viewEnd) / (float)helper.getDecoratedMeasurement(view);
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        super.attachToRecyclerView(recyclerView);
    }

    protected RecyclerView.SmoothScroller createScroller(RecyclerView.LayoutManager layoutManager) {
        return new PagedSmoothScroller(this.mContext);
    }

    public int[] calculateScrollDistance(int velocityX, int velocityY) {
        int[] outDist = super.calculateScrollDistance(velocityX, velocityY);
        if (this.mRecyclerView == null) {
            return outDist;
        }
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager == null || layoutManager.getChildCount() == 0) {
            return outDist;
        }
        int lastChildPosition = this.isAtEnd(layoutManager) ? 0 : layoutManager.getChildCount() - 1;
        OrientationHelper orientationHelper = this.getOrientationHelper(layoutManager);
        View lastChild = layoutManager.getChildAt(lastChildPosition);
        float percentageVisible = this.getPercentageVisible(lastChild, orientationHelper);
        int maxDistance = layoutManager.getHeight();
        if (percentageVisible > 0.0f) {
            maxDistance -= layoutManager.getDecoratedMeasuredHeight(lastChild);
        }
        int minDistance = -maxDistance;
        outDist[0] = PagedSnapHelper.clamp(outDist[0], minDistance, maxDistance);
        outDist[1] = PagedSnapHelper.clamp(outDist[1], minDistance, maxDistance);
        return outDist;
    }

    boolean isAtStart(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager == null || layoutManager.getChildCount() == 0) {
            return true;
        }
        View firstChild = layoutManager.getChildAt(0);
        OrientationHelper orientationHelper = layoutManager.canScrollVertically() ? this.getVerticalHelper(layoutManager) : this.getHorizontalHelper(layoutManager);
        return orientationHelper.getDecoratedStart(firstChild) >= orientationHelper.getStartAfterPadding() && layoutManager.getPosition(firstChild) == 0;
    }

    public boolean isAtEnd(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager == null || layoutManager.getChildCount() == 0) {
            return true;
        }
        int childCount = layoutManager.getChildCount();
        OrientationHelper orientationHelper = layoutManager.canScrollVertically() ? this.getVerticalHelper(layoutManager) : this.getHorizontalHelper(layoutManager);
        View lastVisibleChild = layoutManager.getChildAt(childCount - 1);
        return layoutManager.getPosition(lastVisibleChild) == layoutManager.getItemCount() - 1 && layoutManager.getDecoratedBottom(lastVisibleChild) <= orientationHelper.getEndAfterPadding();
    }

    @NonNull
    private OrientationHelper getOrientationHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        return layoutManager.canScrollVertically() ? this.getVerticalHelper(layoutManager) : this.getHorizontalHelper(layoutManager);
    }

    @NonNull
    private OrientationHelper getVerticalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null || this.mVerticalHelper.getLayoutManager() != layoutManager) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mVerticalHelper;
    }

    @NonNull
    private OrientationHelper getHorizontalHelper(@NonNull RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null || this.mHorizontalHelper.getLayoutManager() != layoutManager) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mHorizontalHelper;
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }
}

