/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.messenger.common;

import android.app.RemoteAction;
import android.app.RemoteInput;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.Person;
import androidx.core.graphics.drawable.IconCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Conversation {
    private static final String KEY_ID = "id";
    private static final String KEY_USER = "user";
    private static final String KEY_TITLE = "title";
    private static final String KEY_MESSAGES = "messages";
    private static final String KEY_PARTICIPANTS = "participants";
    private static final String KEY_ICON = "icon";
    private static final String KEY_ACTIONS = "actions";
    private static final String KEY_UNREAD_COUNT = "unread_count";
    private static final String KEY_IS_MUTED = "is_muted";
    private static final String KEY_EXTRAS = "extras";
    private static final String TAG = "CMC.Conversation";
    @NonNull
    private final String mId;
    @NonNull
    private final Person mUser;
    @Nullable
    private final String mConversationTitle;
    @Nullable
    private final IconCompat mConversationIcon;
    @NonNull
    private final List<Message> mMessages;
    @NonNull
    private final List<Person> mParticipants;
    @Nullable
    private final List<ConversationAction> mActions;
    private final int mUnreadCount;
    private final boolean mIsMuted;
    @NonNull
    private final Bundle mExtras;

    public Conversation(@NonNull String id, @NonNull Person user, @Nullable String conversationTitle, @Nullable IconCompat conversationIcon, @NonNull List<Message> messages, @NonNull List<Person> participants, @Nullable List<ConversationAction> actions, int unreadCount, boolean isMuted, @Nullable Bundle extras) {
        this.mId = id;
        this.mUser = user;
        this.mConversationTitle = conversationTitle;
        this.mConversationIcon = conversationIcon;
        this.mMessages = messages;
        this.mParticipants = participants;
        this.mActions = actions;
        this.mUnreadCount = unreadCount;
        this.mIsMuted = isMuted;
        this.mExtras = extras == null ? new Bundle() : extras;
    }

    @NonNull
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_ID, this.mId);
        bundle.putBundle(KEY_USER, this.mUser.toBundle());
        if (this.mConversationTitle != null) {
            bundle.putString(KEY_TITLE, this.mConversationTitle);
        }
        if (this.mConversationIcon != null) {
            bundle.putBundle(KEY_ICON, this.mConversationIcon.toBundle());
        }
        bundle.putParcelableArray(KEY_MESSAGES, (Parcelable[])Message.getBundleArrayForMessages(this.mMessages));
        Bundle[] participantBundle = (Bundle[])this.mParticipants.stream().map(Person::toBundle).toArray(Bundle[]::new);
        bundle.putParcelableArray(KEY_PARTICIPANTS, (Parcelable[])participantBundle);
        if (this.mActions != null) {
            bundle.putParcelableArray(KEY_ACTIONS, (Parcelable[])ConversationAction.getBundleArrayForAction(this.mActions));
        }
        bundle.putInt(KEY_UNREAD_COUNT, this.mUnreadCount);
        bundle.putBoolean(KEY_IS_MUTED, this.mIsMuted);
        bundle.putBundle(KEY_EXTRAS, this.mExtras);
        return bundle;
    }

    @Nullable
    public static Conversation fromBundle(@Nullable Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        if (bundle.getString(KEY_ID) == null || bundle.getBundle(KEY_USER) == null || bundle.getParcelableArray(KEY_MESSAGES) == null || bundle.getParcelableArray(KEY_PARTICIPANTS) == null) {
            return null;
        }
        List<Person> participants = Arrays.stream(bundle.getParcelableArray(KEY_PARTICIPANTS)).map(personBundle -> personBundle instanceof Bundle ? Person.fromBundle((Bundle)((Bundle)personBundle)) : null).filter(Objects::nonNull).collect(Collectors.toList());
        Bundle iconBundle = bundle.getBundle(KEY_ICON);
        IconCompat icon = iconBundle == null ? null : IconCompat.createFromBundle((Bundle)iconBundle);
        return new Conversation(Objects.requireNonNull(bundle.getString(KEY_ID)), Person.fromBundle((Bundle)Objects.requireNonNull(bundle.getBundle(KEY_USER))), bundle.getString(KEY_TITLE), icon, Message.getMessagesFromBundleArray(Objects.requireNonNull(bundle.getParcelableArray(KEY_MESSAGES))), participants, ConversationAction.getActionsFromBundleArray(bundle.getParcelableArray(KEY_ACTIONS)), bundle.getInt(KEY_UNREAD_COUNT), bundle.getBoolean(KEY_IS_MUTED), bundle.getBundle(KEY_EXTRAS));
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public Person getUser() {
        return this.mUser;
    }

    @Nullable
    public String getConversationTitle() {
        return this.mConversationTitle;
    }

    @Nullable
    public IconCompat getConversationIcon() {
        return this.mConversationIcon;
    }

    @NonNull
    public List<Message> getMessages() {
        return this.mMessages;
    }

    @NonNull
    public List<Person> getParticipants() {
        return this.mParticipants;
    }

    @Nullable
    public List<ConversationAction> getActions() {
        return this.mActions;
    }

    public int getUnreadCount() {
        return this.mUnreadCount;
    }

    public boolean isMuted() {
        return this.mIsMuted;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Message {
        private static final String KEY_TEXT = "text";
        private static final String KEY_TIMESTAMP = "time";
        private static final String KEY_SENDER = "sender";
        private static final String KEY_DATA_MIME_TYPE = "type";
        private static final String KEY_DATA_URI = "uri";
        @NonNull
        private final String mText;
        private final long mTimestamp;
        @Nullable
        private final Person mPerson;
        private int mMessageStatus;
        private int mMessageType;
        @NonNull
        private final Bundle mExtras = new Bundle();
        @Nullable
        private String mDataMimeType;
        @Nullable
        private Uri mDataUri;

        public Message(@NonNull String text, long timestamp, @Nullable Person person) {
            this.mText = text;
            this.mTimestamp = timestamp;
            this.mPerson = person;
        }

        private Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putString(KEY_TEXT, this.mText);
            bundle.putLong(KEY_TIMESTAMP, this.mTimestamp);
            if (this.mPerson != null) {
                bundle.putBundle(KEY_SENDER, this.mPerson.toBundle());
            }
            if (this.mDataMimeType != null) {
                bundle.putString(KEY_DATA_MIME_TYPE, this.mDataMimeType);
            }
            if (this.mDataUri != null) {
                bundle.putParcelable(KEY_DATA_URI, (Parcelable)this.mDataUri);
            }
            return bundle;
        }

        private static Bundle[] getBundleArrayForMessages(List<Message> messages) {
            int size = messages.size();
            Bundle[] bundles = new Bundle[size];
            for (int i = 0; i < size; ++i) {
                bundles[i] = messages.get(i).toBundle();
            }
            return bundles;
        }

        private static List<Message> getMessagesFromBundleArray(Parcelable[] bundles) {
            ArrayList<Message> messages = new ArrayList<Message>(bundles.length);
            for (Parcelable element : bundles) {
                Message message;
                if (!(element instanceof Bundle) || (message = Message.getMessageFromBundle((Bundle)element)) == null) continue;
                messages.add(message);
            }
            return messages;
        }

        @Nullable
        private static Message getMessageFromBundle(Bundle bundle) {
            if (!(bundle.containsKey(KEY_TEXT) && bundle.containsKey(KEY_TIMESTAMP) && bundle.containsKey(KEY_SENDER))) {
                return null;
            }
            Message message = new Message(Objects.requireNonNull(bundle.getString(KEY_TEXT)), bundle.getLong(KEY_TIMESTAMP), Person.fromBundle((Bundle)Objects.requireNonNull(bundle.getBundle(KEY_SENDER))));
            if (bundle.containsKey(KEY_DATA_MIME_TYPE) && bundle.containsKey(KEY_DATA_URI)) {
                try {
                    message.setData(Objects.requireNonNull(bundle.getString(KEY_DATA_MIME_TYPE)), Objects.requireNonNull((Uri)bundle.getParcelable(KEY_DATA_URI)));
                }
                catch (ClassCastException e) {
                    Log.w((String)Conversation.TAG, (String)"Failed to set Data Type/Uri");
                }
            }
            return message;
        }

        @NonNull
        public Message setData(@NonNull String dataMimeType, @NonNull Uri dataUri) {
            this.mDataMimeType = dataMimeType;
            this.mDataUri = dataUri;
            return this;
        }

        @NonNull
        public Message setMessageStatus(int messageStatus) {
            this.mMessageStatus = messageStatus;
            return this;
        }

        @NonNull
        public Message setMessageType(int messageType) {
            this.mMessageType = messageType;
            return this;
        }

        @NonNull
        public String getText() {
            return this.mText;
        }

        public long getTimestamp() {
            return this.mTimestamp;
        }

        public int getMessageStatus() {
            return this.mMessageStatus;
        }

        public int getMessageType() {
            return this.mMessageType;
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtras;
        }

        @Nullable
        public Person getPerson() {
            return this.mPerson;
        }

        @Nullable
        public String getDataMimeType() {
            return this.mDataMimeType;
        }

        @Nullable
        public Uri getDataUri() {
            return this.mDataUri;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface MessageType {
            public static final int MESSAGE_TYPE_ALL = 0;
            public static final int MESSAGE_TYPE_INBOX = 1;
            public static final int MESSAGE_TYPE_SENT = 2;
            public static final int MESSAGE_TYPE_DRAFT = 3;
            public static final int MESSAGE_TYPE_OUTBOX = 4;
            public static final int MESSAGE_TYPE_FAILED = 5;
            public static final int MESSAGE_TYPE_QUEUED = 6;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface MessageStatus {
            public static final int MESSAGE_STATUS_NONE = 0;
            public static final int MESSAGE_STATUS_UNREAD = 1;
            public static final int MESSAGE_STATUS_SEEN = 2;
            public static final int MESSAGE_STATUS_READ = 3;
        }
    }

    public static class ConversationAction {
        private static final String KEY_TYPE = "type";
        private static final String KEY_REMOTE_ACTION = "remote_action";
        private static final String KEY_REMOTE_INPUT = "remote_input";
        private static final String KEY_EXTRAS = "extras";
        private final int mActionType;
        @NonNull
        private final RemoteAction mRemoteAction;
        @Nullable
        private final RemoteInput mRemoteInput;
        @NonNull
        private final Bundle mExtras = new Bundle();

        public ConversationAction(int actionType, @NonNull RemoteAction remoteAction, @Nullable RemoteInput remoteInput) {
            this.mActionType = actionType;
            this.mRemoteAction = remoteAction;
            this.mRemoteInput = remoteInput;
        }

        private static Bundle[] getBundleArrayForAction(List<ConversationAction> actions) {
            int size = actions.size();
            Bundle[] bundles = new Bundle[size];
            for (int i = 0; i < size; ++i) {
                bundles[i] = actions.get(i).toBundle();
            }
            return bundles;
        }

        @Nullable
        private static List<ConversationAction> getActionsFromBundleArray(@Nullable Parcelable[] bundles) {
            if (bundles == null) {
                return null;
            }
            ArrayList<ConversationAction> actions = new ArrayList<ConversationAction>(bundles.length);
            for (Parcelable element : bundles) {
                ConversationAction action;
                if (!(element instanceof Bundle) || (action = ConversationAction.fromBundle((Bundle)element)) == null) continue;
                actions.add(action);
            }
            return actions;
        }

        private Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putInt(KEY_TYPE, this.mActionType);
            bundle.putParcelable(KEY_REMOTE_ACTION, (Parcelable)this.mRemoteAction);
            bundle.putParcelable(KEY_REMOTE_INPUT, (Parcelable)this.mRemoteInput);
            bundle.putBundle("extras", this.mExtras);
            return bundle;
        }

        @Nullable
        private static ConversationAction fromBundle(@Nullable Bundle bundle) {
            if (bundle == null || !bundle.containsKey(KEY_REMOTE_ACTION)) {
                return null;
            }
            ConversationAction action = new ConversationAction(bundle.getInt(KEY_TYPE), (RemoteAction)bundle.getParcelable(KEY_REMOTE_ACTION), (RemoteInput)bundle.getParcelable(KEY_REMOTE_INPUT));
            action.getExtras().putAll(bundle.getBundle("extras"));
            return action;
        }

        public int getActionType() {
            return this.mActionType;
        }

        @NonNull
        public RemoteAction getRemoteAction() {
            return this.mRemoteAction;
        }

        @Nullable
        public RemoteInput getRemoteInput() {
            return this.mRemoteInput;
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtras;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ActionType {
            public static final int ACTION_TYPE_NONE = 0;
            public static final int ACTION_TYPE_REPLY = 1;
            public static final int ACTION_TYPE_MARK_AS_READ = 2;
            public static final int ACTION_TYPE_MARK_AS_UNREAD = 3;
            public static final int ACTION_TYPE_DELETE = 4;
            public static final int ACTION_TYPE_ARCHIVE = 5;
            public static final int ACTION_TYPE_MUTE = 6;
            public static final int ACTION_TYPE_UNMUTE = 7;
        }
    }

    public static class Builder {
        @NonNull
        private final String mId;
        @NonNull
        private final Person mUser;
        @Nullable
        private String mConversationTitle;
        @Nullable
        private IconCompat mConversationIcon;
        @NonNull
        private List<Message> mMessages;
        @NonNull
        private List<Person> mParticipants;
        @Nullable
        private List<ConversationAction> mActions;
        private int mUnreadCount;
        private boolean mIsMuted;
        @NonNull
        private Bundle mExtras;

        private Builder(@NonNull Conversation conversation) {
            this.mUser = conversation.mUser;
            this.mId = conversation.mId;
            this.mMessages = conversation.mMessages;
            this.mConversationTitle = conversation.getConversationTitle();
            this.mConversationIcon = conversation.getConversationIcon();
            this.mParticipants = conversation.getParticipants();
            this.mActions = conversation.getActions();
            this.mUnreadCount = conversation.getUnreadCount();
            this.mIsMuted = conversation.isMuted();
            this.mExtras = conversation.getExtras();
        }

        public Builder(@NonNull Person user, @NonNull String conversationId) {
            this.mUser = user;
            this.mId = conversationId;
            this.mMessages = new ArrayList<Message>();
            this.mParticipants = new ArrayList<Person>();
            this.mExtras = new Bundle();
        }

        @NonNull
        public Builder setMessages(@NonNull List<Message> messages) {
            this.mMessages = messages;
            return this;
        }

        @NonNull
        public Builder setParticipants(@NonNull List<Person> participants) {
            this.mParticipants = participants;
            return this;
        }

        @NonNull
        public Builder setActions(@NonNull List<ConversationAction> actions) {
            this.mActions = actions;
            return this;
        }

        @NonNull
        public Builder setConversationTitle(@Nullable String conversationTitle) {
            this.mConversationTitle = conversationTitle;
            return this;
        }

        @NonNull
        public Builder setConversationIcon(@Nullable IconCompat conversationIcon) {
            this.mConversationIcon = conversationIcon;
            return this;
        }

        @NonNull
        public Builder setUnreadCount(int unreadCount) {
            this.mUnreadCount = unreadCount;
            return this;
        }

        @NonNull
        public Builder setMuted(boolean muted) {
            this.mIsMuted = muted;
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public Conversation build() {
            return new Conversation(this.mId, this.mUser, this.mConversationTitle, this.mConversationIcon, this.mMessages, this.mParticipants, this.mActions, this.mUnreadCount, this.mIsMuted, this.mExtras);
        }
    }
}

