/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.ArrayRes;
import androidx.annotation.AttrRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.view.OneShotPreDrawListener;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.FocusParkingView;
import com.android.car.ui.R;
import com.android.car.ui.core.CarUi;
import com.android.car.ui.recyclerview.CarUiContentListItem;
import com.android.car.ui.recyclerview.CarUiListItem;
import com.android.car.ui.recyclerview.CarUiListItemAdapter;
import com.android.car.ui.recyclerview.CarUiRadioButtonListItem;
import com.android.car.ui.recyclerview.CarUiRadioButtonListItemAdapter;
import com.android.car.ui.utils.CarUiUtils;
import java.util.ArrayList;
import java.util.List;

public class AlertDialogBuilder {
    private AlertDialog.Builder mBuilder;
    private AlertDialog mDialog;
    private Context mContext;
    private boolean mPositiveButtonSet;
    private boolean mNeutralButtonSet;
    private boolean mNegativeButtonSet;
    private CharSequence mTitle;
    private CharSequence mSubtitle;
    private Drawable mIcon;
    private boolean mIconTinted;
    private EditText mCarUiEditText;
    private InputMethodManager mInputMethodManager;
    private String mWideScreenTitle;
    private String mWideScreenTitleDesc;
    private ViewGroup mRoot;
    private boolean mAllowDismissButton = true;
    private boolean mHasSingleChoiceBodyButton = false;
    private final TextWatcher mTextWatcherWideScreen = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (Build.VERSION.SDK_INT >= 30) {
                Bundle bundle = new Bundle();
                String titleString = AlertDialogBuilder.this.mWideScreenTitle != null ? AlertDialogBuilder.this.mWideScreenTitle : AlertDialogBuilder.this.mTitle.toString();
                bundle.putString("add_desc_title_to_content_area", titleString);
                bundle.putString("add_desc_to_content_area", s.toString());
                AlertDialogBuilder.this.mInputMethodManager.sendAppPrivateCommand((View)AlertDialogBuilder.this.mCarUiEditText, "automotive_wide_screen", bundle);
            }
        }

        public void afterTextChanged(Editable s) {
        }
    };
    private final View.OnApplyWindowInsetsListener mOnApplyWindowInsetsListener = (v, insets) -> {
        if (Build.VERSION.SDK_INT < 30) {
            return v.onApplyWindowInsets(insets);
        }
        if (insets.isVisible(WindowInsets.Type.ime())) {
            Bundle bundle = new Bundle();
            String title = this.mWideScreenTitle != null ? this.mWideScreenTitle : this.mTitle.toString();
            bundle.putString("add_desc_title_to_content_area", title);
            if (this.mWideScreenTitleDesc != null) {
                bundle.putString("add_desc_to_content_area", this.mWideScreenTitleDesc);
            }
            this.mInputMethodManager.sendAppPrivateCommand((View)this.mCarUiEditText, "automotive_wide_screen", bundle);
        }
        return v.onApplyWindowInsets(insets);
    };
    private final DialogInterface.OnDismissListener mOnDismissListener = dialog -> {
        if (this.mRoot != null) {
            this.mRoot.setOnApplyWindowInsetsListener(null);
        }
    };

    public AlertDialogBuilder(Context context) {
        this(context, 0);
    }

    public AlertDialogBuilder(Context context, int themeResId) {
        this.mBuilder = new AlertDialog.Builder(context, themeResId);
        this.mInputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        this.mContext = context;
    }

    public Context getContext() {
        return this.mBuilder.getContext();
    }

    public AlertDialogBuilder setTitle(@StringRes int titleId) {
        return this.setTitle(this.mContext.getText(titleId));
    }

    public AlertDialogBuilder setTitle(CharSequence title) {
        this.mTitle = title;
        this.mBuilder.setTitle(title);
        return this;
    }

    public AlertDialogBuilder setSubtitle(@StringRes int subtitle) {
        return this.setSubtitle(this.mContext.getString(subtitle));
    }

    public AlertDialogBuilder setSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
        return this;
    }

    public AlertDialogBuilder setMessage(@StringRes int messageId) {
        this.mBuilder.setMessage(messageId);
        return this;
    }

    public AlertDialogBuilder setMessage(CharSequence message) {
        this.mBuilder.setMessage(message);
        return this;
    }

    public AlertDialogBuilder setIcon(@DrawableRes int iconId) {
        return this.setIcon(this.mContext.getDrawable(iconId));
    }

    public AlertDialogBuilder setIcon(Drawable icon) {
        this.mIcon = icon;
        return this;
    }

    public AlertDialogBuilder setIconTinted(boolean tinted) {
        this.mIconTinted = tinted;
        return this;
    }

    public AlertDialogBuilder setIconAttribute(@AttrRes int attrId) {
        this.mBuilder.setIconAttribute(attrId);
        return this;
    }

    public AlertDialogBuilder setPositiveButton(@StringRes int textId, DialogInterface.OnClickListener listener) {
        this.mBuilder.setPositiveButton(textId, listener);
        this.mPositiveButtonSet = true;
        return this;
    }

    public AlertDialogBuilder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setPositiveButton(text, listener);
        this.mPositiveButtonSet = true;
        return this;
    }

    public AlertDialogBuilder setNegativeButton(@StringRes int textId, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(textId, listener);
        this.mNegativeButtonSet = true;
        return this;
    }

    public AlertDialogBuilder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(text, listener);
        this.mNegativeButtonSet = true;
        return this;
    }

    public AlertDialogBuilder setNeutralButton(@StringRes int textId, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNeutralButton(textId, listener);
        this.mNeutralButtonSet = true;
        return this;
    }

    public AlertDialogBuilder setNeutralButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNeutralButton(text, listener);
        this.mNeutralButtonSet = true;
        return this;
    }

    public AlertDialogBuilder setCancelable(boolean cancelable) {
        this.mBuilder.setCancelable(cancelable);
        return this;
    }

    public AlertDialogBuilder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        this.mBuilder.setOnCancelListener(onCancelListener);
        return this;
    }

    public AlertDialogBuilder setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mBuilder.setOnDismissListener(onDismissListener);
        return this;
    }

    public AlertDialogBuilder setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        this.mBuilder.setOnKeyListener(onKeyListener);
        return this;
    }

    public AlertDialogBuilder setItems(@ArrayRes int itemsId, DialogInterface.OnClickListener listener) {
        this.mBuilder.setItems(itemsId, listener);
        this.mHasSingleChoiceBodyButton = true;
        return this;
    }

    public AlertDialogBuilder setItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
        this.mBuilder.setItems(items, listener);
        this.mHasSingleChoiceBodyButton = true;
        return this;
    }

    public AlertDialogBuilder setItems(List<? extends CarUiListItem> items) {
        this.setCustomList(CarUi.createListItemAdapter(this.getContext(), items));
        this.mHasSingleChoiceBodyButton = true;
        return this;
    }

    @Deprecated
    public AlertDialogBuilder setAdapter(ListAdapter adapter, DialogInterface.OnClickListener listener) {
        this.mBuilder.setAdapter(adapter, listener);
        this.mHasSingleChoiceBodyButton = true;
        return this;
    }

    @Deprecated
    public AlertDialogBuilder setAdapter(CarUiListItemAdapter adapter) {
        this.setCustomList(adapter);
        this.mHasSingleChoiceBodyButton = true;
        return this;
    }

    private void setCustomList(@NonNull RecyclerView.Adapter<? extends RecyclerView.ViewHolder> adapter) {
        View customList = LayoutInflater.from((Context)this.mContext).inflate(R.layout.car_ui_alert_dialog_list, null);
        RecyclerView list = (RecyclerView)CarUiUtils.requireViewByRefId(customList, R.id.list);
        list.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        list.setAdapter(adapter);
        list.setFocusable(false);
        this.mBuilder.setView(customList);
    }

    public AlertDialogBuilder setCursor(Cursor cursor, DialogInterface.OnClickListener listener, String labelColumn) {
        this.mBuilder.setCursor(cursor, listener, labelColumn);
        this.mHasSingleChoiceBodyButton = true;
        return this;
    }

    public AlertDialogBuilder setMultiChoiceItems(@ArrayRes int itemsId, @Nullable boolean[] checkedItems, @Nullable DialogInterface.OnMultiChoiceClickListener listener) {
        CharSequence[] itemText = this.mContext.getResources().getTextArray(itemsId);
        return this.setMultiChoiceItems(itemText, checkedItems, listener);
    }

    public AlertDialogBuilder setMultiChoiceItems(@NonNull CharSequence[] items, @Nullable boolean[] checkedItems, @Nullable DialogInterface.OnMultiChoiceClickListener listener) {
        ArrayList<CarUiContentListItem> carUiItems = new ArrayList<CarUiContentListItem>();
        int i = 0;
        while (i < items.length) {
            CarUiContentListItem item = new CarUiContentListItem(CarUiContentListItem.Action.CHECK_BOX);
            item.setTitle(items[i]);
            if (checkedItems != null) {
                item.setChecked(checkedItems[i]);
            }
            int index = i++;
            item.setOnCheckedChangeListener((item1, isChecked) -> {
                if (listener != null) {
                    listener.onClick((DialogInterface)this.mDialog, index, isChecked);
                }
            });
            carUiItems.add(item);
        }
        this.setAdapter(new CarUiListItemAdapter(carUiItems));
        this.mHasSingleChoiceBodyButton = false;
        return this;
    }

    public AlertDialogBuilder setMultiChoiceItems(@NonNull Cursor cursor, String isCheckedColumn, String labelColumn, DialogInterface.OnMultiChoiceClickListener listener) {
        int size = cursor.getCount();
        CharSequence[] items = new CharSequence[size];
        boolean[] checkedItems = new boolean[size];
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            int index = cursor.getPosition();
            String text = cursor.getString(cursor.getColumnIndexOrThrow(labelColumn));
            int isCheckedColumnIndex = cursor.getColumnIndex(isCheckedColumn);
            int isChecked = isCheckedColumnIndex >= 0 ? cursor.getInt(isCheckedColumnIndex) : 0;
            items[index] = text;
            checkedItems[index] = isChecked != 0;
            cursor.moveToNext();
        }
        return this.setMultiChoiceItems(items, checkedItems, listener);
    }

    public AlertDialogBuilder setSingleChoiceItems(@ArrayRes int itemsId, int checkedItem, DialogInterface.OnClickListener listener) {
        CharSequence[] itemText = this.mContext.getResources().getTextArray(itemsId);
        return this.setSingleChoiceItems(itemText, checkedItem, listener);
    }

    public AlertDialogBuilder setSingleChoiceItems(Cursor cursor, int checkedItem, String labelColumn, DialogInterface.OnClickListener listener) {
        int size = cursor.getCount();
        CharSequence[] items = new CharSequence[size];
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            int index = cursor.getPosition();
            String text = cursor.getString(cursor.getColumnIndexOrThrow(labelColumn));
            items[index] = text;
            cursor.moveToNext();
        }
        return this.setSingleChoiceItems(items, checkedItem, listener);
    }

    public AlertDialogBuilder setSingleChoiceItems(CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener) {
        ArrayList<CarUiRadioButtonListItem> carUiItems = new ArrayList<CarUiRadioButtonListItem>();
        int i = 0;
        while (i < items.length) {
            CarUiRadioButtonListItem item = new CarUiRadioButtonListItem();
            item.setTitle(items[i]);
            item.setChecked(i == checkedItem);
            int index = i++;
            item.setOnCheckedChangeListener((item1, isChecked) -> {
                if (listener != null) {
                    listener.onClick((DialogInterface)this.mDialog, index);
                }
            });
            carUiItems.add(item);
        }
        this.setAdapter(new CarUiRadioButtonListItemAdapter((List<CarUiRadioButtonListItem>)carUiItems));
        this.mHasSingleChoiceBodyButton = true;
        return this;
    }

    @Deprecated
    public AlertDialogBuilder setSingleChoiceItems(ListAdapter adapter, int checkedItem, DialogInterface.OnClickListener listener) {
        this.mBuilder.setSingleChoiceItems(adapter, checkedItem, listener);
        this.mHasSingleChoiceBodyButton = true;
        return this;
    }

    @Deprecated
    public AlertDialogBuilder setSingleChoiceItems(CarUiRadioButtonListItemAdapter adapter, DialogInterface.OnClickListener listener) {
        this.setCustomList(adapter);
        this.mHasSingleChoiceBodyButton = false;
        return this;
    }

    public AlertDialogBuilder setSingleChoiceItems(CarUiRadioButtonListItemAdapter adapter) {
        this.setCustomList(adapter);
        this.mHasSingleChoiceBodyButton = false;
        return this;
    }

    public AlertDialogBuilder setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        this.mBuilder.setOnItemSelectedListener(listener);
        this.mHasSingleChoiceBodyButton = true;
        return this;
    }

    public AlertDialogBuilder setEditBox(String prompt, TextWatcher textChangedListener, InputFilter[] inputFilters, int inputType) {
        View contentView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.car_ui_alert_dialog_edit_text, null);
        this.mCarUiEditText = (EditText)CarUiUtils.requireViewByRefId(contentView, R.id.textbox);
        this.mCarUiEditText.setText((CharSequence)prompt);
        if (textChangedListener != null) {
            this.mCarUiEditText.addTextChangedListener(textChangedListener);
        }
        if (inputFilters != null) {
            this.mCarUiEditText.setFilters(inputFilters);
        }
        if (inputType != 0) {
            this.mCarUiEditText.setInputType(inputType);
        }
        this.mBuilder.setView(contentView);
        return this;
    }

    public AlertDialogBuilder setEditBox(String prompt, TextWatcher textChangedListener, InputFilter[] inputFilters) {
        return this.setEditBox(prompt, textChangedListener, inputFilters, 0);
    }

    public AlertDialogBuilder setEditTextTitleAndDescForWideScreen(String title, String desc) {
        this.mWideScreenTitle = title;
        this.mWideScreenTitleDesc = desc;
        return this;
    }

    public AlertDialogBuilder setAutoDescUpdateForWidescreen(boolean autoUpdateDesc) {
        if (autoUpdateDesc) {
            this.mCarUiEditText.addTextChangedListener(this.mTextWatcherWideScreen);
        } else {
            this.mCarUiEditText.removeTextChangedListener(this.mTextWatcherWideScreen);
        }
        return this;
    }

    public AlertDialogBuilder setAllowDismissButton(boolean allowDismissButton) {
        this.mAllowDismissButton = allowDismissButton;
        return this;
    }

    private void prepareDialog() {
        View customTitle = LayoutInflater.from((Context)this.mContext).inflate(R.layout.car_ui_alert_dialog_title_with_subtitle, null);
        TextView mTitleView = (TextView)CarUiUtils.requireViewByRefId(customTitle, R.id.car_ui_alert_title);
        TextView mSubtitleView = (TextView)CarUiUtils.requireViewByRefId(customTitle, R.id.car_ui_alert_subtitle);
        mSubtitleView.setMovementMethod(LinkMovementMethod.getInstance());
        OneShotPreDrawListener.add((View)mSubtitleView, () -> {
            ClickableSpan[] spans = (ClickableSpan[])((SpannableString)mSubtitleView.getText()).getSpans(0, mSubtitleView.getText().length(), ClickableSpan.class);
            if (spans.length == 0) {
                mSubtitleView.setFocusable(false);
            }
        });
        ImageView mIconView = (ImageView)CarUiUtils.requireViewByRefId(customTitle, R.id.car_ui_alert_icon);
        mTitleView.setText(this.mTitle);
        mTitleView.setVisibility(TextUtils.isEmpty((CharSequence)this.mTitle) ? 8 : 0);
        mSubtitleView.setText(this.mSubtitle);
        mSubtitleView.setVisibility(TextUtils.isEmpty((CharSequence)this.mSubtitle) ? 8 : 0);
        mIconView.setImageDrawable(this.mIcon);
        mIconView.setVisibility(this.mIcon != null ? 0 : 8);
        if (this.mIconTinted) {
            mIconView.setImageTintList(this.mContext.getColorStateList(R.color.car_ui_dialog_icon_color));
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTitle) || !TextUtils.isEmpty((CharSequence)this.mSubtitle) || this.mIcon != null) {
            this.mBuilder.setCustomTitle(customTitle);
        }
        if (!(this.mAllowDismissButton || this.mHasSingleChoiceBodyButton || this.mNeutralButtonSet || this.mNegativeButtonSet || this.mPositiveButtonSet)) {
            throw new RuntimeException("The dialog must have at least one button to disable the dismiss button");
        }
        if (this.mContext.getResources().getBoolean(R.bool.car_ui_alert_dialog_force_dismiss_button) && !this.mNeutralButtonSet && !this.mNegativeButtonSet && !this.mPositiveButtonSet && this.mAllowDismissButton) {
            String mDefaultButtonText = this.mContext.getString(R.string.car_ui_alert_dialog_default_button);
            this.mBuilder.setNegativeButton((CharSequence)mDefaultButtonText, (dialog, which) -> {});
        }
    }

    public AlertDialog create() {
        this.prepareDialog();
        this.mDialog = this.mBuilder.create();
        this.mRoot = (ViewGroup)this.mDialog.getWindow().getDecorView().getRootView();
        FocusParkingView fpv = new FocusParkingView(this.mContext);
        this.mRoot.addView((View)fpv);
        this.mRoot.setOnApplyWindowInsetsListener(this.mOnApplyWindowInsetsListener);
        this.setOnDismissListener(this.mOnDismissListener);
        return this.mDialog;
    }

    public AlertDialog show() {
        this.mDialog = this.create();
        this.mDialog.show();
        return this.mDialog;
    }
}

