/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatViewInflater;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.pluginsupport.PluginFactorySingleton;
import com.android.car.ui.preference.CarUiPreferenceViewStub;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.widget.CarUiTextView;

public class CarUiLayoutInflaterFactory
extends AppCompatViewInflater
implements LayoutInflater.Factory2 {
    @Nullable
    protected View createView(Context context, String name, AttributeSet attrs) {
        Object view = null;
        if (CarUiRecyclerView.class.getName().equals(name)) {
            view = PluginFactorySingleton.get(context).createRecyclerView(context, attrs).getView();
        } else if (name.contentEquals("CarUiTextView")) {
            view = PluginFactorySingleton.get(context).createTextView(context, attrs);
        } else if ("androidx.recyclerview.widget.RecyclerView".equals(name)) {
            view = new RecyclerView(context, attrs);
        } else if ("TextView".equals(name)) {
            view = PluginFactorySingleton.get(context).createTextView(context, attrs);
        } else if (CarUiPreferenceViewStub.class.getName().equals(name)) {
            view = PluginFactorySingleton.get(context).createCarUiPreferenceView(context, attrs);
        }
        return view;
    }

    @NonNull
    protected AppCompatTextView createTextView(Context context, AttributeSet attrs) {
        return CarUiTextView.create(context, attrs);
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return null;
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        return this.createView(context, name, attrs);
    }
}

