/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.text.SpannableStringBuilder;
import androidx.annotation.NonNull;
import java.util.Collections;
import java.util.List;

public class CarUiText {
    private final int mMaxLines;
    private final int mMaxChars;
    private final List<CharSequence> mVariants;

    public static CharSequence combineMultiLine(@NonNull List<CarUiText> lines) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        String delimiter = "";
        for (CarUiText line : lines) {
            builder.append((CharSequence)delimiter).append(line.getPreferredText() == null ? " " : line.getPreferredText());
            delimiter = "\n";
        }
        return builder;
    }

    private CarUiText(Builder builder) {
        this.mVariants = builder.mVariants;
        this.mMaxChars = builder.mMaxChars;
        this.mMaxLines = builder.mMaxLines;
    }

    @Deprecated
    public CarUiText(@NonNull CharSequence text) {
        this(text, Integer.MAX_VALUE);
    }

    @Deprecated
    public CarUiText(@NonNull CharSequence text, int maxLines) {
        this.mVariants = Collections.singletonList(text);
        this.mMaxLines = maxLines;
        this.mMaxChars = Integer.MAX_VALUE;
    }

    @Deprecated
    public CarUiText(@NonNull List<CharSequence> variants, int maxLines) {
        this.mVariants = variants;
        this.mMaxLines = maxLines;
        this.mMaxChars = Integer.MAX_VALUE;
    }

    @Deprecated
    public CarUiText(@NonNull List<CharSequence> variants, int maxLines, int maxChars) {
        this.mVariants = variants;
        this.mMaxLines = maxLines;
        this.mMaxChars = maxChars;
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public int getMaxChars() {
        return this.mMaxChars;
    }

    public List<CharSequence> getTextVariants() {
        return this.mVariants;
    }

    public CharSequence getPreferredText() {
        return this.mVariants.get(0);
    }

    public static final class Builder {
        private int mMaxLines = Integer.MAX_VALUE;
        private int mMaxChars = Integer.MAX_VALUE;
        private final List<CharSequence> mVariants;

        public Builder(@NonNull CharSequence text) {
            this(Collections.singletonList(text));
        }

        public Builder(@NonNull List<CharSequence> variants) {
            this.mVariants = variants;
        }

        public Builder setMaxChars(int chars) {
            this.mMaxChars = chars;
            return this;
        }

        public Builder setMaxLines(int lines) {
            this.mMaxLines = lines;
            return this;
        }

        public CarUiText build() {
            return new CarUiText(this);
        }
    }
}

