/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.FocusFinder;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.android.car.ui.FocusAreaHelper;
import com.android.car.ui.IFocusArea;

public class ConstraintFocusArea
extends ConstraintLayout
implements IFocusArea {
    @NonNull
    private final FocusAreaHelper mFocusAreaHelper;

    public ConstraintFocusArea(Context context) {
        this(context, null);
    }

    public ConstraintFocusArea(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ConstraintFocusArea(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ConstraintFocusArea(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mFocusAreaHelper = new FocusAreaHelper((ViewGroup)this, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mFocusAreaHelper.onFinishInflate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mFocusAreaHelper.onLayout();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFocusAreaHelper.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.mFocusAreaHelper.onDetachedFromWindow();
        super.onDetachedFromWindow();
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (!this.mFocusAreaHelper.onWindowFocusChanged(this.hasWindowFocus())) {
            super.onWindowFocusChanged(hasWindowFocus);
        }
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (this.mFocusAreaHelper.isFocusAreaAction(action)) {
            return this.mFocusAreaHelper.performAccessibilityAction(action, arguments);
        }
        return super.performAccessibilityAction(action, arguments);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mFocusAreaHelper.onDraw(canvas);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.mFocusAreaHelper.draw(canvas);
    }

    public CharSequence getAccessibilityClassName() {
        return "com.android.car.ui.FocusArea";
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        this.mFocusAreaHelper.onInitializeAccessibilityNodeInfo(info);
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        if (this.isInTouchMode()) {
            return super.onRequestFocusInDescendants(direction, previouslyFocusedRect);
        }
        return this.mFocusAreaHelper.onRequestFocusInDescendants();
    }

    public boolean restoreDefaultFocus() {
        return this.mFocusAreaHelper.restoreDefaultFocus();
    }

    public View focusSearch(View focused, int direction) {
        if (this.mFocusAreaHelper.isWrapAround()) {
            return FocusFinder.getInstance().findNextFocus((ViewGroup)this, focused, direction);
        }
        return super.focusSearch(focused, direction);
    }

    @Override
    @VisibleForTesting
    @NonNull
    public FocusAreaHelper getHelper() {
        return this.mFocusAreaHelper;
    }

    @Override
    public View getDefaultFocusView() {
        return this.mFocusAreaHelper.getDefaultFocusView();
    }

    @Override
    public void setDefaultFocus(@NonNull View defaultFocus) {
        this.mFocusAreaHelper.setDefaultFocus(defaultFocus);
    }

    @Override
    public void setHighlightPadding(int left, int top, int right, int bottom) {
        this.mFocusAreaHelper.setHighlightPadding(left, top, right, bottom);
    }

    @Override
    public void setBoundsOffset(int left, int top, int right, int bottom) {
        this.mFocusAreaHelper.setBoundsOffset(left, top, right, bottom);
    }

    @Override
    public void setWrapAround(boolean wrapAround) {
        this.mFocusAreaHelper.setWrapAround(wrapAround);
    }

    @Override
    public void setNudgeShortcut(int direction, @Nullable View view) {
        this.mFocusAreaHelper.setNudgeShortcut(direction, view);
    }

    @Override
    public void setNudgeTargetFocusArea(int direction, @Nullable IFocusArea target) {
        this.mFocusAreaHelper.setNudgeTargetFocusArea(direction, target);
    }

    @Override
    public void setNudgeEnabled(int direction, boolean enable) {
        this.mFocusAreaHelper.setNudgeEnabled(direction, enable);
    }

    @Override
    public void setDefaultFocusOverridesHistory(boolean override) {
        this.mFocusAreaHelper.setDefaultFocusOverridesHistory(override);
    }
}

