/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.android.car.ui.FocusParkingView;
import com.android.car.ui.IFocusArea;
import com.android.car.ui.R;
import com.android.car.ui.RotaryCache;
import com.android.car.ui.utils.ViewUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class FocusAreaHelper {
    private static final String TAG = "FocusAreaHelper";
    private static final int INVALID_DIMEN = -1;
    private static final int INVALID_DIRECTION = -1;
    private static final List<Integer> NUDGE_DIRECTIONS = Arrays.asList(17, 66, 33, 130);
    private static final List<Integer> FOCUS_AREA_ACTIONS = Arrays.asList(1, 0x1000000, 0x2000000, 0x20000000);
    @NonNull
    private final ViewGroup mFocusArea;
    private boolean mHasFocus;
    private boolean mEnableForegroundHighlight;
    private boolean mEnableBackgroundHighlight;
    private Drawable mForegroundHighlight;
    private Drawable mBackgroundHighlight;
    private int mPaddingLeft;
    private int mPaddingRight;
    private int mPaddingTop;
    private int mPaddingBottom;
    private int mLeftOffset;
    private int mRightOffset;
    private int mTopOffset;
    private int mBottomOffset;
    private boolean mRtl;
    private int mDefaultFocusId = -1;
    @Nullable
    private View mDefaultFocusView;
    private boolean mDefaultFocusOverridesHistory;
    private final SparseIntArray mSpecifiedNudgeShortcutIdMap = new SparseIntArray();
    private SparseArray<View> mSpecifiedNudgeShortcutMap;
    private final SparseIntArray mSpecifiedNudgeIdMap = new SparseIntArray();
    private SparseArray<IFocusArea> mSpecifiedNudgeFocusAreaMap;
    private final Set<Integer> mDisabledNudgeDirections = new HashSet<Integer>();
    private boolean mWrapAround;
    private RotaryCache mRotaryCache;
    private boolean mClearFocusAreaHistoryWhenRotating;
    private IFocusArea mPreviousFocusArea;
    private View mFocusedView;
    private final ViewTreeObserver.OnGlobalFocusChangeListener mFocusChangeListener;
    private final ViewTreeObserver.OnTouchModeChangeListener mTouchModeChangeListener;
    private boolean mShouldRestoreFocus = true;
    private final long mTouchModeSkipRestoreFocusMs;
    private long mSkipRestoreFocusUntil;

    FocusAreaHelper(@NonNull ViewGroup viewGroup, @Nullable AttributeSet attrs) {
        this.mFocusArea = viewGroup;
        this.mFocusChangeListener = (oldFocus, newFocus) -> {
            boolean hasFocus = this.mFocusArea.hasFocus();
            this.saveFocusHistory(hasFocus);
            this.maybeUpdatePreviousFocusArea(hasFocus, oldFocus);
            this.maybeClearFocusAreaHistory(hasFocus, oldFocus);
            this.maybeUpdateFocusAreaHighlight(hasFocus);
            this.mHasFocus = hasFocus;
        };
        Context context = this.mFocusArea.getContext();
        Resources resources = context.getResources();
        this.mEnableForegroundHighlight = resources.getBoolean(R.bool.car_ui_enable_focus_area_foreground_highlight);
        this.mEnableBackgroundHighlight = resources.getBoolean(R.bool.car_ui_enable_focus_area_background_highlight);
        this.mForegroundHighlight = resources.getDrawable(R.drawable.car_ui_focus_area_foreground_highlight, context.getTheme());
        this.mBackgroundHighlight = resources.getDrawable(R.drawable.car_ui_focus_area_background_highlight, context.getTheme());
        this.mClearFocusAreaHistoryWhenRotating = resources.getBoolean(R.bool.car_ui_clear_focus_area_history_when_rotating);
        int focusHistoryCacheType = resources.getInteger(R.integer.car_ui_focus_history_cache_type);
        int focusHistoryExpirationPeriodMs = resources.getInteger(R.integer.car_ui_focus_history_expiration_period_ms);
        int focusAreaHistoryCacheType = resources.getInteger(R.integer.car_ui_focus_area_history_cache_type);
        int focusAreaHistoryExpirationPeriodMs = resources.getInteger(R.integer.car_ui_focus_area_history_expiration_period_ms);
        this.mRotaryCache = new RotaryCache(focusHistoryCacheType, focusHistoryExpirationPeriodMs, focusAreaHistoryCacheType, focusAreaHistoryExpirationPeriodMs);
        this.mTouchModeSkipRestoreFocusMs = resources.getInteger(R.integer.car_ui_touch_mode_skip_restore_focus_ms);
        this.mTouchModeChangeListener = isInTouchMode -> {
            if (!isInTouchMode) {
                this.mSkipRestoreFocusUntil = SystemClock.uptimeMillis() + this.mTouchModeSkipRestoreFocusMs;
            }
        };
        this.mFocusArea.setImportantForAccessibility(1);
        this.mFocusArea.setWillNotDraw(false);
        this.initAttrs(context, attrs);
    }

    private void saveFocusHistory(boolean hasFocus) {
        if (!hasFocus) {
            if (this.mHasFocus) {
                this.mRotaryCache.saveFocusedView(this.mFocusedView, SystemClock.uptimeMillis());
                this.mFocusedView = null;
            }
            return;
        }
        View v = this.mFocusArea.getFocusedChild();
        while (v != null && !v.isFocused()) {
            v = v instanceof ViewGroup ? ((ViewGroup)v).getFocusedChild() : null;
        }
        this.mFocusedView = v;
    }

    private void maybeUpdatePreviousFocusArea(boolean hasFocus, View oldFocus) {
        if (this.mHasFocus || !hasFocus || oldFocus == null || oldFocus instanceof FocusParkingView) {
            this.mPreviousFocusArea = null;
            return;
        }
        this.mPreviousFocusArea = ViewUtils.getAncestorFocusArea(oldFocus);
        if (this.mPreviousFocusArea == null) {
            Log.w((String)TAG, (String)("No ancestor focus area for " + oldFocus));
        }
    }

    private void maybeClearFocusAreaHistory(boolean hasFocus, View oldFocus) {
        if (!this.mClearFocusAreaHistoryWhenRotating) {
            return;
        }
        if (!hasFocus || oldFocus == null) {
            return;
        }
        IFocusArea oldFocusArea = ViewUtils.getAncestorFocusArea(oldFocus);
        if (oldFocusArea != this.mFocusArea) {
            return;
        }
        this.mRotaryCache.clearFocusAreaHistory();
    }

    private void maybeUpdateFocusAreaHighlight(boolean hasFocus) {
        if (!this.mEnableBackgroundHighlight && !this.mEnableForegroundHighlight) {
            return;
        }
        if (this.mHasFocus != hasFocus) {
            this.mFocusArea.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(Context context, @Nullable AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IFocusArea);
        try {
            int nudgeShortcutDirection;
            int nudgeShortcutId;
            int endOffset;
            int startOffset;
            int paddingEnd;
            this.mDefaultFocusId = a.getResourceId(R.styleable.IFocusArea_defaultFocus, -1);
            int paddingStart = a.getDimensionPixelSize(R.styleable.IFocusArea_highlightPaddingStart, -1);
            if (paddingStart == -1) {
                paddingStart = a.getDimensionPixelSize(R.styleable.IFocusArea_highlightPaddingHorizontal, 0);
            }
            if ((paddingEnd = a.getDimensionPixelSize(R.styleable.IFocusArea_highlightPaddingEnd, -1)) == -1) {
                paddingEnd = a.getDimensionPixelSize(R.styleable.IFocusArea_highlightPaddingHorizontal, 0);
            }
            this.mRtl = this.mFocusArea.getLayoutDirection() == 1;
            this.mPaddingLeft = this.mRtl ? paddingEnd : paddingStart;
            this.mPaddingRight = this.mRtl ? paddingStart : paddingEnd;
            this.mPaddingTop = a.getDimensionPixelSize(R.styleable.IFocusArea_highlightPaddingTop, -1);
            if (this.mPaddingTop == -1) {
                this.mPaddingTop = a.getDimensionPixelSize(R.styleable.IFocusArea_highlightPaddingVertical, 0);
            }
            this.mPaddingBottom = a.getDimensionPixelSize(R.styleable.IFocusArea_highlightPaddingBottom, -1);
            if (this.mPaddingBottom == -1) {
                this.mPaddingBottom = a.getDimensionPixelSize(R.styleable.IFocusArea_highlightPaddingVertical, 0);
            }
            if ((startOffset = a.getDimensionPixelSize(R.styleable.IFocusArea_startBoundOffset, -1)) == -1) {
                startOffset = a.getDimensionPixelSize(R.styleable.IFocusArea_horizontalBoundOffset, paddingStart);
            }
            if ((endOffset = a.getDimensionPixelSize(R.styleable.IFocusArea_endBoundOffset, -1)) == -1) {
                endOffset = a.getDimensionPixelSize(R.styleable.IFocusArea_horizontalBoundOffset, paddingEnd);
            }
            this.mLeftOffset = this.mRtl ? endOffset : startOffset;
            this.mRightOffset = this.mRtl ? startOffset : endOffset;
            this.mTopOffset = a.getDimensionPixelSize(R.styleable.IFocusArea_topBoundOffset, -1);
            if (this.mTopOffset == -1) {
                this.mTopOffset = a.getDimensionPixelSize(R.styleable.IFocusArea_verticalBoundOffset, this.mPaddingTop);
            }
            this.mBottomOffset = a.getDimensionPixelSize(R.styleable.IFocusArea_bottomBoundOffset, -1);
            if (this.mBottomOffset == -1) {
                this.mBottomOffset = a.getDimensionPixelSize(R.styleable.IFocusArea_verticalBoundOffset, this.mPaddingBottom);
            }
            if (a.hasValue(R.styleable.IFocusArea_nudgeLeftShortcut)) {
                this.mSpecifiedNudgeShortcutIdMap.put(17, a.getResourceId(R.styleable.IFocusArea_nudgeLeftShortcut, -1));
            }
            if (a.hasValue(R.styleable.IFocusArea_nudgeRightShortcut)) {
                this.mSpecifiedNudgeShortcutIdMap.put(66, a.getResourceId(R.styleable.IFocusArea_nudgeRightShortcut, -1));
            }
            if (a.hasValue(R.styleable.IFocusArea_nudgeUpShortcut)) {
                this.mSpecifiedNudgeShortcutIdMap.put(33, a.getResourceId(R.styleable.IFocusArea_nudgeUpShortcut, -1));
            }
            if (a.hasValue(R.styleable.IFocusArea_nudgeDownShortcut)) {
                this.mSpecifiedNudgeShortcutIdMap.put(130, a.getResourceId(R.styleable.IFocusArea_nudgeDownShortcut, -1));
            }
            if ((nudgeShortcutId = a.getResourceId(R.styleable.IFocusArea_nudgeShortcut, -1)) == -1 ^ (nudgeShortcutDirection = a.getInt(R.styleable.IFocusArea_nudgeShortcutDirection, -1)) == -1) {
                throw new IllegalStateException("nudgeShortcut and nudgeShortcutDirection must be specified together");
            }
            if (nudgeShortcutId != -1) {
                if (this.mSpecifiedNudgeShortcutIdMap.size() > 0) {
                    throw new IllegalStateException("Don't use nudgeShortcut/nudgeShortcutDirection and nudge*Shortcut in the same focus area. Use nudge*Shortcut only.");
                }
                this.mSpecifiedNudgeShortcutIdMap.put(nudgeShortcutDirection, nudgeShortcutId);
            }
            if (a.hasValue(R.styleable.IFocusArea_nudgeLeft)) {
                this.mSpecifiedNudgeIdMap.put(17, a.getResourceId(R.styleable.IFocusArea_nudgeLeft, -1));
            }
            if (a.hasValue(R.styleable.IFocusArea_nudgeRight)) {
                this.mSpecifiedNudgeIdMap.put(66, a.getResourceId(R.styleable.IFocusArea_nudgeRight, -1));
            }
            if (a.hasValue(R.styleable.IFocusArea_nudgeUp)) {
                this.mSpecifiedNudgeIdMap.put(33, a.getResourceId(R.styleable.IFocusArea_nudgeUp, -1));
            }
            if (a.hasValue(R.styleable.IFocusArea_nudgeDown)) {
                this.mSpecifiedNudgeIdMap.put(130, a.getResourceId(R.styleable.IFocusArea_nudgeDown, -1));
            }
            if (a.getBoolean(R.styleable.IFocusArea_nudgeLeftDisabled, false)) {
                this.mDisabledNudgeDirections.add(17);
            }
            if (a.getBoolean(R.styleable.IFocusArea_nudgeRightDisabled, false)) {
                this.mDisabledNudgeDirections.add(66);
            }
            if (a.getBoolean(R.styleable.IFocusArea_nudgeUpDisabled, false)) {
                this.mDisabledNudgeDirections.add(33);
            }
            if (a.getBoolean(R.styleable.IFocusArea_nudgeDownDisabled, false)) {
                this.mDisabledNudgeDirections.add(130);
            }
            this.mDefaultFocusOverridesHistory = a.getBoolean(R.styleable.IFocusArea_defaultFocusOverridesHistory, false);
            this.mWrapAround = a.getBoolean(R.styleable.IFocusArea_wrapAround, false);
        }
        finally {
            a.recycle();
        }
    }

    void onFinishInflate() {
        if (this.mDefaultFocusId != -1) {
            this.mDefaultFocusView = this.mFocusArea.requireViewById(this.mDefaultFocusId);
        }
    }

    void onLayout() {
        boolean rtl;
        boolean bl = rtl = this.mFocusArea.getLayoutDirection() == 1;
        if (this.mRtl != rtl) {
            this.mRtl = rtl;
            int temp = this.mPaddingLeft;
            this.mPaddingLeft = this.mPaddingRight;
            this.mPaddingRight = temp;
            temp = this.mLeftOffset;
            this.mLeftOffset = this.mRightOffset;
            this.mRightOffset = temp;
        }
    }

    void onAttachedToWindow() {
        this.mFocusArea.getViewTreeObserver().addOnGlobalFocusChangeListener(this.mFocusChangeListener);
        this.mFocusArea.getViewTreeObserver().addOnTouchModeChangeListener(this.mTouchModeChangeListener);
        if (this.mShouldRestoreFocus && ViewUtils.isInMultiWindowMode((View)this.mFocusArea)) {
            this.mShouldRestoreFocus = false;
        }
    }

    void onDetachedFromWindow() {
        this.mFocusArea.getViewTreeObserver().removeOnTouchModeChangeListener(this.mTouchModeChangeListener);
        this.mFocusArea.getViewTreeObserver().removeOnGlobalFocusChangeListener(this.mFocusChangeListener);
        this.mRotaryCache.clearFocusAreaHistory();
        this.mRotaryCache.saveFocusedView(null, 0L);
    }

    boolean onWindowFocusChanged(boolean hasWindowFocus) {
        Log.d((String)TAG, (String)("The window of Activity [" + ViewUtils.findActivity(this.mFocusArea.getContext()) + (hasWindowFocus ? "] gained" : "] lost") + " focus"));
        if (hasWindowFocus && this.mShouldRestoreFocus && !this.mFocusArea.isInTouchMode()) {
            this.maybeInitFocus();
            return true;
        }
        return false;
    }

    private boolean maybeInitFocus() {
        View root = this.mFocusArea.getRootView();
        View focus = root.findFocus();
        return ViewUtils.initFocus(root, focus);
    }

    private boolean maybeAdjustFocus() {
        View root = this.mFocusArea.getRootView();
        View focus = root.findFocus();
        return ViewUtils.adjustFocus(root, focus);
    }

    boolean isFocusAreaAction(int action) {
        return FOCUS_AREA_ACTIONS.contains(action);
    }

    boolean performAccessibilityAction(int action, Bundle arguments) {
        switch (action) {
            case 1: {
                int direction;
                boolean success = this.focusOnDescendant();
                if (success && this.mPreviousFocusArea != null && (direction = FocusAreaHelper.getNudgeDirection(arguments)) != -1) {
                    this.saveFocusAreaHistory(direction, this.mPreviousFocusArea, (IFocusArea)this.mFocusArea, SystemClock.uptimeMillis());
                }
                return success;
            }
            case 0x1000000: {
                return this.nudgeToShortcutView(arguments);
            }
            case 0x2000000: {
                return this.nudgeToAnotherFocusArea(arguments);
            }
            case 0x20000000: {
                return this.isNudgeDisabled(FocusAreaHelper.getNudgeDirection(arguments));
            }
        }
        return false;
    }

    private boolean focusOnDescendant() {
        View lastFocusedView = this.mRotaryCache.getFocusedView(SystemClock.uptimeMillis());
        return ViewUtils.adjustFocusImmediately((View)this.mFocusArea, lastFocusedView, this.mDefaultFocusOverridesHistory);
    }

    private boolean nudgeToShortcutView(Bundle arguments) {
        int direction = FocusAreaHelper.getNudgeDirection(arguments);
        View targetView = this.getSpecifiedShortcut(direction);
        if (targetView == null) {
            return false;
        }
        if (targetView.isFocused()) {
            return false;
        }
        View focus = this.mFocusArea.findFocus();
        if (focus == null) {
            Log.e((String)TAG, (String)"Failed to nudge to nudge shortcut view because there is no focused view in this FocusArea");
            return false;
        }
        if (!ViewUtils.isCandidate(focus, targetView, direction)) {
            return false;
        }
        return ViewUtils.requestFocus(targetView);
    }

    private boolean nudgeToAnotherFocusArea(Bundle arguments) {
        boolean success;
        int direction = FocusAreaHelper.getNudgeDirection(arguments);
        if (this.isNudgeDisabled(direction)) {
            return false;
        }
        long elapsedRealtime = SystemClock.uptimeMillis();
        IFocusArea targetFocusArea = this.getSpecifiedFocusArea(direction);
        boolean bl = success = targetFocusArea != null && targetFocusArea.getHelper().focusOnDescendant();
        if (!success) {
            targetFocusArea = this.mRotaryCache.getCachedFocusArea(direction, elapsedRealtime);
            success = targetFocusArea != null && targetFocusArea.getHelper().focusOnDescendant();
        }
        return success;
    }

    private boolean isNudgeDisabled(int direction) {
        return this.mDisabledNudgeDirections.contains(direction);
    }

    private static int getNudgeDirection(Bundle arguments) {
        return arguments == null ? -1 : arguments.getInt("com.android.car.ui.utils.NUDGE_DIRECTION", -1);
    }

    private void saveFocusAreaHistory(int direction, @NonNull IFocusArea sourceFocusArea, @NonNull IFocusArea targetFocusArea, long elapsedRealtime) {
        FocusAreaHelper sourceHelper = sourceFocusArea.getHelper();
        if (sourceHelper.getCachedFocusArea(direction, elapsedRealtime) == null) {
            int oppositeDirection = FocusAreaHelper.getOppositeDirection(direction);
            FocusAreaHelper targetHelper = targetFocusArea.getHelper();
            targetHelper.saveFocusArea(oppositeDirection, sourceFocusArea, elapsedRealtime);
        }
    }

    @Nullable
    IFocusArea getCachedFocusArea(int direction, long elapsedRealtime) {
        return this.mRotaryCache.getCachedFocusArea(direction, elapsedRealtime);
    }

    void saveFocusArea(int direction, @NonNull IFocusArea targetFocusArea, long elapsedRealtime) {
        this.mRotaryCache.saveFocusArea(direction, targetFocusArea, elapsedRealtime);
    }

    @VisibleForTesting
    private static int getOppositeDirection(int direction) {
        switch (direction) {
            case 17: {
                return 66;
            }
            case 66: {
                return 17;
            }
            case 33: {
                return 130;
            }
            case 130: {
                return 33;
            }
        }
        throw new IllegalArgumentException("direction must be FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, or FOCUS_RIGHT.");
    }

    @Nullable
    private IFocusArea getSpecifiedFocusArea(int direction) {
        this.maybeInitializeSpecifiedFocusAreas();
        return (IFocusArea)this.mSpecifiedNudgeFocusAreaMap.get(direction);
    }

    @Nullable
    private View getSpecifiedShortcut(int direction) {
        this.maybeInitializeSpecifiedShortcuts();
        return (View)this.mSpecifiedNudgeShortcutMap.get(direction);
    }

    void onDraw(Canvas canvas) {
        if (this.mEnableBackgroundHighlight && this.mHasFocus && !this.mFocusArea.isInTouchMode()) {
            this.mBackgroundHighlight.setBounds(this.mPaddingLeft + this.mFocusArea.getScrollX(), this.mPaddingTop + this.mFocusArea.getScrollY(), this.mFocusArea.getScrollX() + this.mFocusArea.getWidth() - this.mPaddingRight, this.mFocusArea.getScrollY() + this.mFocusArea.getHeight() - this.mPaddingBottom);
            this.mBackgroundHighlight.draw(canvas);
        }
    }

    void draw(Canvas canvas) {
        if (this.mEnableForegroundHighlight && this.mHasFocus && !this.mFocusArea.isInTouchMode()) {
            this.mForegroundHighlight.setBounds(this.mPaddingLeft + this.mFocusArea.getScrollX(), this.mPaddingTop + this.mFocusArea.getScrollY(), this.mFocusArea.getScrollX() + this.mFocusArea.getWidth() - this.mPaddingRight, this.mFocusArea.getScrollY() + this.mFocusArea.getHeight() - this.mPaddingBottom);
            this.mForegroundHighlight.draw(canvas);
        }
    }

    void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        Bundle bundle = info.getExtras();
        bundle.putInt("com.android.car.ui.utils.FOCUS_AREA_LEFT_BOUND_OFFSET", this.mLeftOffset);
        bundle.putInt("com.android.car.ui.utils.FOCUS_AREA_RIGHT_BOUND_OFFSET", this.mRightOffset);
        bundle.putInt("com.android.car.ui.utils.FOCUS_AREA_TOP_BOUND_OFFSET", this.mTopOffset);
        bundle.putInt("com.android.car.ui.utils.FOCUS_AREA_BOTTOM_BOUND_OFFSET", this.mBottomOffset);
    }

    boolean onRequestFocusInDescendants() {
        if (!this.mShouldRestoreFocus || this.shouldSkipRestoreFocus()) {
            return false;
        }
        return this.maybeAdjustFocus();
    }

    boolean restoreDefaultFocus() {
        if (!this.mShouldRestoreFocus || this.shouldSkipRestoreFocus()) {
            return false;
        }
        return this.maybeAdjustFocus();
    }

    private boolean shouldSkipRestoreFocus() {
        if (SystemClock.uptimeMillis() <= this.mSkipRestoreFocusUntil) {
            this.mSkipRestoreFocusUntil = 0L;
            return true;
        }
        return false;
    }

    private void maybeInitializeSpecifiedFocusAreas() {
        if (this.mSpecifiedNudgeFocusAreaMap != null) {
            return;
        }
        View root = this.mFocusArea.getRootView();
        this.mSpecifiedNudgeFocusAreaMap = new SparseArray();
        for (int direction : NUDGE_DIRECTIONS) {
            int id2 = this.mSpecifiedNudgeIdMap.get(direction, -1);
            this.mSpecifiedNudgeFocusAreaMap.put(direction, (Object)((IFocusArea)root.findViewById(id2)));
        }
    }

    private void maybeInitializeSpecifiedShortcuts() {
        if (this.mSpecifiedNudgeShortcutMap != null) {
            return;
        }
        View root = this.mFocusArea.getRootView();
        this.mSpecifiedNudgeShortcutMap = new SparseArray();
        for (int direction : NUDGE_DIRECTIONS) {
            int id2 = this.mSpecifiedNudgeShortcutIdMap.get(direction, -1);
            this.mSpecifiedNudgeShortcutMap.put(direction, (Object)root.findViewById(id2));
        }
    }

    View getDefaultFocusView() {
        return this.mDefaultFocusView;
    }

    void setDefaultFocus(@NonNull View defaultFocus) {
        this.mDefaultFocusView = defaultFocus;
    }

    void setHighlightPadding(int left, int top, int right, int bottom) {
        if (this.mPaddingLeft == left && this.mPaddingTop == top && this.mPaddingRight == right && this.mPaddingBottom == bottom) {
            return;
        }
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
        this.mFocusArea.invalidate();
    }

    void setBoundsOffset(int left, int top, int right, int bottom) {
        this.mLeftOffset = left;
        this.mTopOffset = top;
        this.mRightOffset = right;
        this.mBottomOffset = bottom;
    }

    boolean isWrapAround() {
        return this.mWrapAround;
    }

    void setWrapAround(boolean wrapAround) {
        this.mWrapAround = wrapAround;
    }

    void setNudgeShortcut(int direction, @Nullable View view) {
        if (!NUDGE_DIRECTIONS.contains(direction)) {
            throw new IllegalArgumentException("direction must be FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, or FOCUS_RIGHT.");
        }
        this.maybeInitializeSpecifiedShortcuts();
        if (view == null) {
            this.mSpecifiedNudgeShortcutMap.remove(direction);
        } else {
            this.mSpecifiedNudgeShortcutMap.put(direction, (Object)view);
        }
    }

    void setNudgeTargetFocusArea(int direction, @Nullable IFocusArea target) {
        if (!NUDGE_DIRECTIONS.contains(direction)) {
            throw new IllegalArgumentException("direction must be FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, or FOCUS_RIGHT.");
        }
        this.maybeInitializeSpecifiedFocusAreas();
        if (target == null) {
            this.mSpecifiedNudgeFocusAreaMap.remove(direction);
        } else {
            this.mSpecifiedNudgeFocusAreaMap.put(direction, (Object)target);
        }
    }

    void setNudgeEnabled(int direction, boolean enable) {
        if (!NUDGE_DIRECTIONS.contains(direction)) {
            throw new IllegalArgumentException("direction must be FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, or FOCUS_RIGHT.");
        }
        if (enable) {
            this.mDisabledNudgeDirections.remove(direction);
        } else {
            this.mDisabledNudgeDirections.add(direction);
        }
    }

    void setDefaultFocusOverridesHistory(boolean override) {
        this.mDefaultFocusOverridesHistory = override;
    }

    @VisibleForTesting
    void enableForegroundHighlight() {
        this.mEnableForegroundHighlight = true;
    }

    @VisibleForTesting
    void setRotaryCache(@NonNull RotaryCache rotaryCache) {
        this.mRotaryCache = rotaryCache;
    }

    @VisibleForTesting
    void setClearFocusAreaHistoryWhenRotating(boolean clear) {
        this.mClearFocusAreaHistoryWhenRotating = clear;
    }
}

