/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import com.android.car.ui.RotaryCache;
import com.android.car.ui.utils.ViewUtils;

public class FocusParkingView
extends View {
    private static final String TAG = "FocusParkingView";
    private static final boolean DEBUG = false;
    @Nullable
    private OnDismissPopupWindow mOnDismissPopupWindow;
    @Nullable
    private View mFocusedView;
    private RotaryCache.FocusCache mFocusCache;
    @Nullable
    ViewGroup mScrollableContainer;
    private boolean mShouldRestoreFocus = true;
    private long mTouchModeSkipRestoreFocusMs;
    private long mSkipRestoreFocusUntil;
    private boolean mDefaultFocusOverridesHistory;
    private final ViewTreeObserver.OnGlobalFocusChangeListener mFocusChangeListener = (oldFocus, newFocus) -> {
        View focusedView = newFocus instanceof FocusParkingView ? null : newFocus;
        this.updateFocusedView(focusedView);
    };
    private final ViewTreeObserver.OnTouchModeChangeListener mTouchModeChangeListener = isInTouchMode -> {
        if (!isInTouchMode) {
            this.mSkipRestoreFocusUntil = SystemClock.uptimeMillis() + this.mTouchModeSkipRestoreFocusMs;
        }
    };

    public FocusParkingView(Context context) {
        super(context);
        this.init(context, null);
    }

    public FocusParkingView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FocusParkingView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public FocusParkingView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FocusParkingView);
            this.mShouldRestoreFocus = a.getBoolean(R.styleable.FocusParkingView_shouldRestoreFocus, true);
        }
        this.mTouchModeSkipRestoreFocusMs = this.getResources().getInteger(R.integer.car_ui_touch_mode_skip_restore_focus_ms);
        this.setFocusable(1);
        this.setVisibility(0);
        this.setEnabled(true);
        this.setClickable(false);
        this.setAlpha(0.0f);
        this.setDefaultFocusHighlightEnabled(false);
        Resources resources = this.getResources();
        int focusHistoryCacheType = resources.getInteger(R.integer.car_ui_focus_history_cache_type);
        int focusHistoryExpirationPeriodMs = resources.getInteger(R.integer.car_ui_focus_history_expiration_period_ms);
        this.mFocusCache = new RotaryCache.FocusCache(focusHistoryCacheType, focusHistoryExpirationPeriodMs);
        this.mDefaultFocusOverridesHistory = resources.getBoolean(R.bool.car_ui_focus_area_default_focus_overrides_history);
    }

    private void updateFocusedView(@Nullable View focusedView) {
        if (this.mFocusedView != null) {
            this.mFocusCache.setFocusedView(this.mFocusedView, SystemClock.uptimeMillis());
        }
        this.mFocusedView = focusedView;
        this.mScrollableContainer = ViewUtils.getAncestorScrollableContainer(focusedView);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(1, 1);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnGlobalFocusChangeListener(this.mFocusChangeListener);
        this.getViewTreeObserver().addOnTouchModeChangeListener(this.mTouchModeChangeListener);
        if (this.mShouldRestoreFocus && ViewUtils.isInMultiWindowMode(this)) {
            this.mShouldRestoreFocus = false;
        }
    }

    protected void onDetachedFromWindow() {
        this.getViewTreeObserver().removeOnTouchModeChangeListener(this.mTouchModeChangeListener);
        this.getViewTreeObserver().removeOnGlobalFocusChangeListener(this.mFocusChangeListener);
        this.mFocusCache.setFocusedView(null, 0L);
        this.mFocusedView = null;
        super.onDetachedFromWindow();
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        Log.d((String)TAG, (String)("The window of Activity [" + ViewUtils.findActivity(this.getContext()) + (hasWindowFocus ? "] gained" : "] lost") + " focus"));
        if (!hasWindowFocus) {
            super.requestFocus(130, null);
            this.updateFocusedView(null);
        } else if (this.mShouldRestoreFocus && (this.isFocused() || this.getRootView().findFocus() instanceof FocusParkingView)) {
            this.restoreFocusInRoot(true);
        }
        super.onWindowFocusChanged(hasWindowFocus);
    }

    public CharSequence getAccessibilityClassName() {
        return FocusParkingView.class.getName();
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        switch (action) {
            case 0x4000000: {
                return this.restoreFocusInRoot(false);
            }
            case 0x8000000: {
                InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService(InputMethodManager.class);
                return inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            }
            case 1: {
                if (!this.hasFocus()) {
                    return super.requestFocus(130, null);
                }
                return false;
            }
            case 0x10000000: {
                if (this.mOnDismissPopupWindow != null) {
                    this.mOnDismissPopupWindow.onDismiss();
                    return true;
                }
                return false;
            }
        }
        return super.performAccessibilityAction(action, arguments);
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (!this.mShouldRestoreFocus || this.shouldSkipRestoreFocus()) {
            return super.requestFocus(direction, previouslyFocusedRect);
        }
        return this.restoreFocusInRoot(true);
    }

    public void setShouldRestoreFocus(boolean shouldRestoreFocus) {
        this.mShouldRestoreFocus = shouldRestoreFocus;
    }

    public void setOnPopupWindowDismiss(@Nullable OnDismissPopupWindow onDismissPopupWindow) {
        this.mOnDismissPopupWindow = onDismissPopupWindow;
    }

    private boolean restoreFocusInRoot(boolean checkForTouchMode) {
        if (checkForTouchMode && this.isInTouchMode()) {
            return false;
        }
        if (this.mFocusedView != null && this.mFocusedView.isFocused() && this.mFocusedView.isAttachedToWindow()) {
            return true;
        }
        if (this.maybeFocusOnScrollableContainer()) {
            return true;
        }
        View cachedFocusedView = this.mFocusCache.getFocusedView(SystemClock.uptimeMillis());
        if (ViewUtils.adjustFocus(this.getRootView(), cachedFocusedView, this.mDefaultFocusOverridesHistory)) {
            return true;
        }
        return super.requestFocus(130, null);
    }

    private boolean shouldSkipRestoreFocus() {
        if (SystemClock.uptimeMillis() <= this.mSkipRestoreFocusUntil) {
            this.mSkipRestoreFocusUntil = 0L;
            return true;
        }
        return false;
    }

    private boolean maybeFocusOnScrollableContainer() {
        if (this.mFocusedView != null && !this.mFocusedView.isAttachedToWindow() && this.mFocusedView.getParent() != null && this.mScrollableContainer != null && this.mScrollableContainer.isAttachedToWindow() && this.mScrollableContainer.isShown()) {
            RecyclerView recyclerView;
            RecyclerView recyclerView2 = recyclerView = this.mScrollableContainer instanceof RecyclerView ? (RecyclerView)this.mScrollableContainer : null;
            if (this.mScrollableContainer.requestFocus()) {
                if (recyclerView != null && recyclerView.isComputingLayout()) {
                    this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                        public void onGlobalLayout() {
                            recyclerView.sendAccessibilityEvent(8);
                            FocusParkingView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    });
                }
                return true;
            }
        }
        return false;
    }

    public static interface OnDismissPopupWindow {
        public void onDismiss();
    }
}

