/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.android.car.ui.utils.ViewUtils;

public class NestedContainer
extends FrameLayout {
    private boolean mFocusDescendant;
    private final ViewTreeObserver.OnGlobalFocusChangeListener mFocusChangeListener = (oldFocus, newFocus) -> {
        if (this.mFocusDescendant && (this.isFocused() || !this.hasFocus())) {
            this.mFocusDescendant = false;
            this.setDescendantFocusability(393216);
        }
    };

    public NestedContainer(Context context) {
        super(context);
        this.init();
    }

    public NestedContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public NestedContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public NestedContainer(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setDescendantFocusability(393216);
        this.setFocusable(true);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnGlobalFocusChangeListener(this.mFocusChangeListener);
    }

    protected void onDetachedFromWindow() {
        this.mFocusDescendant = false;
        this.getViewTreeObserver().removeOnGlobalFocusChangeListener(this.mFocusChangeListener);
        super.onDetachedFromWindow();
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (super.dispatchKeyEvent(event)) {
            return true;
        }
        if (event.getKeyCode() == 23 && !this.mFocusDescendant) {
            if (event.getAction() == 1) {
                this.setDescendantFocusability(262144);
                if (ViewUtils.focusOnFirstRegularView((View)this)) {
                    this.mFocusDescendant = true;
                } else {
                    this.setDescendantFocusability(393216);
                }
            }
            return true;
        }
        if (event.getKeyCode() == 4 && this.mFocusDescendant) {
            if (event.getAction() == 1) {
                this.setDescendantFocusability(393216);
                this.requestFocus();
                this.mFocusDescendant = false;
            }
            return true;
        }
        return false;
    }

    public View focusSearch(View focused, int direction) {
        View result = super.focusSearch(focused, direction);
        if (this.mFocusDescendant && !ViewUtils.isDescendant(result, (View)this)) {
            result = null;
        }
        return result;
    }
}

