/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.android.car.ui.IFocusArea;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.HashMap;

class RotaryCache {
    @VisibleForTesting
    static final int CACHE_TYPE_DISABLED = 1;
    @VisibleForTesting
    static final int CACHE_TYPE_EXPIRED_AFTER_SOME_TIME = 2;
    @VisibleForTesting
    static final int CACHE_TYPE_NEVER_EXPIRE = 3;
    @NonNull
    private final FocusCache mFocusCache;
    @NonNull
    private final FocusAreaCache mFocusAreaCache;

    RotaryCache(int focusHistoryCacheType, int focusHistoryExpirationPeriodMs, int focusAreaHistoryCacheType, int focusAreaHistoryExpirationPeriodMs) {
        this.mFocusCache = new FocusCache(focusHistoryCacheType, focusHistoryExpirationPeriodMs);
        this.mFocusAreaCache = new FocusAreaCache(focusAreaHistoryCacheType, focusAreaHistoryExpirationPeriodMs);
    }

    @Nullable
    View getFocusedView(long elapsedRealtime) {
        return this.mFocusCache.getFocusedView(elapsedRealtime);
    }

    void saveFocusedView(@NonNull View view, long elapsedRealtime) {
        this.mFocusCache.setFocusedView(view, elapsedRealtime);
    }

    @Nullable
    IFocusArea getCachedFocusArea(int direction, long elapsedRealtime) {
        return this.mFocusAreaCache.get(direction, elapsedRealtime);
    }

    void saveFocusArea(int direction, @NonNull IFocusArea targetFocusArea, long elapsedRealtime) {
        this.mFocusAreaCache.put(direction, targetFocusArea, elapsedRealtime);
    }

    void clearFocusAreaHistory() {
        this.mFocusAreaCache.clear();
    }

    static class FocusCache {
        final int mCacheType;
        long mExpirationPeriodMs;
        @Nullable
        FocusHistory mFocusHistory;

        FocusCache(int cacheType, long expirationPeriodMs) {
            this.mCacheType = cacheType;
            this.mExpirationPeriodMs = expirationPeriodMs;
            if (this.mCacheType == 2 && this.mExpirationPeriodMs <= 0L) {
                throw new IllegalArgumentException("Expiration time must be positive if CacheType is CACHE_TYPE_EXPIRED_AFTER_SOME_TIME");
            }
        }

        View getFocusedView(long elapsedRealtime) {
            return this.isValidHistory(elapsedRealtime) ? (View)this.mFocusHistory.mFocusedViewReference.get() : null;
        }

        void setFocusedView(@Nullable View focusedView, long elapsedRealtime) {
            if (this.mCacheType == 1) {
                return;
            }
            this.mFocusHistory = focusedView != null ? new FocusHistory(focusedView, elapsedRealtime) : null;
        }

        boolean isValidHistory(long elapsedRealtime) {
            if (this.mFocusHistory == null) {
                return false;
            }
            switch (this.mCacheType) {
                case 3: {
                    return true;
                }
                case 2: {
                    return elapsedRealtime < this.mFocusHistory.mTimestamp + this.mExpirationPeriodMs;
                }
            }
            return false;
        }
    }

    private static class FocusAreaCache
    extends HashMap<Integer, FocusAreaHistory> {
        private final int mCacheType;
        private final int mExpirationPeriodMs;

        FocusAreaCache(int cacheType, int expirationPeriodMs) {
            this.mCacheType = cacheType;
            this.mExpirationPeriodMs = expirationPeriodMs;
            if (this.mCacheType == 2 && this.mExpirationPeriodMs <= 0) {
                throw new IllegalArgumentException("Expiration time must be positive if CacheType is CACHE_TYPE_EXPIRED_AFTER_SOME_TIME");
            }
        }

        void put(int direction, @NonNull IFocusArea targetFocusArea, long elapsedRealtime) {
            if (this.mCacheType == 1) {
                return;
            }
            this.put(direction, new FocusAreaHistory(targetFocusArea, elapsedRealtime));
        }

        IFocusArea get(int direction, long elapsedRealtime) {
            FocusAreaHistory history = (FocusAreaHistory)this.get(direction);
            return this.isValidHistory(history, elapsedRealtime) ? (IFocusArea)history.mFocusAreaReference.get() : null;
        }

        boolean isValidHistory(@Nullable FocusAreaHistory history, long elapsedRealtime) {
            if (history == null) {
                return false;
            }
            switch (this.mCacheType) {
                case 3: {
                    return true;
                }
                case 2: {
                    return elapsedRealtime - history.mTimestamp < (long)this.mExpirationPeriodMs;
                }
            }
            return false;
        }
    }

    private static class FocusAreaHistory {
        @NonNull
        final WeakReference<IFocusArea> mFocusAreaReference;
        final long mTimestamp;

        FocusAreaHistory(@NonNull IFocusArea focusArea, long timestamp) {
            this.mFocusAreaReference = new WeakReference<IFocusArea>(focusArea);
            this.mTimestamp = timestamp;
        }
    }

    private static class FocusHistory {
        @NonNull
        final WeakReference<View> mFocusedViewReference;
        final long mTimestamp;

        FocusHistory(@NonNull View focusedView, long timestamp) {
            this.mFocusedViewReference = new WeakReference<View>(focusedView);
            this.mTimestamp = timestamp;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CacheType {
    }
}

