/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.android.car.ui.R;
import com.android.car.ui.RotaryScrollNodeProvider;
import java.util.Objects;

@TargetApi(value=30)
class RotaryScrollManager
extends View.AccessibilityDelegate
implements View.OnGenericMotionListener,
View.OnFocusChangeListener,
View.OnTouchListener {
    private final boolean mIsScrollbarFadingEnabledByDefault;

    @VisibleForTesting
    RotaryScrollManager(boolean isScrollbarFadingEnabledByDefault) {
        this.mIsScrollbarFadingEnabledByDefault = isScrollbarFadingEnabledByDefault;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (v == null || hasFocus) {
            return;
        }
        Drawable drawable2 = v.getVerticalScrollbarThumbDrawable();
        if (drawable2 != null) {
            drawable2.clearColorFilter();
        }
        v.setScrollbarFadingEnabled(this.mIsScrollbarFadingEnabledByDefault);
    }

    public boolean performAccessibilityAction(View host, int action, Bundle args) {
        boolean result = super.performAccessibilityAction(host, action, args);
        if (!result || action != 1 || host == null) {
            return result;
        }
        host.setScrollbarFadingEnabled(false);
        if (RotaryScrollManager.findFocus(host) == null) {
            RotaryScrollManager.setScrollbarThumbHighlight(host);
        }
        return true;
    }

    public boolean onGenericMotion(View view, MotionEvent event) {
        boolean shouldProcessRotaryScroll;
        boolean bl = shouldProcessRotaryScroll = event != null && event.getAction() == 8 && event.getSource() == 0x400000;
        if (!shouldProcessRotaryScroll) {
            return false;
        }
        event.setSource(8194);
        boolean didScroll = view.onGenericMotionEvent(event);
        if (!didScroll) {
            return false;
        }
        view.setScrollbarFadingEnabled(false);
        if (this.maybeClearFocusedChild(view, event) || RotaryScrollManager.findFocus(view) == null) {
            RotaryScrollManager.setScrollbarThumbHighlight(view);
        }
        return true;
    }

    public void onInitializeAccessibilityEvent(View view, AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(view, event);
        if (view == null || event == null) {
            return;
        }
        if (RotaryScrollManager.isJumpScrollEvent(event, view.getHeight()) && RotaryScrollManager.getLastFocusedNodeId(view) != null) {
            RotaryScrollManager.setLastFocusedNodeId(view, null);
            RotaryScrollManager.setScrollbarThumbHighlight(view);
        } else if (event.getEventType() == 8 && RotaryScrollManager.getLastFocusedNodeId(view) != null) {
            event.setSource(view, RotaryScrollManager.getLastFocusedNodeId(view).intValue());
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View view, MotionEvent event) {
        view.setScrollbarFadingEnabled(this.mIsScrollbarFadingEnabledByDefault);
        RotaryScrollManager.setLastFocusedNodeId(view, null);
        RotaryScrollManager.clearScrollbarThumbHighlight(view);
        return false;
    }

    static Integer getLastFocusedNodeId(@NonNull View view) {
        return (Integer)view.getTag(R.id.car_ui_web_view_last_focused_element);
    }

    static void setLastFocusedNodeId(@NonNull View view, @Nullable Integer id2) {
        Integer oldId = RotaryScrollManager.getLastFocusedNodeId(view);
        if (!Objects.equals(oldId, id2)) {
            view.setTag(R.id.car_ui_web_view_last_focused_element, (Object)id2);
            view.sendAccessibilityEvent(8);
        }
    }

    static void clearScrollbarThumbHighlight(@NonNull View view) {
        Drawable drawable2 = view.getVerticalScrollbarThumbDrawable();
        if (drawable2 != null) {
            drawable2.clearColorFilter();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    static void attach(@NonNull WebView webView) {
        RotaryScrollManager.attach(webView, new RotaryScrollManager(webView.isScrollbarFadingEnabled()));
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    static void attach(@NonNull WebView webView, @NonNull RotaryScrollManager manager) {
        webView.getSettings().setNeedInitialFocus(false);
        webView.setAccessibilityDelegate((View.AccessibilityDelegate)manager);
        webView.setOnFocusChangeListener((View.OnFocusChangeListener)manager);
        webView.setOnGenericMotionListener((View.OnGenericMotionListener)manager);
        webView.setOnTouchListener((View.OnTouchListener)manager);
    }

    private boolean maybeClearFocusedChild(@NonNull View view, @NonNull MotionEvent event) {
        Integer nodeId = RotaryScrollManager.getLastFocusedNodeId(view);
        if (nodeId == null) {
            return false;
        }
        AccessibilityNodeInfo focusedNode = RotaryScrollManager.findFocus(view);
        if (focusedNode == null || !focusedNode.isFocused()) {
            return false;
        }
        Rect bounds = RotaryScrollManager.getBoundsInScreen(focusedNode);
        float verticalScrollFactor = ViewConfiguration.get((Context)view.getContext()).getScaledVerticalScrollFactor();
        float verticalScrollOffset = verticalScrollFactor * event.getAxisValue(9);
        bounds.offset(0, Math.round(verticalScrollOffset));
        boolean intersects = Rect.intersects((Rect)bounds, (Rect)RotaryScrollManager.getBoundsInScreen(view.createAccessibilityNodeInfo()));
        if (intersects) {
            return false;
        }
        boolean result = false;
        AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
        if (provider != null) {
            result = provider.performAction(nodeId.intValue(), 2, null);
        }
        if (result && Log.isLoggable((String)"RotaryScrollWebView", (int)3)) {
            Log.d((String)"RotaryScrollWebView", (String)("Cleared focus from child with ID " + nodeId + " that moved off-screen."));
        }
        return result;
    }

    private static void setScrollbarThumbHighlight(@NonNull View view) {
        Drawable drawable2 = view.getVerticalScrollbarThumbDrawable();
        if (drawable2 != null) {
            int color2 = view.getContext().getColor(R.color.car_ui_rotary_focus_stroke_color);
            drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC));
        }
    }

    private static boolean isJumpScrollEvent(@NonNull AccessibilityEvent event, int viewHeight) {
        return event.getEventType() == 4096 && Math.abs(event.getScrollDeltaY()) > viewHeight;
    }

    private static AccessibilityNodeInfo findFocus(@NonNull View webView) {
        AccessibilityNodeProvider provider = webView.getAccessibilityNodeProvider();
        if (webView instanceof WebView && provider != null && !(provider instanceof RotaryScrollNodeProvider)) {
            throw new IllegalStateException("WebViews must use a RotaryScrollNodeProvider with RotaryScrollManager.");
        }
        return provider == null ? null : provider.findFocus(1);
    }

    private static Rect getBoundsInScreen(@NonNull AccessibilityNodeInfo node) {
        Rect bounds = new Rect();
        node.getBoundsInScreen(bounds);
        return bounds;
    }
}

