/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.annotation.TargetApi;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.android.car.ui.RotaryScrollManager;
import java.util.List;

@TargetApi(value=30)
class RotaryScrollNodeProvider
extends AccessibilityNodeProvider {
    @NonNull
    private final WebView mWebView;
    @NonNull
    private final AccessibilityNodeProvider mBaseProvider;

    RotaryScrollNodeProvider(@NonNull WebView webView, @NonNull AccessibilityNodeProvider provider) {
        this.mWebView = webView;
        this.mBaseProvider = provider;
        if (!(webView.getAccessibilityDelegate() instanceof RotaryScrollManager)) {
            throw new IllegalStateException("The provided WebView must attach a " + RotaryScrollManager.class.getName() + " before constructing this class.");
        }
    }

    public AccessibilityNodeInfo createAccessibilityNodeInfo(int virtualViewId) {
        AccessibilityNodeInfo node = this.mBaseProvider.createAccessibilityNodeInfo(virtualViewId);
        if (node == null) {
            return null;
        }
        if (node.getClassName() == WebView.class.getName()) {
            this.enableRotaryScrolling(node, virtualViewId);
        }
        return node;
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        AccessibilityNodeInfo node;
        if (focus != 1) {
            return this.mBaseProvider.findFocus(focus);
        }
        Integer id2 = RotaryScrollManager.getLastFocusedNodeId((View)this.mWebView);
        if (id2 != null && (node = this.createAccessibilityNodeInfo(id2)) != null) {
            return node;
        }
        return this.mBaseProvider.findFocus(focus);
    }

    public boolean performAction(int virtualViewId, int action, Bundle arguments) {
        if (!this.mBaseProvider.performAction(virtualViewId, action, arguments)) {
            return false;
        }
        if (action == 2) {
            RotaryScrollManager.setLastFocusedNodeId((View)this.mWebView, null);
        } else if (action == 1) {
            RotaryScrollManager.setLastFocusedNodeId((View)this.mWebView, virtualViewId);
            RotaryScrollManager.clearScrollbarThumbHighlight((View)this.mWebView);
        }
        return true;
    }

    public void addExtraDataToAccessibilityNodeInfo(int virtualViewId, AccessibilityNodeInfo info, String extraDataKey, Bundle arguments) {
        this.mBaseProvider.addExtraDataToAccessibilityNodeInfo(virtualViewId, info, extraDataKey, arguments);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String text, int virtualViewId) {
        return this.mBaseProvider.findAccessibilityNodeInfosByText(text, virtualViewId);
    }

    private void enableRotaryScrolling(AccessibilityNodeInfo node, int virtualViewId) {
        if (!TextUtils.isEmpty((CharSequence)node.getContentDescription()) && Log.isLoggable((String)"RotaryScrollWebView", (int)5)) {
            Log.w((String)"RotaryScrollWebView", (String)"Overwriting content description to enable rotary scrolling.");
        }
        node.setContentDescription((CharSequence)"com.android.car.ui.utils.VERTICALLY_SCROLLABLE");
        if (virtualViewId != -1) {
            return;
        }
        if (this.mWebView.canScrollVertically(-1)) {
            node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
        }
        if (this.mWebView.canScrollVertically(1)) {
            node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
        }
    }
}

