/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;

public class SecureView
extends FrameLayout {
    private boolean mSecure = true;

    public SecureView(Context context) {
        this(context, null);
    }

    public SecureView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SecureView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public SecureView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public boolean onFilterTouchEventForSecurity(MotionEvent event) {
        if (!this.mSecure) {
            return super.onFilterTouchEventForSecurity(event);
        }
        int flags = 1;
        if (Build.VERSION.SDK_INT >= 29) {
            flags |= 2;
        }
        return (event.getFlags() & flags) == 0 && super.onFilterTouchEventForSecurity(event);
    }

    public void setSecure(boolean secure) {
        this.mSecure = secure;
    }

    public boolean isSecure() {
        return this.mSecure;
    }
}

