/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.appstyledview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherOwner;
import androidx.activity.ViewTreeOnBackPressedDispatcherOwner;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryController;
import androidx.savedstate.SavedStateRegistryOwner;
import androidx.savedstate.ViewTreeSavedStateRegistryOwner;
import com.android.car.ui.R;
import com.android.car.ui.utils.CarUiUtils;
import java.util.List;

public class AppStyledDialog
extends Dialog
implements LifecycleOwner,
SavedStateRegistryOwner,
OnBackPressedDispatcherOwner {
    private static final double VISIBLE_SCREEN_PERCENTAGE = 0.9;
    private static final int DIALOG_START_MARGIN_THRESHOLD = 64;
    private static final int DIALOG_MIN_PADDING = 32;
    private static final int IME_OVERLAP_DP = 32;
    private View mContent;
    private final Context mContext;
    private final LifecycleRegistry mLifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);
    private final SavedStateRegistryController mSavedStateRegistryController = SavedStateRegistryController.create((SavedStateRegistryOwner)this);
    private final OnBackPressedDispatcher mOnBackPressedDispatcher = new OnBackPressedDispatcher(() -> super.onBackPressed());
    private WindowManager.LayoutParams mBaseLayoutParams;
    private int mSceneType;

    public AppStyledDialog(@NonNull Context context) {
        super(context);
        this.mContext = context;
        this.requestWindowFeature(1);
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 30) {
            this.mBaseLayoutParams = new WindowManager.LayoutParams();
            this.mBaseLayoutParams.copyFrom(window.getAttributes());
            int types = WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout();
            this.mBaseLayoutParams.setFitInsetsTypes(types);
        } else {
            this.mBaseLayoutParams = window.getAttributes();
        }
        this.updateAttributes();
    }

    @NonNull
    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        this.mSavedStateRegistryController.performSave(bundle);
        return bundle;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mSavedStateRegistryController.performRestore(savedInstanceState);
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.copySystemUiVisibility();
        this.configureImeInsetFit();
        this.updateAttributes();
        this.mLifecycleRegistry.setCurrentState(Lifecycle.State.CREATED);
    }

    private void updateAttributes() {
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        window.setAttributes(this.getDialogWindowLayoutParam(this.mBaseLayoutParams));
    }

    @SuppressLint(value={"NewApi"})
    private float getVerticalInset(DisplayMetrics displayMetrics) {
        int insetType = WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout();
        if (Build.VERSION.SDK_INT >= 30) {
            Context unwrappedContext = CarUiUtils.unwrapContext(this.mContext);
            WindowInsets windowInsets = ((WindowManager)unwrappedContext.getSystemService(WindowManager.class)).getCurrentWindowMetrics().getWindowInsets();
            android.graphics.Insets insets = windowInsets.getInsets(insetType);
            return insets.top + insets.bottom;
        }
        float fallbackInset = (float)((double)displayMetrics.heightPixels * 0.09999999999999998);
        Activity activity = CarUiUtils.getActivity(this.mContext);
        if (activity == null) {
            return fallbackInset;
        }
        WindowInsets windowInsets = activity.getWindow().getDecorView().getRootView().getRootWindowInsets();
        if (windowInsets == null) {
            return fallbackInset;
        }
        Insets insets = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)windowInsets).getInsets(insetType);
        return insets.top + insets.bottom;
    }

    @SuppressLint(value={"NewApi"})
    private float getHorizontalInset(DisplayMetrics displayMetrics) {
        int insetType = WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout();
        if (Build.VERSION.SDK_INT >= 30) {
            Context unwrappedContext = CarUiUtils.unwrapContext(this.mContext);
            WindowInsets windowInsets = ((WindowManager)unwrappedContext.getSystemService(WindowManager.class)).getCurrentWindowMetrics().getWindowInsets();
            android.graphics.Insets insets = windowInsets.getInsets(insetType);
            return insets.left + insets.right;
        }
        float fallbackInset = (float)((double)displayMetrics.widthPixels * 0.09999999999999998);
        Activity activity = CarUiUtils.getActivity(this.mContext);
        if (activity == null) {
            return fallbackInset;
        }
        WindowInsets windowInsets = activity.getWindow().getDecorView().getRootView().getRootWindowInsets();
        if (windowInsets == null) {
            return fallbackInset;
        }
        Insets insets = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)windowInsets).getInsets(insetType);
        return insets.left + insets.right;
    }

    public WindowManager.LayoutParams getDialogWindowLayoutParam(WindowManager.LayoutParams params) {
        DisplayMetrics displayMetrics = CarUiUtils.getDeviceDisplayMetrics(this.mContext);
        int maxWidth = this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_app_styled_dialog_width_max);
        int maxHeight = this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_app_styled_dialog_height_max);
        int displayWidth = displayMetrics.widthPixels;
        int displayHeight = displayMetrics.heightPixels;
        int horizontalInset = (int)this.getHorizontalInset(displayMetrics);
        int verticalInset = (int)this.getVerticalInset(displayMetrics);
        int configuredWidth = this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_app_styled_dialog_width);
        int configuredHeight = this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_app_styled_dialog_height);
        params.width = configuredWidth != 0 ? configuredWidth : Math.min(displayWidth, maxWidth);
        params.height = configuredHeight != 0 ? configuredHeight : Math.min(displayHeight, maxHeight);
        params.dimAmount = CarUiUtils.getFloat(this.mContext.getResources(), R.dimen.car_ui_app_styled_dialog_dim_amount);
        params.flags |= 2;
        switch (this.mSceneType) {
            case 1: {
                params.windowAnimations = R.style.Widget_CarUi_AppStyledView_WindowAnimations_Enter;
                break;
            }
            case 3: {
                params.windowAnimations = R.style.Widget_CarUi_AppStyledView_WindowAnimations_Exit;
                break;
            }
            case 2: {
                params.windowAnimations = R.style.Widget_CarUi_AppStyledView_WindowAnimations_Intermediate;
                break;
            }
            default: {
                params.windowAnimations = R.style.Widget_CarUi_AppStyledView_WindowAnimations;
            }
        }
        int posX = this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_app_styled_dialog_position_x);
        int posY = this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_app_styled_dialog_position_y);
        if (posX != 0 || posY != 0) {
            params.gravity = 0x800033;
            params.x = posX;
            params.y = posY;
            return params;
        }
        params.x = 0;
        params.y = 0;
        int minPaddingPx = (int)CarUiUtils.dpToPixel(this.mContext.getResources(), 32);
        if (params.width + horizontalInset >= displayWidth - minPaddingPx * 2) {
            params.width = displayWidth - horizontalInset - minPaddingPx * 2;
        }
        if (params.height + verticalInset >= displayHeight - minPaddingPx * 2) {
            params.height = displayHeight - verticalInset - minPaddingPx * 2;
        }
        int startMarginThresholdPx = (int)CarUiUtils.dpToPixel(this.mContext.getResources(), 64);
        boolean isLandscape = this.mContext.getResources().getConfiguration().orientation == 2;
        int startMargin = (displayWidth - horizontalInset - params.width) / 2;
        if (isLandscape && startMargin >= startMarginThresholdPx) {
            params.gravity = 8388627;
            params.x = startMarginThresholdPx;
        } else {
            params.gravity = 17;
        }
        return params;
    }

    private void configureImeInsetFit() {
        final Window window = this.getWindow();
        if (window == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 30) {
            window.setSoftInputMode(32);
            ViewCompat.setOnApplyWindowInsetsListener((View)window.getDecorView().getRootView(), (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

                @NonNull
                public WindowInsetsCompat onApplyWindowInsets(@NonNull View v, @NonNull WindowInsetsCompat insets) {
                    AppStyledDialog.this.updateAttributes();
                    return insets;
                }
            });
            return;
        }
        window.setSoftInputMode(48);
        ViewCompat.setWindowInsetsAnimationCallback((View)window.getDecorView().getRootView(), (WindowInsetsAnimationCompat.Callback)new WindowInsetsAnimationCompat.Callback(0){
            int mEndHeight;
            int mStartHeight;
            WindowManager.LayoutParams mAnimationLayoutParams;
            int mContentBottomPadding;
            boolean mIsImeShownWithResize;
            final int mImeOverlapPx;
            int mSystemBarBottom;
            int mImeHeight;
            {
                super(arg0);
                this.mImeOverlapPx = (int)CarUiUtils.dpToPixel(AppStyledDialog.this.mContext.getResources(), 32);
            }

            private boolean isImeAnimation(WindowInsetsAnimationCompat animation) {
                return (animation.getTypeMask() & WindowInsetsCompat.Type.ime()) != 0;
            }

            private int getSystemBarBottomHeight() {
                Activity activity = CarUiUtils.getActivity(AppStyledDialog.this.mContext);
                if (activity != null) {
                    WindowInsetsCompat activityInsets = ViewCompat.getRootWindowInsets((View)activity.getWindow().getDecorView().getRootView());
                    return activityInsets.getInsets((int)WindowInsetsCompat.Type.systemBars()).bottom;
                }
                return 0;
            }

            @SuppressLint(value={"NewApi", "RtlHardcoded"})
            public void onPrepare(@NonNull WindowInsetsAnimationCompat animation) {
                if (!this.isImeAnimation(animation)) {
                    return;
                }
                this.mSystemBarBottom = this.getSystemBarBottomHeight();
                window.setSoftInputMode(48);
                this.mAnimationLayoutParams = new WindowManager.LayoutParams();
                this.mAnimationLayoutParams.copyFrom(window.getAttributes());
                this.mStartHeight = this.mAnimationLayoutParams.height;
                int[] location = new int[2];
                window.getDecorView().getRootView().getLocationOnScreen(location);
                int x = location[0];
                int y = location[1];
                this.mContentBottomPadding = AppStyledDialog.this.mContent.getPaddingBottom();
                this.mAnimationLayoutParams.gravity = 51;
                this.mAnimationLayoutParams.setFitInsetsTypes(0);
                this.mAnimationLayoutParams.layoutInDisplayCutoutMode = 3;
                this.mAnimationLayoutParams.x = x;
                this.mAnimationLayoutParams.y = y;
                window.setAttributes(this.mAnimationLayoutParams);
            }

            @NonNull
            public WindowInsetsAnimationCompat.BoundsCompat onStart(@NonNull WindowInsetsAnimationCompat animation, @NonNull WindowInsetsAnimationCompat.BoundsCompat bounds) {
                if (!this.isImeAnimation(animation)) {
                    return bounds;
                }
                WindowInsetsCompat insets = ViewCompat.getRootWindowInsets((View)window.getDecorView().getRootView());
                this.mIsImeShownWithResize = insets.getInsets(WindowInsetsCompat.Type.ime()) != Insets.NONE;
                this.mImeHeight = bounds.getUpperBound().bottom;
                if (Build.VERSION.SDK_INT < 32) {
                    this.mImeHeight = bounds.getUpperBound().bottom - this.mSystemBarBottom;
                }
                int resize = 0;
                if (this.mIsImeShownWithResize) {
                    resize = this.calculateDialogResize();
                }
                this.mEndHeight = this.mStartHeight - resize;
                return bounds;
            }

            private int calculateDialogResize() {
                int resize = 0;
                int[] location = new int[2];
                window.getDecorView().getRootView().getLocationOnScreen(location);
                int bottom = location[1] + this.mStartHeight;
                DisplayMetrics displayMetrics = CarUiUtils.getDeviceDisplayMetrics(AppStyledDialog.this.mContext);
                int imeTop = displayMetrics.heightPixels - this.mImeHeight;
                if (imeTop < bottom) {
                    resize = bottom - imeTop - this.mImeOverlapPx;
                }
                return resize;
            }

            @NonNull
            public WindowInsetsCompat onProgress(@NonNull WindowInsetsCompat insets, @NonNull List<WindowInsetsAnimationCompat> runningAnimations) {
                WindowInsetsAnimationCompat imeAnimation = null;
                for (WindowInsetsAnimationCompat animation : runningAnimations) {
                    if (!this.isImeAnimation(animation)) continue;
                    imeAnimation = animation;
                    break;
                }
                if (imeAnimation != null) {
                    this.mAnimationLayoutParams.height = (int)((float)this.mStartHeight - (float)(this.mStartHeight - this.mEndHeight) * imeAnimation.getInterpolatedFraction());
                    window.setAttributes(this.mAnimationLayoutParams);
                    float imeOffset = this.mIsImeShownWithResize ? (float)this.mImeOverlapPx * imeAnimation.getInterpolatedFraction() : (float)(-this.mImeOverlapPx) * imeAnimation.getInterpolatedFraction();
                    AppStyledDialog.this.mContent.setPadding(AppStyledDialog.this.mContent.getPaddingLeft(), AppStyledDialog.this.mContent.getPaddingTop(), AppStyledDialog.this.mContent.getPaddingRight(), (int)((float)this.mContentBottomPadding + imeOffset));
                }
                return insets;
            }

            public void onEnd(@NonNull WindowInsetsAnimationCompat animation) {
                boolean isSystemBarAnimation;
                boolean bl = isSystemBarAnimation = (animation.getTypeMask() & WindowInsetsCompat.Type.systemBars()) != 0;
                if (!this.mIsImeShownWithResize || isSystemBarAnimation) {
                    AppStyledDialog.this.updateAttributes();
                }
                if (this.mIsImeShownWithResize) {
                    Rect r = new Rect();
                    Activity activity = CarUiUtils.getActivity(AppStyledDialog.this.mContext);
                    if (activity != null) {
                        activity.getWindow().getDecorView().getRootView().getWindowVisibleDisplayFrame(r);
                        int dialogHeight = AppStyledDialog.this.getWindow().getAttributes().height;
                        int visibleFrameHeight = r.height();
                        if (dialogHeight < visibleFrameHeight) {
                            this.mImeHeight -= this.mSystemBarBottom;
                            AppStyledDialog.this.getWindow().getAttributes().height = this.mStartHeight - this.calculateDialogResize();
                            window.setAttributes(window.getAttributes());
                        }
                    }
                }
                super.onEnd(animation);
            }
        });
    }

    protected void onStart() {
        this.mLifecycleRegistry.setCurrentState(Lifecycle.State.STARTED);
        this.mLifecycleRegistry.setCurrentState(Lifecycle.State.RESUMED);
        super.onStart();
    }

    protected void onStop() {
        this.mLifecycleRegistry.setCurrentState(Lifecycle.State.DESTROYED);
        super.onStop();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.copyWindowInsets();
        this.getWindow().getDecorView().getRootView().post(() -> this.updateAttributes());
    }

    private void copySystemUiVisibility() {
        if (this.getWindow() == null) {
            return;
        }
        Activity activity = CarUiUtils.getActivity(this.mContext);
        this.getWindow().getDecorView().setSystemUiVisibility(activity.getWindow().getDecorView().getSystemUiVisibility());
        this.getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(i -> this.getWindow().getDecorView().setSystemUiVisibility(activity.getWindow().getDecorView().getSystemUiVisibility()));
    }

    private void copyWindowInsets() {
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        WindowInsetsControllerCompat dialogWindowInsetsController = WindowCompat.getInsetsController((Window)window, (View)this.getWindow().getDecorView());
        Activity activity = CarUiUtils.getActivity(this.mContext);
        WindowInsetsControllerCompat activityWindowInsetsController = WindowCompat.getInsetsController((Window)activity.getWindow(), (View)activity.getWindow().getDecorView());
        int activitySystemBarBehavior = activityWindowInsetsController.getSystemBarsBehavior();
        if (activitySystemBarBehavior != 0) {
            dialogWindowInsetsController.setSystemBarsBehavior(activitySystemBarBehavior);
        }
        if (Build.VERSION.SDK_INT >= 30) {
            boolean isNavBarVisible;
            WindowInsets windowInsets = activity.getWindow().getDecorView().getRootWindowInsets();
            if (windowInsets == null) {
                return;
            }
            boolean isStatusBarVisible = windowInsets.isVisible(WindowInsets.Type.statusBars());
            if (!isStatusBarVisible) {
                dialogWindowInsetsController.hide(WindowInsetsCompat.Type.statusBars());
            }
            if (!(isNavBarVisible = windowInsets.isVisible(WindowInsets.Type.navigationBars()))) {
                dialogWindowInsetsController.hide(WindowInsetsCompat.Type.navigationBars());
            }
        }
    }

    public void show() {
        if (this.isShowing()) {
            return;
        }
        super.show();
        View focusedView = this.getCurrentFocus();
        if (focusedView != null) {
            focusedView.clearFocus();
        }
    }

    public void setContentView(@NonNull View view) {
        this.initViewTreeOwners();
        this.mContent = view;
        super.setContentView(view);
    }

    public void setContentView(int layoutResID) {
        this.initViewTreeOwners();
        super.setContentView(layoutResID);
    }

    public void setContentView(@NonNull View view, @Nullable ViewGroup.LayoutParams params) {
        this.initViewTreeOwners();
        super.setContentView(view, params);
    }

    public void addContentView(@NonNull View view, @Nullable ViewGroup.LayoutParams params) {
        this.initViewTreeOwners();
        super.addContentView(view, params);
    }

    public void setSceneType(int sceneType) {
        this.mSceneType = sceneType;
    }

    @Nullable
    public WindowManager.LayoutParams getWindowLayoutParams() {
        if (this.getWindow() == null) {
            return null;
        }
        return this.getWindow().getAttributes();
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.mLifecycleRegistry;
    }

    private void initViewTreeOwners() {
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        ViewTreeLifecycleOwner.set((View)window.getDecorView(), (LifecycleOwner)this);
        ViewTreeSavedStateRegistryOwner.set((View)window.getDecorView(), (SavedStateRegistryOwner)this);
        ViewTreeOnBackPressedDispatcherOwner.set((View)window.getDecorView(), (OnBackPressedDispatcherOwner)this);
    }

    @NonNull
    public SavedStateRegistry getSavedStateRegistry() {
        return this.mSavedStateRegistryController.getSavedStateRegistry();
    }

    @NonNull
    public OnBackPressedDispatcher getOnBackPressedDispatcher() {
        return this.mOnBackPressedDispatcher;
    }
}

