/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.appstyledview;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import com.android.car.ui.R;
import com.android.car.ui.appstyledview.AppStyledViewController;
import com.android.car.ui.pluginsupport.PluginFactorySingleton;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public final class AppStyledDialogController {
    @NonNull
    private AppStyledViewController mAppStyledViewController;
    @Nullable
    private View mContentView;

    public AppStyledDialogController(@NonNull Activity activity) {
        this(activity, 0);
    }

    public AppStyledDialogController(@NonNull Activity activity, int sceneType) {
        Objects.requireNonNull(activity);
        this.mAppStyledViewController = PluginFactorySingleton.get((Context)activity).createAppStyledView((Context)activity);
        this.mAppStyledViewController.setSceneType(sceneType);
    }

    public AppStyledDialogController(Context context) {
        Objects.requireNonNull(context);
        if (Build.VERSION.SDK_INT >= 31 ? !context.isUiContext() : !(context instanceof Activity)) {
            throw new IllegalArgumentException();
        }
        this.mAppStyledViewController = PluginFactorySingleton.get(context).createAppStyledView(context);
    }

    @VisibleForTesting
    void setAppStyledViewController(AppStyledViewController controller, Activity context) {
        this.mAppStyledViewController = controller;
    }

    public void setContentView(@NonNull View contentView) {
        Objects.requireNonNull(contentView);
        TypedValue tv = new TypedValue();
        contentView.getContext().getTheme().resolveAttribute(R.attr.carUiActivity, tv, true);
        if (tv.type != 0) {
            throw new IllegalStateException("Content view MUST NOT be rendered with a theme that inherits from Theme.CarUi or Theme.DeviceDefault");
        }
        this.mContentView = contentView;
        this.mAppStyledViewController.setContent(contentView);
    }

    @Nullable
    public View getContentView() {
        return this.mContentView;
    }

    @Deprecated
    public void setNavIcon(int navIcon) {
        this.mAppStyledViewController.setNavIcon(navIcon);
    }

    public void setNavIconType(int navIcon) {
        this.mAppStyledViewController.setNavIcon(navIcon);
    }

    public void show() {
        this.mAppStyledViewController.show();
    }

    public void dismiss() {
        this.mAppStyledViewController.dismiss();
    }

    public void setOnNavIconClickListener(@NonNull Runnable listener) {
        this.mAppStyledViewController.setOnNavIconClickListener(listener);
    }

    public void setOnDismissListener(@Nullable Runnable listener) {
        this.mAppStyledViewController.setOnDismissListener(listener);
    }

    public int getAppStyledViewDialogWidth() {
        WindowManager.LayoutParams params = this.mAppStyledViewController.getAttributes();
        if (params != null) {
            return params.width;
        }
        return -1;
    }

    public int getAppStyledViewDialogHeight() {
        WindowManager.LayoutParams params = this.mAppStyledViewController.getAttributes();
        if (params != null) {
            return params.height;
        }
        return -1;
    }

    public int getContentAreaWidth() {
        return this.mAppStyledViewController.getContentAreaWidth();
    }

    public int getContentAreaHeight() {
        return this.mAppStyledViewController.getContentAreaHeight();
    }

    @Deprecated
    public Context createContentViewConfigurationContext(Context context) {
        return this.createContentViewConfigurationContext(context, R.style.Theme_AppCompat_Light);
    }

    public Context createContentViewConfigurationContext(Context context, int themeResId) {
        int widthPx = this.getContentAreaWidth();
        if (widthPx <= 0) {
            widthPx = this.getAppStyledViewDialogWidth();
        }
        int width = (int)((float)widthPx / context.getResources().getDisplayMetrics().density);
        int heightPx = this.getContentAreaHeight();
        if (heightPx <= 0) {
            heightPx = this.getAppStyledViewDialogHeight();
        }
        int height = (int)((float)heightPx / context.getResources().getDisplayMetrics().density);
        Configuration config = context.getResources().getConfiguration();
        config.smallestScreenWidthDp = Math.min(width, height);
        config.screenWidthDp = width;
        config.screenHeightDp = height;
        Context configContext = context.createConfigurationContext(config);
        Resources.Theme theme = configContext.getResources().newTheme();
        theme.applyStyle(themeResId, true);
        return new ContextThemeWrapper(configContext, theme);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SceneType {
        public static final int SINGLE = 0;
        public static final int ENTER = 1;
        public static final int INTERMEDIATE = 2;
        public static final int EXIT = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NavIcon {
        public static final int BACK = 0;
        public static final int CLOSE = 1;
    }
}

