/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.appstyledview;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.android.car.ui.appstyledview.AppStyledDialog;
import com.android.car.ui.appstyledview.AppStyledViewController;
import com.android.car.ui.plugin.oemapis.appstyledview.AppStyledViewControllerOEMV2;

public class AppStyledViewControllerAdapterV2
implements AppStyledViewController {
    @NonNull
    private final AppStyledViewControllerOEMV2 mOemController;
    private final AppStyledDialog mDialog;
    private View mContent;

    public AppStyledViewControllerAdapterV2(@NonNull Context context, @NonNull AppStyledViewControllerOEMV2 controllerOEMV2) {
        this.mOemController = controllerOEMV2;
        this.mOemController.setNavIcon(2);
        this.mDialog = new AppStyledDialog((Context)((Activity)context)){

            @Override
            public WindowManager.LayoutParams getDialogWindowLayoutParam(WindowManager.LayoutParams params) {
                return AppStyledViewControllerAdapterV2.this.mOemController.getDialogWindowLayoutParam(params);
            }
        };
    }

    @Override
    public void setContent(@NonNull View content) {
        this.mContent = content;
    }

    @Override
    public void setNavIcon(int navIcon) {
        switch (navIcon) {
            case 0: {
                this.mOemController.setNavIcon(1);
                break;
            }
            case 1: {
                this.mOemController.setNavIcon(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown nav icon style: " + navIcon);
            }
        }
    }

    @Override
    public void setOnNavIconClickListener(Runnable listener) {
        this.mOemController.setOnBackClickListener(listener);
    }

    @Override
    public int getContentAreaWidth() {
        return this.mOemController.getContentAreaWidth();
    }

    @Override
    public int getContentAreaHeight() {
        return this.mOemController.getContentAreaHeight();
    }

    @Override
    public void setSceneType(int sceneType) {
    }

    @Override
    public void show() {
        if (this.mContent == null) {
            return;
        }
        if (this.mContent.getParent() != null) {
            ((ViewGroup)this.mContent.getParent()).removeView(this.mContent);
        }
        this.mOemController.setContent(this.mContent);
        View wrappedContent = this.mOemController.getView();
        if (wrappedContent == null) {
            return;
        }
        if (wrappedContent.getParent() != null) {
            ((ViewGroup)wrappedContent.getParent()).removeView(wrappedContent);
        }
        this.mDialog.setContentView(wrappedContent);
        this.mDialog.show();
    }

    @Override
    public void dismiss() {
        this.mDialog.dismiss();
    }

    @Override
    public void setOnDismissListener(Runnable runnable) {
        if (runnable == null) {
            this.mDialog.setOnDismissListener(null);
            return;
        }
        this.mDialog.setOnDismissListener(dialog -> runnable.run());
    }

    @Override
    public WindowManager.LayoutParams getAttributes() {
        return this.mDialog.getWindowLayoutParams();
    }
}

