/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.appstyledview;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.car.ui.R;
import com.android.car.ui.appstyledview.AppStyledDialog;
import com.android.car.ui.appstyledview.AppStyledViewController;

public class AppStyledViewControllerImpl
implements AppStyledViewController {
    private static final String TAG = "AppStyledViewController";
    private final Context mContext;
    private int mAppStyleViewNavIcon;
    @Nullable
    private Runnable mAppStyledVCloseClickListener;
    @Nullable
    private View mAppStyledView;
    @Nullable
    private View mContent;
    @NonNull
    private final AppStyledDialog mDialog;

    public AppStyledViewControllerImpl(@NonNull Context context) {
        this.mContext = context;
        this.mDialog = new AppStyledDialog(context);
    }

    @NonNull
    public AppStyledDialog getDialog() {
        return this.mDialog;
    }

    @Override
    public void setNavIcon(int navIcon) {
        this.mAppStyleViewNavIcon = navIcon;
        this.updateNavIcon();
    }

    @Override
    public void setOnNavIconClickListener(@Nullable Runnable listener) {
        this.mAppStyledVCloseClickListener = listener;
        this.updateNavIconClickListener();
    }

    @Override
    public int getContentAreaWidth() {
        Window dialogWindow = this.mDialog.getWindow();
        if (dialogWindow == null) {
            return -1;
        }
        int width = dialogWindow.getAttributes().width;
        int orientation = this.mContext.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            return width - this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_toolbar_first_row_height);
        }
        return width;
    }

    @Override
    public int getContentAreaHeight() {
        Window dialogWindow = this.mDialog.getWindow();
        if (dialogWindow == null) {
            return -1;
        }
        int height = dialogWindow.getAttributes().height;
        int orientation = this.mContext.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            return height;
        }
        return height - this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_toolbar_first_row_height);
    }

    @Override
    public void setSceneType(int sceneType) {
        this.mDialog.setSceneType(sceneType);
    }

    private void updateContent() {
        if (this.mContent == null) {
            return;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Cannot update content with null. No-op.");
        }
        this.setContent(this.mContent);
        this.mDialog.setContentView(this.mAppStyledView);
    }

    @Override
    public void show() {
        this.updateContent();
        this.mDialog.show();
    }

    @Override
    public void dismiss() {
        this.mDialog.dismiss();
    }

    @Override
    public void setOnDismissListener(Runnable runnable) {
        if (runnable == null) {
            this.mDialog.setOnDismissListener(null);
            return;
        }
        this.mDialog.setOnDismissListener(dialog -> runnable.run());
    }

    @Override
    public WindowManager.LayoutParams getAttributes() {
        return this.mDialog.getWindowLayoutParams();
    }

    @Nullable
    public View createAppStyledView(@Nullable View contentView) {
        if (this.mContent == null) {
            return null;
        }
        if (this.mContent.getParent() != null) {
            ((ViewGroup)this.mContent.getParent()).removeView(this.mContent);
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        this.mAppStyledView = inflater.inflate(R.layout.car_ui_app_styled_view, null, false);
        this.mAppStyledView.setClipToOutline(true);
        ViewGroup contentHolder = (ViewGroup)this.mAppStyledView.findViewById(R.id.car_ui_app_styled_content);
        contentHolder.addView(contentView);
        this.updateNavIcon();
        this.updateNavIconClickListener();
        return this.mAppStyledView;
    }

    @Override
    public void setContent(@Nullable View contentView) {
        this.mContent = contentView;
        View unused = this.createAppStyledView(contentView);
    }

    private void updateNavIcon() {
        if (this.mAppStyledView == null) {
            return;
        }
        ImageView close = (ImageView)this.mAppStyledView.findViewById(R.id.car_ui_app_styled_view_icon_close);
        if (this.mAppStyleViewNavIcon == 0) {
            close.setImageResource(R.drawable.car_ui_icon_arrow_back);
        } else if (this.mAppStyleViewNavIcon == 1) {
            close.setImageResource(R.drawable.car_ui_icon_close);
        } else {
            close.setImageResource(R.drawable.car_ui_icon_close);
        }
    }

    private void updateNavIconClickListener() {
        if (this.mAppStyledView == null) {
            return;
        }
        FrameLayout navContainer = (FrameLayout)this.mAppStyledView.findViewById(R.id.car_ui_app_styled_view_nav_icon_container);
        if (navContainer != null) {
            navContainer.setOnClickListener(v -> {
                if (this.mAppStyledVCloseClickListener == null) {
                    return;
                }
                this.mAppStyledVCloseClickListener.run();
            });
        }
    }
}

