/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.core;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.android.car.ui.R;
import com.android.car.ui.baselayout.Insets;
import com.android.car.ui.baselayout.InsetsChangedListener;
import com.android.car.ui.pluginsupport.PluginFactorySingleton;
import com.android.car.ui.toolbar.ToolbarController;
import com.android.car.ui.utils.CarUiUtils;
import java.util.Map;
import java.util.WeakHashMap;

public final class BaseLayoutController {
    private static final Map<Activity, BaseLayoutController> sBaseLayoutMap = new WeakHashMap<Activity, BaseLayoutController>();
    private InsetsUpdater mInsetsUpdater;
    @Nullable
    private ToolbarController mToolbarController;

    @Nullable
    static BaseLayoutController getBaseLayoutController(@Nullable Activity activity) {
        return sBaseLayoutMap.get(activity);
    }

    private BaseLayoutController(Activity activity) {
        this.installBaseLayout(activity);
    }

    static void build(Activity activity) {
        if (CarUiUtils.getThemeBoolean(activity, R.attr.carUiBaseLayout)) {
            sBaseLayoutMap.put(activity, new BaseLayoutController(activity));
        }
    }

    static void destroy(Activity activity) {
        sBaseLayoutMap.remove(activity);
    }

    @Nullable
    ToolbarController getToolbarController() {
        return this.mToolbarController;
    }

    Insets getInsets() {
        return this.mInsetsUpdater.getInsets();
    }

    void dispatchNewInsets(Insets insets) {
        this.mInsetsUpdater.onCarUiInsetsChanged(insets);
    }

    void replaceInsetsChangedListenerWith(InsetsChangedListener listener) {
        this.mInsetsUpdater.replaceInsetsChangedListenerWith(listener);
    }

    private void installBaseLayout(Activity activity) {
        boolean toolbarEnabled = CarUiUtils.getThemeBoolean(activity, R.attr.carUiToolbar);
        Object contentView = CarUiUtils.requireViewByRefId(activity.getWindow().getDecorView(), 0x1020002);
        this.mInsetsUpdater = new InsetsUpdater(activity, (View)contentView);
        this.mToolbarController = PluginFactorySingleton.get((Context)activity).installBaseLayoutAround((Context)activity, (View)contentView, this.mInsetsUpdater, toolbarEnabled, true);
    }

    public static final class InsetsUpdater
    implements InsetsChangedListener {
        private InsetsChangedListener mInsetsChangedListenerDelegate;
        @Nullable
        private Activity mActivity;
        private View mContentView;
        @NonNull
        private Insets mInsets = new Insets();

        InsetsUpdater(@Nullable Activity activity, @NonNull View contentView) {
            this.mActivity = activity;
            this.mContentView = contentView;
        }

        @NonNull
        Insets getInsets() {
            return this.mInsets;
        }

        public void replaceInsetsChangedListenerWith(InsetsChangedListener listener) {
            this.mInsetsChangedListenerDelegate = listener;
        }

        @Override
        public void onCarUiInsetsChanged(@NonNull Insets insets) {
            if (this.mInsets.equals(insets)) {
                return;
            }
            this.mInsets = insets;
            boolean handled = false;
            if (this.mInsetsChangedListenerDelegate != null) {
                this.mInsetsChangedListenerDelegate.onCarUiInsetsChanged(insets);
                handled = true;
            } else {
                if (this.mActivity instanceof InsetsChangedListener) {
                    ((InsetsChangedListener)this.mActivity).onCarUiInsetsChanged(insets);
                    handled = true;
                }
                if (this.mActivity instanceof FragmentActivity) {
                    for (Fragment fragment : ((FragmentActivity)this.mActivity).getSupportFragmentManager().getFragments()) {
                        if (!(fragment instanceof InsetsChangedListener)) continue;
                        ((InsetsChangedListener)fragment).onCarUiInsetsChanged(insets);
                        handled = true;
                    }
                }
            }
            if (!handled) {
                this.mContentView.setPadding(insets.getLeft(), insets.getTop(), insets.getRight(), insets.getBottom());
            }
        }
    }
}

