/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.core;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.R;
import com.android.car.ui.baselayout.Insets;
import com.android.car.ui.baselayout.InsetsChangedListener;
import com.android.car.ui.core.BaseLayoutController;
import com.android.car.ui.pluginsupport.PluginFactorySingleton;
import com.android.car.ui.recyclerview.CarUiListItem;
import com.android.car.ui.toolbar.ToolbarController;
import java.util.List;
import java.util.Objects;

public class CarUi {
    public static final int TARGET_API_R = 30;

    private CarUi() {
    }

    @Nullable
    public static <T> T findCarUiComponentById(@Nullable View view, int id2) {
        if (view == null) {
            return null;
        }
        View componentView = view.findViewById(id2);
        return (T)(componentView != null ? componentView.getTag(R.id.car_ui_component_reference) : null);
    }

    @NonNull
    public static <T> T requireCarUiComponentById(View view, int id2) {
        return Objects.requireNonNull(CarUi.findCarUiComponentById(view, id2));
    }

    @Nullable
    public static ToolbarController getToolbar(@Nullable Activity activity) {
        BaseLayoutController controller = BaseLayoutController.getBaseLayoutController(activity);
        if (controller != null) {
            return controller.getToolbarController();
        }
        return null;
    }

    public static RecyclerView.Adapter<? extends RecyclerView.ViewHolder> createListItemAdapter(Context context, List<? extends CarUiListItem> items) {
        return PluginFactorySingleton.get(context).createListItemAdapter(items);
    }

    @NonNull
    public static ToolbarController requireToolbar(@NonNull Activity activity) {
        ToolbarController result = CarUi.getToolbar(activity);
        if (result == null) {
            throw new IllegalArgumentException("Activity " + activity + " does not have a CarUi Toolbar! Are you using Theme.CarUi.WithToolbar?");
        }
        return result;
    }

    public static void replaceInsetsChangedListenerWith(Activity activity, InsetsChangedListener listener) {
        BaseLayoutController controller = BaseLayoutController.getBaseLayoutController(activity);
        if (controller != null) {
            controller.replaceInsetsChangedListenerWith(listener);
        }
    }

    @Nullable
    public static Insets getInsets(@Nullable Activity activity) {
        BaseLayoutController controller = BaseLayoutController.getBaseLayoutController(activity);
        if (controller != null) {
            return controller.getInsets();
        }
        return null;
    }

    @NonNull
    public static Insets requireInsets(@NonNull Activity activity) {
        Insets result = CarUi.getInsets(activity);
        if (result == null) {
            throw new IllegalArgumentException("Activity " + activity + " does not have a base layout! Are you using Theme.CarUi.WithToolbar or Theme.CarUi.NoToolbar?");
        }
        return result;
    }

    @Deprecated
    @Nullable
    public static ToolbarController installBaseLayoutAround(View view, InsetsChangedListener insetsChangedListener, boolean hasToolbar) {
        return CarUi.installBaseLayoutAround(view.getContext(), view, insetsChangedListener, hasToolbar, true);
    }

    @Deprecated
    @Nullable
    public static ToolbarController installBaseLayoutAround(View view, InsetsChangedListener insetsChangedListener, boolean hasToolbar, boolean fullscreen) {
        return CarUi.installBaseLayoutAround(view.getContext(), view, insetsChangedListener, hasToolbar, fullscreen);
    }

    @Nullable
    public static ToolbarController installBaseLayoutAround(Context context, View view, InsetsChangedListener insetsChangedListener, boolean hasToolbar) {
        return CarUi.installBaseLayoutAround(context, view, insetsChangedListener, hasToolbar, true);
    }

    @Nullable
    public static ToolbarController installBaseLayoutAround(Context context, View view, InsetsChangedListener insetsChangedListener, boolean hasToolbar, boolean fullscreen) {
        return PluginFactorySingleton.get(context).installBaseLayoutAround(context, view, insetsChangedListener, hasToolbar, fullscreen);
    }
}

