/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.UserManager;
import android.util.Log;
import android.view.LayoutInflater;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import com.android.car.ui.CarUiLayoutInflaterFactory;
import com.android.car.ui.baselayout.Insets;
import com.android.car.ui.core.BaseLayoutController;
import com.android.car.ui.core.CarUiUserUnlockedReceiver;
import com.android.car.ui.pluginsupport.PluginFactory;
import com.android.car.ui.pluginsupport.PluginFactorySingleton;
import com.android.car.ui.utils.CarUiUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;

@SuppressLint(value={"LogConditional"})
public class CarUiInstaller
extends ContentProvider {
    private static final String TAG = "CarUiInstaller";
    private static final String CAR_UI_INSET_LEFT = "CAR_UI_INSET_LEFT";
    private static final String CAR_UI_INSET_RIGHT = "CAR_UI_INSET_RIGHT";
    private static final String CAR_UI_INSET_TOP = "CAR_UI_INSET_TOP";
    private static final String CAR_UI_INSET_BOTTOM = "CAR_UI_INSET_BOTTOM";
    private static final HashSet<Application> sAppsRegistered = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasAlreadyRegistered(Application application) {
        HashSet<Application> hashSet = sAppsRegistered;
        synchronized (hashSet) {
            return !sAppsRegistered.add(application);
        }
    }

    public boolean onCreate() {
        Context context = this.getContext();
        if (context == null || !(context.getApplicationContext() instanceof Application)) {
            Log.e((String)TAG, (String)"CarUiInstaller had a null context, unable to call register! Need app to call register by itself");
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        if (!packageManager.hasSystemFeature("android.hardware.type.automotive")) {
            return true;
        }
        Application application = (Application)context.getApplicationContext();
        Thread startOptimization = new Thread(() -> {
            PluginFactory unused = PluginFactorySingleton.get(context.getApplicationContext());
        });
        UserManager userManager = (UserManager)application.getSystemService(UserManager.class);
        if (userManager.isUserUnlocked()) {
            startOptimization.start();
        } else {
            CarUiUserUnlockedReceiver receiver = new CarUiUserUnlockedReceiver(startOptimization);
            IntentFilter filter = new IntentFilter("android.intent.action.USER_UNLOCKED");
            application.registerReceiver((BroadcastReceiver)receiver, filter, 0);
        }
        CarUiInstaller.register(application);
        return true;
    }

    public static void register(@NonNull Application application) {
        if (CarUiInstaller.hasAlreadyRegistered(application)) {
            return;
        }
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
            private Insets mInsets = null;
            private boolean mIsActivityStartedForFirstTime = false;

            @SuppressLint(value={"DiscouragedApi"})
            private boolean shouldRun(Activity activity) {
                int attrId = activity.getResources().getIdentifier("carUiActivity", "attr", CarUiUtils.getAppPackageName((Context)activity));
                return CarUiUtils.getThemeBoolean(activity, attrId);
            }

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                if (!this.shouldRun(activity)) {
                    return;
                }
                ComponentName comp = ComponentName.createRelative((Context)activity, (String)activity.getClass().getName());
                Log.i((String)CarUiInstaller.TAG, (String)("CarUiInstaller started for " + comp.flattenToShortString()));
                CarUiInstaller.injectLayoutInflaterFactory((Context)activity);
                CarUiInstaller.callMethodReflective(activity.getClassLoader(), BaseLayoutController.class, "build", null, new Object[]{activity});
                if (savedInstanceState != null) {
                    int inset_left = savedInstanceState.getInt(CarUiInstaller.CAR_UI_INSET_LEFT);
                    int inset_top = savedInstanceState.getInt(CarUiInstaller.CAR_UI_INSET_TOP);
                    int inset_right = savedInstanceState.getInt(CarUiInstaller.CAR_UI_INSET_RIGHT);
                    int inset_bottom = savedInstanceState.getInt(CarUiInstaller.CAR_UI_INSET_BOTTOM);
                    this.mInsets = new Insets(inset_left, inset_top, inset_right, inset_bottom);
                }
                this.mIsActivityStartedForFirstTime = true;
            }

            public void onActivityPostStarted(Activity activity) {
                if (!this.shouldRun(activity)) {
                    return;
                }
                Object controller = CarUiInstaller.callMethodReflective(activity.getClassLoader(), BaseLayoutController.class, "getBaseLayoutController", null, new Object[]{activity});
                if (this.mInsets != null && controller != null && this.mIsActivityStartedForFirstTime) {
                    CarUiInstaller.callMethodReflective(activity.getClassLoader(), BaseLayoutController.class, "dispatchNewInsets", controller, new Object[]{CarUiInstaller.changeInsetsClassLoader(activity.getClassLoader(), this.mInsets)});
                    this.mIsActivityStartedForFirstTime = false;
                }
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                if (!this.shouldRun(activity)) {
                    return;
                }
                Object controller = CarUiInstaller.callMethodReflective(activity.getClassLoader(), BaseLayoutController.class, "getBaseLayoutController", null, new Object[]{activity});
                if (controller != null) {
                    Object insets = CarUiInstaller.callMethodReflective(activity.getClassLoader(), BaseLayoutController.class, "getInsets", controller, new Object[0]);
                    outState.putInt(CarUiInstaller.CAR_UI_INSET_LEFT, ((Integer)CarUiInstaller.callMethodReflective(activity.getClassLoader(), Insets.class, "getLeft", insets, new Object[0])).intValue());
                    outState.putInt(CarUiInstaller.CAR_UI_INSET_TOP, ((Integer)CarUiInstaller.callMethodReflective(activity.getClassLoader(), Insets.class, "getTop", insets, new Object[0])).intValue());
                    outState.putInt(CarUiInstaller.CAR_UI_INSET_RIGHT, ((Integer)CarUiInstaller.callMethodReflective(activity.getClassLoader(), Insets.class, "getRight", insets, new Object[0])).intValue());
                    outState.putInt(CarUiInstaller.CAR_UI_INSET_BOTTOM, ((Integer)CarUiInstaller.callMethodReflective(activity.getClassLoader(), Insets.class, "getBottom", insets, new Object[0])).intValue());
                }
            }

            public void onActivityDestroyed(Activity activity) {
                if (!this.shouldRun(activity)) {
                    return;
                }
                CarUiInstaller.callMethodReflective(activity.getClassLoader(), BaseLayoutController.class, "destroy", null, new Object[]{activity});
            }
        });
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    private static Object callMethodReflective(@NonNull ClassLoader cl, @NonNull Class<?> srcClass, @NonNull String methodName, @Nullable Object instance, Object ... args) {
        try {
            Class<?> clazz = cl.loadClass(srcClass.getName());
            Class[] classArgs = args == null ? null : (Class[])Arrays.stream(args).map(arg -> arg instanceof Activity ? Activity.class : arg.getClass()).toArray(Class[]::new);
            Method method = clazz.getDeclaredMethod(methodName, classArgs);
            method.setAccessible(true);
            return method.invoke(instance, args);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException("Failed to make reflective call to " + methodName + " on " + instance, e.getCause() == null ? e : e.getCause());
        }
    }

    private static Object changeInsetsClassLoader(@NonNull ClassLoader cl, @Nullable Insets src) {
        if (src == null) {
            return null;
        }
        try {
            Class<?> insetsClass = cl.loadClass(Insets.class.getName());
            Constructor<?> cnst = insetsClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            cnst.setAccessible(true);
            return cnst.newInstance(src.getLeft(), src.getTop(), src.getRight(), src.getBottom());
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static void injectLayoutInflaterFactory(Context context) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        if (layoutInflater.getFactory2() == null) {
            layoutInflater.setFactory2((LayoutInflater.Factory2)new CarUiLayoutInflaterFactory());
        } else if (!(layoutInflater.getFactory2() instanceof CarUiLayoutInflaterFactory) && !(layoutInflater.getFactory2() instanceof AppCompatDelegate)) {
            throw new AssertionError((Object)(layoutInflater.getFactory2() + " must extend CarUiLayoutInflaterFactory"));
        }
    }
}

