/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.core;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;

public class SearchResultsProvider
extends ContentProvider {
    public static final String ITEM_ID = "primaryId";
    public static final String SECONDARY_IMAGE_ID = "secondary";
    public static final String PRIMARY_IMAGE_BLOB = "primary_image";
    public static final String SECONDARY_IMAGE_BLOB = "secondary_image";
    public static final String TITLE = "title";
    public static final String SUBTITLE = "subtitle";
    private final List<ContentValues> mSearchResults = new ArrayList<ContentValues>();
    private static final String SEARCH_RESULTS_TABLE_NAME = "search_results";

    @NonNull
    public static String getAuthority(@NonNull String packageName) {
        return "content://" + packageName + "." + SearchResultsProvider.class.getSimpleName();
    }

    @NonNull
    public static Uri getSearchResultsTableUri(@NonNull Context context) {
        return Uri.parse((String)(SearchResultsProvider.getAuthority(context.getPackageName()) + "/" + SEARCH_RESULTS_TABLE_NAME));
    }

    public boolean onCreate() {
        return true;
    }

    public Uri insert(Uri uri, ContentValues values) {
        this.mSearchResults.add(values);
        Uri contentUri = SearchResultsProvider.getSearchResultsTableUri(this.getContext());
        contentUri = ContentUris.withAppendedId((Uri)contentUri, (long)(this.mSearchResults.size() - 1));
        this.getContext().getContentResolver().notifyChange(contentUri, null);
        return contentUri;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        MatrixCursor cursor = new MatrixCursor(new String[]{ITEM_ID, SECONDARY_IMAGE_ID, PRIMARY_IMAGE_BLOB, SECONDARY_IMAGE_BLOB, TITLE, SUBTITLE});
        for (ContentValues values : this.mSearchResults) {
            cursor.addRow(new Object[]{values.get(ITEM_ID), values.get(SECONDARY_IMAGE_ID), values.get(PRIMARY_IMAGE_BLOB), values.get(SECONDARY_IMAGE_BLOB), values.get(TITLE), values.get(SUBTITLE)});
        }
        return cursor;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        this.mSearchResults.clear();
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    public String getType(Uri uri) {
        return null;
    }
}

