/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.imewidescreen;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.ExtractEditText;
import android.inputmethodservice.InputMethodService;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.SurfaceControlViewHost;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.CarUiLayoutInflaterFactory;
import com.android.car.ui.R;
import com.android.car.ui.core.SearchResultsProvider;
import com.android.car.ui.recyclerview.CarUiContentListItem;
import com.android.car.ui.recyclerview.CarUiListItemAdapter;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.utils.CarUiUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@RequiresApi(value=30)
public class CarUiImeWideScreenController {
    private static final String TAG = "ImeWideScreenController";
    private static final String NOT_ASTERISK_OR_CAPTURED_ASTERISK = "[^*]+|(\\*)";
    public static final String WIDE_SCREEN_ACTION = "automotive_wide_screen";
    public static final String WIDE_SCREEN_CLEAR_DATA_ACTION = "automotive_wide_screen_clear_data";
    public static final String WIDE_SCREEN_ON_BACK_CLICKED_ACTION = "automotive_wide_screen_back_clicked";
    public static final String WIDE_SCREEN_POST_LOAD_SEARCH_RESULTS_ACTION = "automotive_wide_screen_post_load_search_results";
    public static final String WIDE_SCREEN_SEARCH_RESULTS = "wide_screen_search_results";
    public static final String WIDE_SCREEN_EXTRACTED_TEXT_ICON_RES_ID = "extracted_text_icon_res_id";
    public static final String WIDE_SCREEN_EXTRACTED_TEXT_ICON = "extracted_text_icon";
    public static final String WIDE_SCREEN_HIDE_EXTRACTED_TEXT_VIEW = "hide_extracted_text_view";
    public static final String REQUEST_RENDER_CONTENT_AREA = "request_render_content_area";
    public static final String ADD_DESC_TITLE_TO_CONTENT_AREA = "add_desc_title_to_content_area";
    public static final String ADD_DESC_TO_CONTENT_AREA = "add_desc_to_content_area";
    public static final String ADD_ERROR_DESC_TO_INPUT_AREA = "add_error_desc_to_input_area";
    public static final String SEARCH_RESULT_ITEM_ID_LIST = "search_result_item_id_list";
    public static final String SEARCH_RESULT_SUPPLEMENTAL_ICON_ID_LIST = "search_result_supplemental_icon_id_list";
    public static final String CONTENT_AREA_SURFACE_PACKAGE = "content_area_surface_package";
    public static final String CONTENT_AREA_SURFACE_HOST_TOKEN = "content_area_surface_host_token";
    public static final String CONTENT_AREA_SURFACE_DISPLAY_ID = "content_area_surface_display_id";
    public static final String CONTENT_AREA_SURFACE_HEIGHT = "content_area_surface_height";
    public static final String CONTENT_AREA_SURFACE_WIDTH = "content_area_surface_width";
    private View mRootView;
    private final Context mContext;
    @Nullable
    private View mExtractActionAutomotive;
    @NonNull
    private View mContentAreaAutomotive;
    private boolean mImeRendersAllContent = true;
    private boolean mAllowAppToHideContentArea;
    @Nullable
    private ArrayList<CarUiContentListItem> mAutomotiveSearchItems;
    @NonNull
    private TextView mWideScreenDescriptionTitle;
    @NonNull
    private TextView mWideScreenDescription;
    @NonNull
    private TextView mWideScreenErrorMessage;
    @NonNull
    private ImageView mWideScreenErrorImage;
    @NonNull
    private ImageView mWideScreenClearData;
    @NonNull
    private CarUiRecyclerView mRecyclerView;
    @Nullable
    private ImageView mWideScreenExtractedTextIcon;
    private boolean mIsExtractIconProvidedByApp;
    @NonNull
    private FrameLayout mInputFrame;
    @NonNull
    private ExtractEditText mExtractEditText;
    @NonNull
    private EditorInfo mInputEditorInfo;
    private InputConnection mInputConnection;
    private boolean mExtractViewHidden;
    @NonNull
    private View mFullscreenArea;
    @NonNull
    private SurfaceView mContentAreaSurfaceView;
    @NonNull
    private FrameLayout mInputExtractEditTextContainer;
    private final InputMethodService mInputMethodService;

    public CarUiImeWideScreenController(@NonNull Context context, @NonNull InputMethodService ims) {
        this.mContext = context;
        this.mInputMethodService = ims;
    }

    public View createWideScreenImeView(@NonNull View inputView) {
        if (!this.isWideScreenMode()) {
            return inputView;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        if (inflater.getFactory2() == null) {
            inflater.setFactory2((LayoutInflater.Factory2)new CarUiLayoutInflaterFactory());
        }
        this.mRootView = inflater.inflate(R.layout.car_ui_ims_wide_screen_input_view, null);
        this.mInputFrame = (FrameLayout)this.mRootView.requireViewById(R.id.car_ui_wideScreenInputArea);
        this.mInputFrame.addView(inputView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.mAllowAppToHideContentArea = this.mContext.getResources().getBoolean(R.bool.car_ui_ime_wide_screen_allow_app_hide_content_area);
        this.mContentAreaSurfaceView = (SurfaceView)this.mRootView.requireViewById(R.id.car_ui_ime_surface);
        this.mContentAreaSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                Bundle bundle = new Bundle();
                bundle.putInt(CarUiImeWideScreenController.CONTENT_AREA_SURFACE_HEIGHT, CarUiImeWideScreenController.this.mContentAreaSurfaceView.getHeight());
                bundle.putInt(CarUiImeWideScreenController.CONTENT_AREA_SURFACE_WIDTH, CarUiImeWideScreenController.this.mContentAreaSurfaceView.getWidth());
                CarUiImeWideScreenController.this.mInputConnection.performPrivateCommand(CarUiImeWideScreenController.WIDE_SCREEN_ACTION, bundle);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        });
        this.mContentAreaSurfaceView.setZOrderOnTop(true);
        this.mWideScreenDescriptionTitle = (TextView)this.mRootView.requireViewById(R.id.car_ui_wideScreenDescriptionTitle);
        this.mWideScreenDescription = (TextView)this.mRootView.requireViewById(R.id.car_ui_wideScreenDescription);
        this.mExtractActionAutomotive = this.mRootView.findViewById(R.id.car_ui_inputExtractActionAutomotive);
        this.mContentAreaAutomotive = this.mRootView.requireViewById(R.id.car_ui_contentAreaAutomotive);
        this.mRecyclerView = (CarUiRecyclerView)this.mRootView.requireViewById(R.id.car_ui_wideScreenSearchResultList);
        this.mWideScreenErrorMessage = (TextView)this.mRootView.requireViewById(R.id.car_ui_wideScreenErrorMessage);
        this.mWideScreenExtractedTextIcon = (ImageView)this.mRootView.findViewById(R.id.car_ui_wideScreenExtractedTextIcon);
        this.mWideScreenErrorImage = (ImageView)this.mRootView.requireViewById(R.id.car_ui_wideScreenError);
        this.mWideScreenClearData = (ImageView)this.mRootView.requireViewById(R.id.car_ui_wideScreenClearData);
        this.mFullscreenArea = this.mRootView.requireViewById(R.id.car_ui_fullscreenArea);
        this.mInputExtractEditTextContainer = (FrameLayout)this.mRootView.requireViewById(R.id.car_ui_inputExtractEditTextContainer);
        this.mWideScreenClearData.setOnClickListener(v -> this.mInputConnection.performPrivateCommand(WIDE_SCREEN_CLEAR_DATA_ACTION, null));
        this.mExtractViewHidden = false;
        return this.mRootView;
    }

    public void onComputeInsets(@NonNull InputMethodService.Insets outInsets) {
        if (!this.isWideScreenMode()) {
            return;
        }
        Rect tempRect = new Rect();
        int[] tempLocation = new int[2];
        outInsets.contentTopInsets = outInsets.visibleTopInsets = this.mInputMethodService.getWindow().getWindow().getDecorView().getHeight();
        if (this.mImeRendersAllContent) {
            outInsets.touchableRegion.setEmpty();
            outInsets.touchableInsets = 0;
        } else {
            this.mInputFrame.getLocationOnScreen(tempLocation);
            tempRect.set(0, 0, tempLocation[0] + this.mInputFrame.getWidth(), tempLocation[1] + this.mInputFrame.getHeight());
            outInsets.touchableRegion.set(tempRect);
            outInsets.touchableInsets = 3;
        }
    }

    @RequiresApi(value=30)
    public void onAppPrivateCommand(String action, Bundle data) {
        byte[] byteArray;
        boolean hideExtractedTextView;
        String errorMessage;
        String disc;
        String discTitle;
        if (!this.isWideScreenMode()) {
            return;
        }
        this.resetAutomotiveWideScreenViews();
        if (data == null) {
            return;
        }
        if (this.mAllowAppToHideContentArea || this.mInputEditorInfo != null && this.isPackageAuthorized(this.getEditorInfoPackageName())) {
            this.mImeRendersAllContent = data.getBoolean(REQUEST_RENDER_CONTENT_AREA, true);
            if (!this.mImeRendersAllContent) {
                this.mContentAreaAutomotive.setVisibility(8);
            } else {
                this.mContentAreaAutomotive.setVisibility(0);
            }
        }
        if (data.getParcelable(CONTENT_AREA_SURFACE_PACKAGE) != null && Build.VERSION.SDK_INT >= 30) {
            SurfaceControlViewHost.SurfacePackage surfacePackage = (SurfaceControlViewHost.SurfacePackage)data.getParcelable(CONTENT_AREA_SURFACE_PACKAGE);
            this.mContentAreaSurfaceView.setChildSurfacePackage(surfacePackage);
            this.mContentAreaSurfaceView.setVisibility(0);
            this.mContentAreaAutomotive.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)(discTitle = data.getString(ADD_DESC_TITLE_TO_CONTENT_AREA)))) {
            this.mWideScreenDescriptionTitle.setText((CharSequence)discTitle);
            this.mWideScreenDescriptionTitle.setVisibility(0);
            this.mContentAreaAutomotive.setBackground(this.mContext.getDrawable(R.drawable.car_ui_ime_wide_screen_background));
        }
        if (!TextUtils.isEmpty((CharSequence)(disc = data.getString(ADD_DESC_TO_CONTENT_AREA)))) {
            this.mWideScreenDescription.setText((CharSequence)disc);
            this.mWideScreenDescription.setVisibility(0);
            this.mContentAreaAutomotive.setBackground(this.mContext.getDrawable(R.drawable.car_ui_ime_wide_screen_background));
        }
        if (!TextUtils.isEmpty((CharSequence)(errorMessage = data.getString(ADD_ERROR_DESC_TO_INPUT_AREA)))) {
            this.mWideScreenErrorMessage.setVisibility(0);
            this.mWideScreenClearData.setVisibility(8);
            this.mWideScreenErrorImage.setVisibility(0);
            this.setExtractedEditTextBackground(R.drawable.car_ui_ime_wide_screen_input_area_tint_error_color);
            this.mWideScreenErrorMessage.setText((CharSequence)errorMessage);
            this.mContentAreaAutomotive.setBackground(this.mContext.getDrawable(R.drawable.car_ui_ime_wide_screen_background));
        }
        if (TextUtils.isEmpty((CharSequence)errorMessage)) {
            this.mWideScreenErrorMessage.setVisibility(4);
            this.mWideScreenErrorMessage.setText((CharSequence)"");
            this.mWideScreenClearData.setVisibility(0);
            this.mWideScreenErrorImage.setVisibility(8);
            this.setExtractedEditTextBackground(R.drawable.car_ui_ime_wide_screen_input_area_tint_color);
        }
        this.updateExtractViewVisibility(!(hideExtractedTextView = data.getBoolean(WIDE_SCREEN_HIDE_EXTRACTED_TEXT_VIEW)));
        int extractedTextIcon = data.getInt(WIDE_SCREEN_EXTRACTED_TEXT_ICON_RES_ID);
        if (extractedTextIcon != 0) {
            this.setWideScreenExtractedIcon(extractedTextIcon);
        }
        if ((byteArray = data.getByteArray(WIDE_SCREEN_EXTRACTED_TEXT_ICON)) != null) {
            Bitmap bitmap = CarUiImeWideScreenController.getBitmapFromBytes(byteArray);
            this.mWideScreenExtractedTextIcon.setImageDrawable((Drawable)new BitmapDrawable(this.mContext.getResources(), bitmap));
            this.mWideScreenExtractedTextIcon.setVisibility(0);
            this.mIsExtractIconProvidedByApp = true;
        }
        if (WIDE_SCREEN_SEARCH_RESULTS.equals(action)) {
            this.loadSearchItems();
        }
        if (this.mExtractActionAutomotive != null) {
            this.mExtractActionAutomotive.setVisibility(0);
        }
        if (this.mAutomotiveSearchItems != null) {
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
            this.mRecyclerView.setVerticalScrollBarEnabled(true);
            this.mRecyclerView.setVerticalScrollbarPosition(1);
            this.mRecyclerView.setVisibility(0);
            this.mRecyclerView.setAdapter(new CarUiListItemAdapter(this.mAutomotiveSearchItems));
            this.mContentAreaAutomotive.setBackground(this.mContext.getDrawable(R.drawable.car_ui_ime_wide_screen_background));
            if (this.mExtractActionAutomotive != null) {
                this.mExtractActionAutomotive.setVisibility(8);
            }
        }
    }

    @SuppressLint(value={"Range"})
    private void loadSearchItems() {
        if (this.mInputEditorInfo == null) {
            Log.w((String)TAG, (String)"Result can't be loaded, input InputEditorInfo not available ");
            return;
        }
        Uri contentUrl = Uri.parse((String)SearchResultsProvider.getAuthority(this.getPackageName(this.mInputEditorInfo)));
        ContentResolver cr = this.mContext.getContentResolver();
        try (Cursor c = cr.query(contentUrl, null, null, null, null);){
            this.mAutomotiveSearchItems = new ArrayList();
            if (c != null && c.moveToFirst()) {
                do {
                    byte[] secondaryBlob;
                    CarUiContentListItem searchItem = new CarUiContentListItem(CarUiContentListItem.Action.ICON);
                    String itemId = c.getString(c.getColumnIndex("primaryId"));
                    searchItem.setOnItemClickedListener(v -> this.onItemClicked(itemId));
                    searchItem.setTitle(c.getString(c.getColumnIndex("title")));
                    searchItem.setBody(c.getString(c.getColumnIndex("subtitle")));
                    searchItem.setPrimaryIconType(CarUiContentListItem.IconType.CONTENT);
                    byte[] primaryBlob = c.getBlob(c.getColumnIndex("primary_image"));
                    if (primaryBlob != null) {
                        Bitmap primaryBitmap = CarUiImeWideScreenController.getBitmapFromBytes(primaryBlob);
                        searchItem.setIcon((Drawable)new BitmapDrawable(this.mContext.getResources(), primaryBitmap));
                    }
                    if ((secondaryBlob = c.getBlob(c.getColumnIndex("secondary_image"))) != null) {
                        Bitmap secondaryBitmap = CarUiImeWideScreenController.getBitmapFromBytes(secondaryBlob);
                        String secondaryItemId = c.getString(c.getColumnIndex("secondary"));
                        searchItem.setSupplementalIcon((Drawable)new BitmapDrawable(this.mContext.getResources(), secondaryBitmap), v -> {
                            Bundle bundle = new Bundle();
                            bundle.putString(SEARCH_RESULT_SUPPLEMENTAL_ICON_ID_LIST, secondaryItemId);
                            this.mInputConnection.performPrivateCommand(WIDE_SCREEN_ACTION, bundle);
                        });
                    }
                    this.mAutomotiveSearchItems.add(searchItem);
                } while (c.moveToNext());
            }
        }
        this.mInputConnection.performPrivateCommand(WIDE_SCREEN_POST_LOAD_SEARCH_RESULTS_ACTION, null);
    }

    void onItemClicked(String itemId) {
        Bundle bundle = new Bundle();
        bundle.putString(SEARCH_RESULT_ITEM_ID_LIST, itemId);
        this.mInputConnection.performPrivateCommand(WIDE_SCREEN_ACTION, bundle);
    }

    private static Bitmap getBitmapFromBytes(byte[] bytes) {
        if (bytes != null) {
            try {
                return (Bitmap)Bitmap.CREATOR.createFromParcel(CarUiImeWideScreenController.byteArrayToParcel(bytes));
            }
            catch (BadParcelableException e) {
                Log.e((String)TAG, (String)"failed to create bitmap", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static Parcel byteArrayToParcel(byte[] bytes) throws BadParcelableException {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(bytes, 0, bytes.length);
        parcel.setDataPosition(0);
        return parcel;
    }

    public boolean onEvaluateFullscreenMode(boolean isFullScreen) {
        return this.isWideScreenMode() || isFullScreen;
    }

    @RequiresApi(value=30)
    public void onStartInputView(@NonNull EditorInfo editorInfo, @Nullable InputConnection inputConnection, @Nullable CharSequence textForImeAction) {
        boolean hasLabel;
        if (!this.isWideScreenMode()) {
            return;
        }
        this.mInputEditorInfo = editorInfo;
        this.mInputConnection = inputConnection;
        View header = this.mRootView.requireViewById(R.id.car_ui_imeWideScreenInputArea);
        header.setVisibility(0);
        if (this.mExtractViewHidden) {
            this.mFullscreenArea.setVisibility(4);
        } else {
            this.mFullscreenArea.setVisibility(0);
        }
        this.mExtractEditText = this.getExtractEditText();
        this.mExtractEditText.setPadding(this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_ime_wide_screen_input_edit_text_padding_left), 0, this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_ime_wide_screen_input_edit_text_padding_right), 0);
        this.mExtractEditText.setTextSize((float)this.mContext.getResources().getDimensionPixelSize(R.dimen.car_ui_ime_wide_screen_input_edit_text_size));
        this.mExtractEditText.setGravity(8388627);
        ViewGroup parent = (ViewGroup)this.mExtractEditText.getParent();
        parent.removeViewInLayout((View)this.mExtractEditText);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mInputExtractEditTextContainer.addView((View)this.mExtractEditText, (ViewGroup.LayoutParams)params);
        ImageView close = (ImageView)this.mRootView.findViewById(R.id.car_ui_closeKeyboard);
        if (close != null) {
            close.setOnClickListener(v -> {
                this.mInputMethodService.requestHideSelf(0);
                this.mInputConnection.performPrivateCommand(WIDE_SCREEN_ON_BACK_CLICKED_ACTION, null);
            });
        }
        if (!this.mIsExtractIconProvidedByApp) {
            this.setWideScreenExtractedIcon(0);
        }
        boolean hasAction = (this.mInputEditorInfo.imeOptions & 0xFF) != 1;
        boolean hasInputType = this.mInputEditorInfo.inputType != 0;
        boolean hasNoAccessoryAction = (this.mInputEditorInfo.imeOptions & 0x20000000) == 0;
        boolean bl = hasLabel = this.mInputEditorInfo.actionLabel != null || hasAction && hasNoAccessoryAction && hasInputType;
        if (hasLabel) {
            this.intiExtractAction(textForImeAction);
        }
        if (this.mContentAreaSurfaceView.getVisibility() == 8) {
            this.sendSurfaceInfo();
        }
    }

    @VisibleForTesting
    ExtractEditText getExtractEditText() {
        return (ExtractEditText)this.mRootView.getRootView().requireViewById(16908325);
    }

    @RequiresApi(value=30)
    private void sendSurfaceInfo() {
        if (!(this.mAllowAppToHideContentArea || this.mContentAreaSurfaceView.getDisplay() != null || this.mInputEditorInfo != null && this.isPackageAuthorized(this.getEditorInfoPackageName()))) {
            return;
        }
        this.mRootView.dispatchWindowVisibilityChanged(0);
        int displayId = this.mContentAreaSurfaceView.getDisplay() == null ? 0 : this.mContentAreaSurfaceView.getDisplay().getDisplayId();
        IBinder hostToken = this.mContentAreaSurfaceView.getHostToken();
        Bundle bundle = new Bundle();
        bundle.putBinder(CONTENT_AREA_SURFACE_HOST_TOKEN, hostToken);
        bundle.putInt(CONTENT_AREA_SURFACE_DISPLAY_ID, displayId);
        bundle.putInt(CONTENT_AREA_SURFACE_HEIGHT, this.mContentAreaSurfaceView.getHeight() + this.getNavBarHeight());
        bundle.putInt(CONTENT_AREA_SURFACE_WIDTH, this.mContentAreaSurfaceView.getWidth());
        this.mInputConnection.performPrivateCommand(WIDE_SCREEN_ACTION, bundle);
    }

    @VisibleForTesting
    boolean isPackageAuthorized(String packageName) {
        String[] packages = this.mContext.getResources().getStringArray(R.array.car_ui_ime_wide_screen_allowed_package_list);
        PackageInfo packageInfo = CarUiImeWideScreenController.getPackageInfo(this.mContext, packageName);
        if (packageInfo != null && (packageInfo.applicationInfo.flags & 0x81) != 0) {
            return true;
        }
        for (String pattern : packages) {
            String regex = CarUiImeWideScreenController.createRegexFromGlob(pattern);
            if (!packageName.matches(regex)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PackageInfo getPackageInfo(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.e((String)TAG, (String)("package not found: " + packageName));
        }
        return packageInfo;
    }

    private static String createRegexFromGlob(String glob) {
        Pattern reg = Pattern.compile(NOT_ASTERISK_OR_CAPTURED_ASTERISK);
        Matcher m = reg.matcher(glob);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            if (m.group(1) != null) {
                m.appendReplacement(b, ".*");
                continue;
            }
            m.appendReplacement(b, Matcher.quoteReplacement(m.group(0)));
        }
        m.appendTail(b);
        return b.toString();
    }

    private int getNavBarHeight() {
        Resources resources = this.mContext.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public void setExtractViewShown(boolean shown) {
        if (!this.isWideScreenMode()) {
            return;
        }
        this.updateExtractViewVisibility(true);
    }

    private void updateExtractViewVisibility(boolean visible) {
        if (this.mExtractViewHidden == !visible) {
            return;
        }
        boolean bl = this.mExtractViewHidden = !visible;
        if (this.mExtractViewHidden) {
            this.mFullscreenArea.setVisibility(4);
        } else {
            this.mFullscreenArea.setVisibility(0);
        }
    }

    private void intiExtractAction(CharSequence textForImeAction) {
        if (this.mExtractActionAutomotive == null) {
            return;
        }
        if (this.mInputEditorInfo.actionLabel != null) {
            ((TextView)this.mExtractActionAutomotive).setText(this.mInputEditorInfo.actionLabel);
        } else {
            ((TextView)this.mExtractActionAutomotive).setText(textForImeAction);
        }
        this.mExtractActionAutomotive.setOnClickListener(v -> {
            EditorInfo editorInfo = this.mInputEditorInfo;
            InputConnection inputConnection = this.mInputConnection;
            if (editorInfo == null || inputConnection == null) {
                return;
            }
            if (editorInfo.actionId != 0) {
                inputConnection.performEditorAction(editorInfo.actionId);
            } else if ((editorInfo.imeOptions & 0xFF) != 1) {
                inputConnection.performEditorAction(editorInfo.imeOptions & 0xFF);
            }
        });
    }

    private void setExtractedEditTextBackground(int drawableResId) {
        this.mExtractEditText.setBackgroundTintList(this.mContext.getColorStateList(drawableResId));
    }

    @VisibleForTesting
    void setContentAreaSurfaceView(SurfaceView surfaceView) {
        this.mContentAreaSurfaceView = surfaceView;
    }

    @VisibleForTesting
    String getPackageName(EditorInfo editorInfo) {
        return editorInfo.packageName;
    }

    private void setWideScreenExtractedIcon(@DrawableRes int iconResId) {
        if (this.mInputEditorInfo == null || this.mWideScreenExtractedTextIcon == null) {
            return;
        }
        try {
            if (iconResId == 0) {
                this.mWideScreenExtractedTextIcon.setImageDrawable(this.mContext.getPackageManager().getApplicationIcon(this.getEditorInfoPackageName()));
            } else {
                this.mIsExtractIconProvidedByApp = true;
                this.mWideScreenExtractedTextIcon.setImageDrawable(this.mContext.createPackageContext(this.getEditorInfoPackageName(), 0).getDrawable(iconResId));
            }
            this.mWideScreenExtractedTextIcon.setVisibility(0);
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.w((String)TAG, (String)"setWideScreenExtractedIcon: package name not found ", (Throwable)ex);
            this.mWideScreenExtractedTextIcon.setVisibility(8);
        }
        catch (Resources.NotFoundException ex) {
            Log.w((String)TAG, (String)("setWideScreenExtractedIcon: resource not found with id " + iconResId), (Throwable)ex);
            this.mWideScreenExtractedTextIcon.setVisibility(8);
        }
    }

    @VisibleForTesting
    String getEditorInfoPackageName() {
        return this.mInputEditorInfo != null ? this.mInputEditorInfo.packageName : null;
    }

    @RequiresApi(value=30)
    public void onFinishInputView() {
        if (!this.isWideScreenMode()) {
            return;
        }
        this.resetAutomotiveWideScreenViews();
    }

    @RequiresApi(value=30)
    private void resetAutomotiveWideScreenViews() {
        this.mWideScreenDescriptionTitle.setVisibility(8);
        this.mContentAreaSurfaceView.setVisibility(8);
        this.mWideScreenErrorMessage.setVisibility(8);
        this.mRecyclerView.setVisibility(8);
        this.mWideScreenDescription.setVisibility(8);
        this.mFullscreenArea.setVisibility(0);
        if (this.mWideScreenExtractedTextIcon != null) {
            this.mWideScreenExtractedTextIcon.setVisibility(0);
        }
        this.mWideScreenClearData.setVisibility(0);
        this.mWideScreenErrorImage.setVisibility(8);
        if (this.mExtractActionAutomotive != null) {
            this.mExtractActionAutomotive.setVisibility(8);
        }
        this.mContentAreaAutomotive.setVisibility(0);
        this.mContentAreaAutomotive.setBackground(this.mContext.getDrawable(R.drawable.car_ui_ime_wide_screen_no_content_background));
        this.setExtractedEditTextBackground(R.drawable.car_ui_ime_wide_screen_input_area_tint_color);
        this.mImeRendersAllContent = true;
        this.mIsExtractIconProvidedByApp = false;
        this.mExtractViewHidden = false;
        this.mAutomotiveSearchItems = null;
    }

    public boolean isWideScreenMode() {
        return CarUiUtils.getBooleanSystemProperty(this.mContext.getResources(), R.string.car_ui_ime_wide_screen_system_property_name, false) && Build.VERSION.SDK_INT >= 30;
    }
}

