/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.pluginsupport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.car.ui.pluginsupport.OemApi;
import com.android.car.ui.pluginsupport.OemApiUtil;
import dalvik.system.PathClassLoader;
import java.util.regex.Pattern;

class AdapterClassLoader
extends PathClassLoader {
    @Nullable
    private final ClassLoader mPluginClassLoader;
    private static final Pattern PATTERN = Pattern.compile("^com\\.android\\.car\\.ui\\..*AdapterV[0-9]+(\\$.*)?$|Lambda|^" + Pattern.quote(OemApiUtil.class.getName()) + "|^" + Pattern.quote(OemApi.class.getName()) + "$");
    private static final Pattern PLUGIN_PATTERN = Pattern.compile("^com\\.android\\.car\\.ui\\.plugin\\.(oemapis\\..*|PluginVersionProviderImpl)$");

    AdapterClassLoader(String dexPath, @Nullable ClassLoader parent, @Nullable ClassLoader additionalClassloader) {
        this(dexPath, null, parent, additionalClassloader);
    }

    AdapterClassLoader(String dexPath, String librarySearchPath, @Nullable ClassLoader parent, @Nullable ClassLoader additionalClassloader) {
        this(dexPath, librarySearchPath, parent, additionalClassloader, true);
    }

    AdapterClassLoader(@NonNull String dexPath, @Nullable String librarySearchPath, @Nullable ClassLoader parent, @Nullable ClassLoader additionalClassloader, boolean delegateResourceLoading) {
        super(dexPath, librarySearchPath, parent);
        this.mPluginClassLoader = additionalClassloader;
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class cl = this.findLoadedClass(name);
        if (cl != null) {
            return cl;
        }
        try {
            return Object.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassNotFoundException fromSuper = null;
            if (name != null && PATTERN.matcher(name).find()) {
                try {
                    return this.findClass(name);
                }
                catch (ClassNotFoundException ex) {
                    fromSuper = ex;
                }
            }
            if (this.mPluginClassLoader != null && PLUGIN_PATTERN.matcher(name).matches()) {
                try {
                    return this.mPluginClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
            try {
                return this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                if (fromSuper == null) {
                    throw cnfe;
                }
                throw fromSuper;
            }
        }
    }
}

