/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.pluginsupport;

import android.util.Log;
import androidx.annotation.Nullable;
import com.android.car.ui.pluginsupport.PluginFactory;
import java.lang.reflect.Constructor;

class OemApi
implements Comparable<OemApi> {
    private static final String TAG = "carui";
    public final Class<?> oemFactoryClass;
    public final Class<?> adapterClass;
    public final int version;

    OemApi(String oemFactoryClassName, Class<?> adapterClass, int version) {
        this.oemFactoryClass = OemApi.loadClass(oemFactoryClassName);
        this.adapterClass = adapterClass;
        this.version = version;
    }

    public PluginFactory getAdapter(Object oemFactory) {
        PluginFactory adapter = null;
        try {
            Constructor<?> constructor = this.adapterClass.getDeclaredConstructor(this.oemFactoryClass);
            constructor.setAccessible(true);
            adapter = (PluginFactory)constructor.newInstance(oemFactory);
        }
        catch (ReflectiveOperationException e) {
            Log.e((String)TAG, (String)(this.adapterClass + " must have a constructor that accepts " + this.oemFactoryClass));
        }
        return adapter;
    }

    @Override
    public int compareTo(OemApi o) {
        return o.version - this.version;
    }

    private static Class<?> loadClass(@Nullable String className) {
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

