/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.pluginsupport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import com.android.car.ui.plugin.oemapis.PluginVersionProviderOEMV1;
import com.android.car.ui.pluginsupport.OemApi;
import com.android.car.ui.pluginsupport.PluginFactory;
import com.android.car.ui.pluginsupport.PluginFactoryAdapterV1;
import com.android.car.ui.pluginsupport.PluginFactoryAdapterV2;
import com.android.car.ui.pluginsupport.PluginFactoryAdapterV3;
import com.android.car.ui.pluginsupport.PluginFactoryAdapterV4;
import com.android.car.ui.pluginsupport.PluginFactoryAdapterV5;
import com.android.car.ui.pluginsupport.PluginFactoryAdapterV6;
import com.android.car.ui.pluginsupport.PluginFactoryAdapterV7;
import com.android.car.ui.pluginsupport.PluginFactoryAdapterV8;
import com.android.car.ui.pluginsupport.PluginFactoryAdapterV9;
import com.android.car.ui.pluginsupport.PluginVersionProviderAdapterV1;
import java.util.SortedSet;
import java.util.TreeSet;

final class OemApiUtil {
    private static final String TAG = "carui";

    @SuppressLint(value={"PrivateApi"})
    static PluginFactory getPluginFactory(Context pluginContext, String appPackageName) {
        Object oemVersionProvider = null;
        try {
            oemVersionProvider = Class.forName("com.android.car.ui.plugin.PluginVersionProviderImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Log.i((String)TAG, (String)"PluginVersionProviderImpl not found.", (Throwable)e);
        }
        catch (ReflectiveOperationException e) {
            Log.e((String)TAG, (String)"PluginVersionProviderImpl could not be instantiated!", (Throwable)(e.getCause() == null ? e : e.getCause()));
        }
        PluginVersionProviderAdapterV1 versionProvider = null;
        if (oemVersionProvider instanceof PluginVersionProviderOEMV1) {
            versionProvider = new PluginVersionProviderAdapterV1(oemVersionProvider);
        } else {
            Log.e((String)TAG, (String)"PluginVersionProviderImpl was not instanceof any known versions of PluginVersionProviderOEMV#.");
        }
        PluginFactory oemPluginFactory = null;
        if (versionProvider != null) {
            SortedSet<OemApi> oemApis = OemApiUtil.getAvailableOemApis();
            int maxSupportedVersion = ((OemApi)oemApis.stream().findFirst().get()).version;
            Object factory = versionProvider.getPluginFactory(maxSupportedVersion, pluginContext, appPackageName);
            for (OemApi oemApi : oemApis) {
                if (oemApi.oemFactoryClass == null || !oemApi.oemFactoryClass.isInstance(factory)) continue;
                oemPluginFactory = oemApi.getAdapter(factory);
                break;
            }
            if (oemPluginFactory == null) {
                Log.e((String)TAG, (String)"PluginVersionProvider found, but did not provide a factory implementing any known interfaces!");
            }
        }
        return oemPluginFactory;
    }

    private OemApiUtil() {
    }

    private static SortedSet<OemApi> getAvailableOemApis() {
        TreeSet<OemApi> oemApis = new TreeSet<OemApi>();
        oemApis.add(new OemApi("com.android.car.ui.plugin.oemapis.PluginFactoryOEMV1", PluginFactoryAdapterV1.class, 1));
        oemApis.add(new OemApi("com.android.car.ui.plugin.oemapis.PluginFactoryOEMV2", PluginFactoryAdapterV2.class, 2));
        oemApis.add(new OemApi("com.android.car.ui.plugin.oemapis.PluginFactoryOEMV3", PluginFactoryAdapterV3.class, 3));
        oemApis.add(new OemApi("com.android.car.ui.plugin.oemapis.PluginFactoryOEMV4", PluginFactoryAdapterV4.class, 4));
        oemApis.add(new OemApi("com.android.car.ui.plugin.oemapis.PluginFactoryOEMV5", PluginFactoryAdapterV5.class, 5));
        oemApis.add(new OemApi("com.android.car.ui.plugin.oemapis.PluginFactoryOEMV6", PluginFactoryAdapterV6.class, 6));
        oemApis.add(new OemApi("com.android.car.ui.plugin.oemapis.PluginFactoryOEMV7", PluginFactoryAdapterV7.class, 7));
        oemApis.add(new OemApi("com.android.car.ui.plugin.oemapis.PluginFactoryOEMV8", PluginFactoryAdapterV8.class, 8));
        oemApis.add(new OemApi("com.android.car.ui.plugin.oemapis.PluginFactoryOEMV9", PluginFactoryAdapterV9.class, 9));
        return oemApis;
    }
}

