/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.pluginsupport;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.FocusArea;
import com.android.car.ui.FocusAreaAdapterV1;
import com.android.car.ui.FocusParkingView;
import com.android.car.ui.FocusParkingViewAdapterV1;
import com.android.car.ui.appstyledview.AppStyledViewController;
import com.android.car.ui.appstyledview.AppStyledViewControllerAdapterV1;
import com.android.car.ui.appstyledview.AppStyledViewControllerImpl;
import com.android.car.ui.baselayout.Insets;
import com.android.car.ui.baselayout.InsetsChangedListener;
import com.android.car.ui.plugin.oemapis.InsetsOEMV1;
import com.android.car.ui.plugin.oemapis.PluginFactoryOEMV1;
import com.android.car.ui.plugin.oemapis.appstyledview.AppStyledViewControllerOEMV1;
import com.android.car.ui.plugin.oemapis.toolbar.ToolbarControllerOEMV1;
import com.android.car.ui.pluginsupport.PluginFactory;
import com.android.car.ui.pluginsupport.PluginFactoryStub;
import com.android.car.ui.recyclerview.CarUiListItem;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.toolbar.ToolbarController;
import com.android.car.ui.toolbar.ToolbarControllerAdapterV1;
import com.android.car.ui.widget.CarUiTextView;
import java.util.List;

public final class PluginFactoryAdapterV1
implements PluginFactory {
    @NonNull
    private final PluginFactoryOEMV1 mOem;
    @NonNull
    private final PluginFactoryStub mFactoryStub = new PluginFactoryStub();

    public PluginFactoryAdapterV1(@NonNull PluginFactoryOEMV1 oem) {
        this.mOem = oem;
        this.mOem.setRotaryFactories(c -> new FocusParkingViewAdapterV1(new FocusParkingView((Context)c)), c -> new FocusAreaAdapterV1(new FocusArea((Context)c)));
    }

    @Override
    @Nullable
    public ToolbarController installBaseLayoutAround(@NonNull Context context, @NonNull View contentView, @Nullable InsetsChangedListener insetsChangedListener, boolean toolbarEnabled, boolean fullscreen) {
        if (!this.mOem.customizesBaseLayout()) {
            return this.mFactoryStub.installBaseLayoutAround(context, contentView, insetsChangedListener, toolbarEnabled, fullscreen);
        }
        ToolbarControllerOEMV1 toolbar = this.mOem.installBaseLayoutAround(context, contentView, insetsChangedListener == null ? null : insets -> insetsChangedListener.onCarUiInsetsChanged(this.adaptInsets((InsetsOEMV1)insets)), toolbarEnabled, fullscreen);
        if (toolbar != null) {
            return new ToolbarControllerAdapterV1(context, toolbar);
        }
        if (toolbarEnabled) {
            return this.mFactoryStub.installBaseLayoutAround(context, contentView, insetsChangedListener, toolbarEnabled, fullscreen);
        }
        return null;
    }

    @Override
    @NonNull
    public CarUiTextView createTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        return this.mFactoryStub.createTextView(context, attrs);
    }

    @Override
    @NonNull
    public View createCarUiPreferenceView(@NonNull Context context, @NonNull AttributeSet attrs) {
        return this.mFactoryStub.createCarUiPreferenceView(context, attrs);
    }

    @Override
    @NonNull
    public AppStyledViewController createAppStyledView(@NonNull Context activityContext) {
        AppStyledViewControllerOEMV1 appStyledViewControllerOEMV1 = this.mOem.createAppStyledView(activityContext);
        return appStyledViewControllerOEMV1 == null ? new AppStyledViewControllerImpl(activityContext) : new AppStyledViewControllerAdapterV1(activityContext, appStyledViewControllerOEMV1);
    }

    private Insets adaptInsets(InsetsOEMV1 insetsOEM) {
        return new Insets(insetsOEM.getLeft(), insetsOEM.getTop(), insetsOEM.getRight(), insetsOEM.getBottom());
    }

    @Override
    @NonNull
    public CarUiRecyclerView createRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        return this.mFactoryStub.createRecyclerView(context, attrs);
    }

    @Override
    @NonNull
    public RecyclerView.Adapter<? extends RecyclerView.ViewHolder> createListItemAdapter(@NonNull List<? extends CarUiListItem> items) {
        return this.mFactoryStub.createListItemAdapter((List)items);
    }
}

