/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.pluginsupport;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.CarUiText;
import com.android.car.ui.FocusArea;
import com.android.car.ui.FocusAreaAdapterV1;
import com.android.car.ui.FocusParkingView;
import com.android.car.ui.FocusParkingViewAdapterV1;
import com.android.car.ui.R;
import com.android.car.ui.appstyledview.AppStyledViewController;
import com.android.car.ui.appstyledview.AppStyledViewControllerAdapterV4;
import com.android.car.ui.appstyledview.AppStyledViewControllerImpl;
import com.android.car.ui.baselayout.Insets;
import com.android.car.ui.baselayout.InsetsChangedListener;
import com.android.car.ui.plugin.oemapis.Consumer;
import com.android.car.ui.plugin.oemapis.FocusAreaOEMV1;
import com.android.car.ui.plugin.oemapis.FocusParkingViewOEMV1;
import com.android.car.ui.plugin.oemapis.Function;
import com.android.car.ui.plugin.oemapis.InsetsOEMV1;
import com.android.car.ui.plugin.oemapis.PluginFactoryOEMV9;
import com.android.car.ui.plugin.oemapis.TextOEMV1;
import com.android.car.ui.plugin.oemapis.appstyledview.AppStyledViewControllerOEMV4;
import com.android.car.ui.plugin.oemapis.preference.PreferenceOEMV1;
import com.android.car.ui.plugin.oemapis.preference.PreferenceViewAttributesOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.AdapterOEMV2;
import com.android.car.ui.plugin.oemapis.recyclerview.ContentListItemOEMV2;
import com.android.car.ui.plugin.oemapis.recyclerview.HeaderListItemOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.LayoutStyleOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.ListItemOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.RecyclerViewAttributesOEMV1;
import com.android.car.ui.plugin.oemapis.recyclerview.RecyclerViewOEMV3;
import com.android.car.ui.plugin.oemapis.toolbar.ToolbarControllerOEMV3;
import com.android.car.ui.pluginsupport.PluginFactory;
import com.android.car.ui.pluginsupport.PluginFactoryStub;
import com.android.car.ui.recyclerview.CarUiContentListItem;
import com.android.car.ui.recyclerview.CarUiHeaderListItem;
import com.android.car.ui.recyclerview.CarUiListItem;
import com.android.car.ui.recyclerview.CarUiListItemAdapterAdapterV2;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.recyclerview.RecyclerViewAdapterV3;
import com.android.car.ui.toolbar.ToolbarController;
import com.android.car.ui.toolbar.ToolbarControllerAdapterV3;
import com.android.car.ui.utils.CarUiUtils;
import com.android.car.ui.widget.CarUiTextView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PluginFactoryAdapterV9
implements PluginFactory {
    @NonNull
    private final PluginFactoryOEMV9 mOem;
    @NonNull
    private final PluginFactoryStub mFactoryStub = new PluginFactoryStub();

    public PluginFactoryAdapterV9(@NonNull PluginFactoryOEMV9 oem) {
        this.mOem = oem;
        this.mOem.setRotaryFactories((Function)new Function<Context, FocusParkingViewOEMV1>(){

            public FocusParkingViewOEMV1 apply(Context context) {
                return new FocusParkingViewAdapterV1(new FocusParkingView(context));
            }
        }, (Function)new Function<Context, FocusAreaOEMV1>(){

            public FocusAreaOEMV1 apply(Context context) {
                return new FocusAreaAdapterV1(new FocusArea(context));
            }
        });
    }

    @Override
    @Nullable
    public ToolbarController installBaseLayoutAround(@NonNull Context context, @NonNull View contentView, final @Nullable InsetsChangedListener insetsChangedListener, boolean toolbarEnabled, boolean fullscreen) {
        if (!this.mOem.customizesBaseLayout()) {
            return this.mFactoryStub.installBaseLayoutAround(context, contentView, insetsChangedListener, toolbarEnabled, fullscreen);
        }
        ToolbarControllerOEMV3 toolbar = this.mOem.installBaseLayoutAround(context, contentView, (Consumer)new Consumer<InsetsOEMV1>(){

            public void accept(@NonNull InsetsOEMV1 insets) {
                if (insetsChangedListener != null) {
                    insetsChangedListener.onCarUiInsetsChanged(PluginFactoryAdapterV9.this.adaptInsets(insets));
                }
            }
        }, toolbarEnabled, fullscreen);
        if (toolbar != null) {
            return new ToolbarControllerAdapterV3(context, toolbar);
        }
        if (toolbarEnabled) {
            return this.mFactoryStub.installBaseLayoutAround(context, contentView, insetsChangedListener, toolbarEnabled, fullscreen);
        }
        return null;
    }

    @Override
    @NonNull
    public CarUiTextView createTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        return this.mFactoryStub.createTextView(context, attrs);
    }

    @Override
    @NonNull
    public View createCarUiPreferenceView(@NonNull Context context, @NonNull AttributeSet attrs) {
        PreferenceOEMV1 preferenceOEMV1 = this.mOem.createCarUiPreference(context);
        if (preferenceOEMV1 == null) {
            return this.mFactoryStub.createCarUiPreferenceView(context, attrs);
        }
        try {
            final int preferenceType = this.getPreferenceType(context, attrs);
            return preferenceOEMV1.createCarUiPreferenceView(new PreferenceViewAttributesOEMV1(){

                public int getPreferenceType() {
                    return preferenceType;
                }
            });
        }
        catch (Exception ex) {
            return this.mFactoryStub.createCarUiPreferenceView(context, attrs);
        }
    }

    int getPreferenceType(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Preference, 0, 0);
        int preferenceType = a.getInt(R.styleable.Preference_carUiPreferenceType, 0);
        a.recycle();
        return preferenceType;
    }

    @Override
    @Nullable
    public AppStyledViewController createAppStyledView(@NonNull Context activityContext) {
        AppStyledViewControllerOEMV4 appStyledViewControllerOEMV4 = this.mOem.createAppStyledView(activityContext);
        return appStyledViewControllerOEMV4 == null ? new AppStyledViewControllerImpl(activityContext) : new AppStyledViewControllerAdapterV4(activityContext, appStyledViewControllerOEMV4);
    }

    private Insets adaptInsets(InsetsOEMV1 insetsOEM) {
        return new Insets(insetsOEM.getLeft(), insetsOEM.getTop(), insetsOEM.getRight(), insetsOEM.getBottom());
    }

    @Override
    @NonNull
    public CarUiRecyclerView createRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        RecyclerViewAttributesOEMV1 oemAttrs = PluginFactoryAdapterV9.from(context, attrs);
        RecyclerViewOEMV3 oemRecyclerView = this.mOem.createRecyclerView(context, oemAttrs);
        if (oemRecyclerView != null) {
            RecyclerViewAdapterV3 rv = new RecyclerViewAdapterV3(context, attrs, 0);
            rv.setOemRecyclerView(oemRecyclerView, oemAttrs);
            return rv;
        }
        return this.mFactoryStub.createRecyclerView(context, attrs);
    }

    @Override
    @NonNull
    public RecyclerView.Adapter<? extends RecyclerView.ViewHolder> createListItemAdapter(final @NonNull List<? extends CarUiListItem> items) {
        final List<ListItemOEMV1> oemItems = CarUiUtils.convertList(items, PluginFactoryAdapterV9::toOemListItem);
        final AdapterOEMV2 oemAdapter = this.mOem.createListItemAdapter(oemItems);
        if (oemAdapter == null) {
            return this.mFactoryStub.createListItemAdapter((List)items);
        }
        final CarUiListItemAdapterAdapterV2 adapter = new CarUiListItemAdapterAdapterV2(oemAdapter);
        adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                oemItems.clear();
                oemItems.addAll(CarUiUtils.convertList(items, x$0 -> PluginFactoryAdapterV9.toOemListItem(x$0)));
                oemAdapter.notifyDataSetChanged();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                for (int i = positionStart; i <= positionStart + itemCount; ++i) {
                    oemItems.set(i, PluginFactoryAdapterV9.toOemListItem((CarUiListItem)items.get(i)));
                }
                oemAdapter.notifyItemRangeChanged(positionStart, itemCount);
            }

            public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
                for (int i = positionStart; i <= positionStart + itemCount; ++i) {
                    oemItems.set(i, PluginFactoryAdapterV9.toOemListItem((CarUiListItem)items.get(i)));
                }
                oemAdapter.notifyItemRangeChanged(positionStart, itemCount, payload);
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                for (int i = positionStart; i <= positionStart + itemCount; ++i) {
                    oemItems.add(i, PluginFactoryAdapterV9.toOemListItem((CarUiListItem)items.get(i)));
                }
                oemAdapter.notifyItemRangeInserted(positionStart, itemCount);
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                for (int i = positionStart; i <= positionStart + itemCount; ++i) {
                    oemItems.remove(i);
                }
                oemAdapter.notifyItemRangeRemoved(positionStart, itemCount);
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                for (int i = fromPosition; i <= fromPosition + itemCount; ++i) {
                    ListItemOEMV1 item = (ListItemOEMV1)oemItems.remove(i);
                    oemItems.add(toPosition, item);
                    oemAdapter.notifyItemMoved(fromPosition, ++toPosition);
                }
            }

            public void onStateRestorationPolicyChanged() {
                oemAdapter.setStateRestorationPolicy(adapter.getStateRestorationPolicy().ordinal());
            }
        });
        return adapter;
    }

    private static RecyclerViewAttributesOEMV1 from(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CarUiRecyclerView, 0, 0);
        final int carUiRecyclerViewLayout = a.getInt(R.styleable.CarUiRecyclerView_layoutStyle, 0);
        final int spanCount = a.getInt(R.styleable.CarUiRecyclerView_numOfColumns, 1);
        final boolean rotaryScrollEnabled = a.getBoolean(R.styleable.CarUiRecyclerView_rotaryScrollEnabled, false);
        final int orientation = a.getInt(R.styleable.CarUiRecyclerView_android_orientation, 1);
        final boolean reversed = a.getBoolean(R.styleable.CarUiRecyclerView_reverseLayout, false);
        final int size = a.getInt(R.styleable.CarUiRecyclerView_carUiSize, 2);
        a.recycle();
        int[] attrsArray = new int[]{16842996, 16842997, 16843071, 0x1010140, 16843699, 16842966, 16843700, 16842968, 16842967, 16842969, 16843701, 16842999, 16843702, 16843001, 16843000, 16843002, 16842964};
        Arrays.sort(attrsArray);
        TypedArray ta = context.obtainStyledAttributes(attrs, attrsArray, 0, 0);
        final int width = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16842996), -1);
        final int height = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16842997), -2);
        final int minWidth = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16843071), 0);
        final int minHeight = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 0x1010140), 0);
        final int paddingLeft = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16842966), 0);
        final int paddingRight = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16842968), 0);
        final int paddingStart = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16843699), 0);
        final int paddingEnd = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16843700), 0);
        final int paddingTop = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16842967), 0);
        final int paddingBottom = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16842969), 0);
        final int marginLeft = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16842999), 0);
        final int marginRight = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16843001), 0);
        final int marginStart = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16843701), 0);
        final int marginEnd = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16843702), 0);
        final int marginTop = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16843000), 0);
        final int marginBottom = ta.getLayoutDimension(Arrays.binarySearch(attrsArray, 16843002), 0);
        final Drawable background = ta.getDrawable(Arrays.binarySearch(attrsArray, 16842964));
        ta.recycle();
        final LayoutStyleOEMV1 layoutStyle = new LayoutStyleOEMV1(){

            public int getSpanCount() {
                return spanCount;
            }

            public int getLayoutType() {
                switch (carUiRecyclerViewLayout) {
                    case 1: {
                        return 1;
                    }
                }
                return 0;
            }

            public int getOrientation() {
                switch (orientation) {
                    case 0: {
                        return 0;
                    }
                }
                return 1;
            }

            public boolean getReverseLayout() {
                return reversed;
            }

            public int getSpanSize(int position) {
                return 1;
            }
        };
        final boolean isLtr = context.getResources().getConfiguration().getLayoutDirection() == 0;
        return new RecyclerViewAttributesOEMV1(){

            public boolean isRotaryScrollEnabled() {
                return rotaryScrollEnabled;
            }

            public int getSize() {
                switch (size) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                }
                return 2;
            }

            public LayoutStyleOEMV1 getLayoutStyle() {
                return layoutStyle;
            }

            public int getLayoutWidth() {
                return width;
            }

            public int getLayoutHeight() {
                return height;
            }

            public int geMinWidth() {
                return minWidth;
            }

            public int getMinHeight() {
                return minHeight;
            }

            public int getPaddingLeft() {
                if (paddingLeft != 0) {
                    return paddingLeft;
                }
                if (isLtr) {
                    return paddingStart;
                }
                return paddingEnd;
            }

            public int getPaddingRight() {
                if (paddingRight != 0) {
                    return paddingRight;
                }
                if (isLtr) {
                    return paddingEnd;
                }
                return paddingStart;
            }

            public int getPaddingTop() {
                return paddingTop;
            }

            public int getPaddingBottom() {
                return paddingBottom;
            }

            public int getMarginLeft() {
                if (marginLeft != 0) {
                    return marginLeft;
                }
                if (isLtr) {
                    return marginStart;
                }
                return marginEnd;
            }

            public int getMarginRight() {
                if (marginRight != 0) {
                    return marginRight;
                }
                if (isLtr) {
                    return marginEnd;
                }
                return marginStart;
            }

            public int getMarginTop() {
                return marginTop;
            }

            public int getMarginBottom() {
                return marginBottom;
            }

            public Drawable getBackground() {
                return background;
            }
        };
    }

    private static ListItemOEMV1 toOemListItem(CarUiListItem item) {
        if (item instanceof CarUiHeaderListItem) {
            CarUiHeaderListItem header = (CarUiHeaderListItem)item;
            return new HeaderListItemOEMV1.Builder(new SpannableString(header.getTitle())).setBody(new SpannableString(header.getBody())).build();
        }
        if (item instanceof CarUiContentListItem) {
            Consumer listener;
            CarUiContentListItem contentItem = (CarUiContentListItem)item;
            ContentListItemOEMV2.Builder builder = new ContentListItemOEMV2.Builder(PluginFactoryAdapterV9.toOemListItemAction(contentItem.getAction()));
            if (contentItem.getTitle() != null) {
                builder.setTitle(PluginFactoryAdapterV9.toOemText(contentItem.getTitle()));
            }
            if (contentItem.getBody() != null) {
                builder.setBody(PluginFactoryAdapterV9.toOemText(contentItem.getBody()));
            }
            builder.setIcon(contentItem.getIcon(), PluginFactoryAdapterV9.toOemListItemIconType(contentItem.getPrimaryIconType()));
            if (contentItem.getAction() == CarUiContentListItem.Action.ICON) {
                listener = contentItem.getSupplementalIconOnClickListener() != null ? oemItem -> contentItem.getSupplementalIconOnClickListener().onClick(contentItem) : null;
                builder.setSupplementalIcon(contentItem.getSupplementalIcon(), listener);
            }
            if (contentItem.getOnClickListener() != null) {
                listener = contentItem.getOnClickListener() != null ? oemItem -> contentItem.getOnClickListener().onClick(contentItem) : null;
                builder.setOnItemClickedListener(listener);
            }
            builder.setOnCheckedChangeListener(oem -> contentItem.setChecked(oem.isChecked())).setActionDividerVisible(contentItem.isActionDividerVisible()).setEnabled(contentItem.isEnabled()).setChecked(contentItem.isChecked()).setActivated(contentItem.isActivated()).setSecure(contentItem.isSecure());
            return builder.build();
        }
        throw new IllegalStateException("Unknown view type.");
    }

    private static TextOEMV1 toOemText(CarUiText text) {
        return new TextOEMV1.Builder(text.getTextVariants()).setMaxChars(text.getMaxChars()).setMaxLines(text.getMaxLines()).build();
    }

    private static List<TextOEMV1> toOemText(List<CarUiText> lines) {
        ArrayList<TextOEMV1> oemLines = new ArrayList<TextOEMV1>();
        for (CarUiText line : lines) {
            oemLines.add(new TextOEMV1.Builder(line.getTextVariants()).setMaxChars(line.getMaxChars()).setMaxLines(line.getMaxLines()).build());
        }
        return oemLines;
    }

    private static ContentListItemOEMV2.Action toOemListItemAction(CarUiContentListItem.Action action) {
        switch (action) {
            case NONE: {
                return ContentListItemOEMV2.Action.NONE;
            }
            case SWITCH: {
                return ContentListItemOEMV2.Action.SWITCH;
            }
            case CHECK_BOX: {
                return ContentListItemOEMV2.Action.CHECK_BOX;
            }
            case RADIO_BUTTON: {
                return ContentListItemOEMV2.Action.RADIO_BUTTON;
            }
            case ICON: {
                return ContentListItemOEMV2.Action.ICON;
            }
            case CHEVRON: {
                return ContentListItemOEMV2.Action.CHEVRON;
            }
        }
        throw new IllegalStateException("Unexpected list item action type");
    }

    private static ContentListItemOEMV2.IconType toOemListItemIconType(CarUiContentListItem.IconType iconType) {
        switch (iconType) {
            case CONTENT: {
                return ContentListItemOEMV2.IconType.CONTENT;
            }
            case STANDARD: {
                return ContentListItemOEMV2.IconType.STANDARD;
            }
            case AVATAR: {
                return ContentListItemOEMV2.IconType.AVATAR;
            }
        }
        throw new IllegalStateException("Unexpected list item icon type");
    }
}

