/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.pluginsupport;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.os.Build;
import android.os.Process;
import android.os.Trace;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.android.car.ui.R;
import com.android.car.ui.pluginsupport.AdapterClassLoader;
import com.android.car.ui.pluginsupport.PluginConfigProvider;
import com.android.car.ui.pluginsupport.PluginFactory;
import com.android.car.ui.pluginsupport.PluginFactoryStub;
import com.android.car.ui.pluginsupport.PluginSpecifier;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SuppressLint(value={"LogConditional"})
public final class PluginFactorySingleton {
    private static final String TAG = "carui";
    private static PluginFactory sInstance;
    private static final Object LOCK;
    private static TestingOverride sTestingOverride;
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static Context sPluginContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginFactory get(Context context) {
        try {
            Object object;
            Trace.beginSection((String)"car-ui-plugin-load");
            PluginFactory result = sInstance;
            if (result == null) {
                object = LOCK;
                synchronized (object) {
                    result = sInstance;
                    if (result == null) {
                        PluginFactorySingleton.loadPlugin(context);
                        result = sInstance;
                    }
                }
            }
            object = result;
            return object;
        }
        finally {
            Trace.endSection();
        }
    }

    @VisibleForTesting
    public static void setPluginEnabledForTesting(boolean pluginEnabled) {
        sTestingOverride = pluginEnabled ? TestingOverride.ENABLED : TestingOverride.DISABLED;
        sInstance = null;
        sPluginContext = null;
    }

    @Nullable
    @VisibleForTesting
    public static Context getPluginContext() {
        return sPluginContext;
    }

    private PluginFactorySingleton() {
    }

    @SuppressLint(value={"PrivateApi"})
    private static void loadPlugin(@NonNull Context context) {
        Set<PluginSpecifier> deniedPackages;
        PackageInfo pluginPackageInfo;
        boolean isPluginEnabled;
        if (sInstance != null) {
            return;
        }
        switch (sTestingOverride) {
            case ENABLED: {
                isPluginEnabled = true;
                break;
            }
            case DISABLED: {
                isPluginEnabled = false;
                break;
            }
            default: {
                isPluginEnabled = PluginFactorySingleton.isPluginEnabled(context);
            }
        }
        if (!isPluginEnabled) {
            Log.i((String)TAG, (String)"CarUi plugin is disabled");
            sInstance = new PluginFactoryStub();
            return;
        }
        String pluginPackageName = PluginFactorySingleton.getPluginPackageName(context);
        try {
            pluginPackageInfo = context.getPackageManager().getPackageInfo(pluginPackageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("Could not load CarUi plugin, package " + pluginPackageName + " was not found."));
            sInstance = new PluginFactoryStub();
            return;
        }
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof PluginConfigProvider && (deniedPackages = ((PluginConfigProvider)applicationContext).getPluginDenyList()) != null && deniedPackages.stream().anyMatch(specs -> specs.matches(pluginPackageInfo))) {
            Log.i((String)TAG, (String)("Package " + context.getPackageName() + " denied loading plugin " + pluginPackageName));
            sInstance = new PluginFactoryStub();
            return;
        }
        if (sPluginContext == null) {
            try {
                sPluginContext = context.createPackageContext(pluginPackageName, 3);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Could not load CarUi plugin", (Throwable)e);
                sInstance = new PluginFactoryStub();
                return;
            }
        }
        Class oemApiUtilClass = null;
        boolean loadedFromSharedLibrary = true;
        try {
            PluginFactorySingleton.class.getClassLoader().loadClass("com.android.car.ui.plugin.PluginVersionProviderImpl");
            oemApiUtilClass = PluginFactorySingleton.class.getClassLoader().loadClass("com.android.car.ui.pluginsupport.OemApiUtil");
        }
        catch (ClassNotFoundException e) {
            loadedFromSharedLibrary = false;
        }
        if (!loadedFromSharedLibrary) {
            Log.w((String)TAG, (String)"loading using adapter classloader");
            AdapterClassLoader adapterClassLoader = PluginFactorySingleton.instantiateClassLoader(context.getApplicationInfo(), Objects.requireNonNull(PluginFactorySingleton.class.getClassLoader()), sPluginContext.getClassLoader());
            try {
                oemApiUtilClass = adapterClassLoader.loadClass("com.android.car.ui.pluginsupport.OemApiUtil");
            }
            catch (ClassNotFoundException ex) {
                Log.e((String)TAG, (String)"Could not load oemApiUtilClass: ", (Throwable)ex);
                sInstance = new PluginFactoryStub();
                return;
            }
        }
        try {
            Method getPluginFactoryMethod = oemApiUtilClass.getDeclaredMethod("getPluginFactory", Context.class, String.class);
            getPluginFactoryMethod.setAccessible(true);
            sInstance = (PluginFactory)getPluginFactoryMethod.invoke(null, sPluginContext, context.getPackageName());
            if (sInstance == null) {
                Log.w((String)TAG, (String)"CarUi plugin loaded is null");
                sInstance = new PluginFactoryStub();
                return;
            }
        }
        catch (ReflectiveOperationException e) {
            Log.e((String)TAG, (String)"Could not invoke getPluginFactory: ", (Throwable)e);
            sInstance = new PluginFactoryStub();
            return;
        }
        Log.i((String)TAG, (String)("Loaded plugin " + pluginPackageName + " version " + pluginPackageInfo.getLongVersionCode() + " for package " + context.getPackageName()));
    }

    private static AdapterClassLoader instantiateClassLoader(@NonNull ApplicationInfo appInfo, @NonNull ClassLoader parent, @NonNull ClassLoader sharedlibraryClassLoader) {
        ArrayList<String> libraryPaths = new ArrayList<String>(3);
        if (appInfo.nativeLibraryDir != null) {
            libraryPaths.add(appInfo.nativeLibraryDir);
        }
        if ((appInfo.flags & 0x10000000) == 0) {
            for (String abi : PluginFactorySingleton.getSupportedAbisForCurrentRuntime()) {
                libraryPaths.add(appInfo.sourceDir + "!/lib/" + abi);
            }
        }
        String flatLibraryPaths = libraryPaths.size() == 0 ? null : TextUtils.join((CharSequence)File.pathSeparator, libraryPaths);
        String apkPaths = appInfo.sourceDir;
        if (appInfo.sharedLibraryFiles != null && appInfo.sharedLibraryFiles.length > 0) {
            apkPaths = apkPaths + File.pathSeparator + TextUtils.join((CharSequence)File.pathSeparator, (Object[])appInfo.sharedLibraryFiles);
        }
        return new AdapterClassLoader(apkPaths, flatLibraryPaths, parent, sharedlibraryClassLoader);
    }

    private static List<String> getSupportedAbisForCurrentRuntime() {
        ArrayList<String> abis = new ArrayList<String>();
        if (Process.is64Bit()) {
            Collections.addAll(abis, Build.SUPPORTED_64_BIT_ABIS);
        } else {
            Collections.addAll(abis, Build.SUPPORTED_32_BIT_ABIS);
        }
        return abis;
    }

    @Nullable
    public static String getPluginPackageName(Context context) {
        PackageManager packageManager = context.getPackageManager();
        if (!packageManager.hasSystemFeature("android.hardware.type.automotive")) {
            return null;
        }
        String authority = context.getString(R.string.car_ui_plugin_package_provider_authority_name);
        ProviderInfo providerInfo = context.getPackageManager().resolveContentProvider(authority, 0x100200);
        if (providerInfo == null) {
            return null;
        }
        return providerInfo.packageName;
    }

    public static boolean isPluginEnabled(Context context) {
        PackageManager packageManager = context.getPackageManager();
        if (!packageManager.hasSystemFeature("android.hardware.type.automotive")) {
            return false;
        }
        String authority = context.getString(R.string.car_ui_plugin_package_provider_authority_name);
        ProviderInfo providerInfo = packageManager.resolveContentProvider(authority, 0x100200);
        if (providerInfo == null) {
            return false;
        }
        ComponentName componentName = new ComponentName(providerInfo.packageName, providerInfo.name);
        int state = packageManager.getComponentEnabledSetting(componentName);
        if (state == 0) {
            return providerInfo.enabled;
        }
        return state == 1;
    }

    static {
        LOCK = new Object();
        sTestingOverride = TestingOverride.NOT_SET;
        sPluginContext = null;
    }

    private static enum TestingOverride {
        NOT_SET,
        ENABLED,
        DISABLED;

    }
}

