/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.pluginsupport;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.car.ui.R;
import com.android.car.ui.appstyledview.AppStyledViewController;
import com.android.car.ui.appstyledview.AppStyledViewControllerImpl;
import com.android.car.ui.baselayout.Insets;
import com.android.car.ui.baselayout.InsetsChangedListener;
import com.android.car.ui.pluginsupport.PluginFactory;
import com.android.car.ui.preference.CarUiPreferenceViewStub;
import com.android.car.ui.recyclerview.CarUiListItem;
import com.android.car.ui.recyclerview.CarUiListItemAdapter;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.recyclerview.CarUiRecyclerViewImpl;
import com.android.car.ui.toolbar.ToolbarController;
import com.android.car.ui.toolbar.ToolbarControllerImpl;
import com.android.car.ui.utils.CarUiUtils;
import com.android.car.ui.widget.CarUiTextView;
import com.android.car.ui.widget.CarUiTextViewImpl;
import java.util.List;

public final class PluginFactoryStub
implements PluginFactory {
    @Override
    @Nullable
    public ToolbarController installBaseLayoutAround(@NonNull Context context, @NonNull View contentView, @Nullable InsetsChangedListener insetsChangedListener, boolean toolbarEnabled, boolean fullscreen) {
        boolean twoRow;
        boolean legacyToolbar;
        boolean bl = legacyToolbar = Build.VERSION.SDK_INT <= 29;
        int baseLayoutRes = toolbarEnabled ? (legacyToolbar ? ((twoRow = contentView.getResources().getBoolean(R.bool.car_ui_toolbar_tabs_on_second_row)) ? R.layout.car_ui_base_layout_toolbar_legacy_two_row : R.layout.car_ui_base_layout_toolbar_legacy) : R.layout.car_ui_base_layout_toolbar) : R.layout.car_ui_base_layout;
        View baseLayout = LayoutInflater.from((Context)context).inflate(baseLayoutRes, null, false);
        ViewGroup contentViewParent = (ViewGroup)contentView.getParent();
        int contentIndex = contentViewParent.indexOfChild(contentView);
        contentViewParent.removeView(contentView);
        contentViewParent.addView(baseLayout, contentIndex, contentView.getLayoutParams());
        FrameLayout contentViewContainer = (FrameLayout)CarUiUtils.requireViewByRefId(baseLayout, R.id.car_ui_base_layout_content_container);
        contentViewContainer.addView(contentView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        ToolbarControllerImpl toolbarController = null;
        if (toolbarEnabled) {
            toolbarController = legacyToolbar ? new ToolbarControllerImpl(context, (View)CarUiUtils.requireViewByRefId(baseLayout, R.id.car_ui_toolbar)) : new ToolbarControllerImpl(context, baseLayout);
        }
        this.handleSystemInsets(context, baseLayout);
        InsetsUpdater insetsUpdater = new InsetsUpdater(baseLayout, contentView);
        insetsUpdater.replaceInsetsChangedListenerWith(insetsChangedListener);
        return toolbarController;
    }

    private void handleSystemInsets(Context context, View baseLayout) {
        if (Build.VERSION.SDK_INT < 32) {
            return;
        }
        Context unwrappedContext = CarUiUtils.unwrapContext(context);
        if (!(unwrappedContext instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)unwrappedContext;
        Window baseLayoutWindow = activity.getWindow();
        WindowManager.LayoutParams lp = baseLayoutWindow.getAttributes();
        boolean omitDisplayCutouts = context.getResources().getBoolean(R.bool.car_ui_omit_display_cut_out_insets) && lp.layoutInDisplayCutoutMode == 3;
        int vanillaIceCreamBuildVersion = 35;
        if (omitDisplayCutouts && Build.VERSION.SDK_INT < vanillaIceCreamBuildVersion) {
            baseLayoutWindow.getDecorView().setOnApplyWindowInsetsListener((v, insets) -> v.onApplyWindowInsets(new WindowInsets.Builder(insets).setInsets(WindowInsets.Type.displayCutout(), android.graphics.Insets.NONE).build()));
            return;
        }
        if (Build.VERSION.SDK_INT >= vanillaIceCreamBuildVersion) {
            baseLayout.setOnApplyWindowInsetsListener((v, insets) -> {
                int insetTypeMask = WindowInsets.Type.systemBars();
                if (!omitDisplayCutouts) {
                    insetTypeMask |= WindowInsets.Type.displayCutout();
                }
                android.graphics.Insets newInsets = insets.getInsets(insetTypeMask);
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
                mlp.topMargin = newInsets.top;
                mlp.leftMargin = newInsets.left;
                mlp.bottomMargin = newInsets.bottom;
                mlp.rightMargin = newInsets.right;
                v.setLayoutParams((ViewGroup.LayoutParams)mlp);
                return v.onApplyWindowInsets(new WindowInsets.Builder(insets).setInsets(insetTypeMask, android.graphics.Insets.NONE).build());
            });
        }
    }

    @Override
    @NonNull
    public CarUiTextView createTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        return new CarUiTextViewImpl(context, attrs);
    }

    @Override
    @NonNull
    public View createCarUiPreferenceView(@NonNull Context sourceContext, @NonNull AttributeSet attrs) {
        return CarUiPreferenceViewStub.createCarUiPreferenceView(sourceContext, attrs);
    }

    @Override
    @NonNull
    public AppStyledViewController createAppStyledView(@NonNull Context activityContext) {
        return new AppStyledViewControllerImpl(activityContext);
    }

    @Override
    @NonNull
    public CarUiRecyclerView createRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        return new CarUiRecyclerViewImpl(context, attrs);
    }

    @NonNull
    public CarUiListItemAdapter createListItemAdapter(@NonNull List<? extends CarUiListItem> items) {
        return new CarUiListItemAdapter(items);
    }

    static final class InsetsUpdater {
        private static final String LEFT_INSET_TAG = "car_ui_left_inset";
        private static final String RIGHT_INSET_TAG = "car_ui_right_inset";
        private static final String TOP_INSET_TAG = "car_ui_top_inset";
        private static final String BOTTOM_INSET_TAG = "car_ui_bottom_inset";
        private final View mContentView;
        private final View mContentViewContainer;
        private final View mLeftInsetView;
        private final View mRightInsetView;
        private final View mTopInsetView;
        private final View mBottomInsetView;
        private InsetsChangedListener mInsetsChangedListenerDelegate;
        @NonNull
        private Insets mInsets = new Insets();

        InsetsUpdater(@NonNull View baseLayout, @NonNull View contentView) {
            this.mContentView = contentView;
            this.mContentViewContainer = CarUiUtils.requireViewByRefId(baseLayout, R.id.car_ui_base_layout_content_container);
            this.mLeftInsetView = baseLayout.findViewWithTag((Object)LEFT_INSET_TAG);
            this.mRightInsetView = baseLayout.findViewWithTag((Object)RIGHT_INSET_TAG);
            this.mTopInsetView = baseLayout.findViewWithTag((Object)TOP_INSET_TAG);
            this.mBottomInsetView = baseLayout.findViewWithTag((Object)BOTTOM_INSET_TAG);
            View.OnLayoutChangeListener layoutChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
                if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
                    this.recalcInsets();
                }
            };
            if (this.mLeftInsetView != null) {
                this.mLeftInsetView.addOnLayoutChangeListener(layoutChangeListener);
            }
            if (this.mRightInsetView != null) {
                this.mRightInsetView.addOnLayoutChangeListener(layoutChangeListener);
            }
            if (this.mTopInsetView != null) {
                this.mTopInsetView.addOnLayoutChangeListener(layoutChangeListener);
            }
            if (this.mBottomInsetView != null) {
                this.mBottomInsetView.addOnLayoutChangeListener(layoutChangeListener);
            }
            contentView.addOnLayoutChangeListener(layoutChangeListener);
            this.mContentViewContainer.addOnLayoutChangeListener(layoutChangeListener);
        }

        void replaceInsetsChangedListenerWith(InsetsChangedListener listener) {
            this.mInsetsChangedListenerDelegate = listener;
        }

        private void recalcInsets() {
            Insets insets;
            int top = Math.max(0, InsetsUpdater.getTopOfView(this.mContentViewContainer) - InsetsUpdater.getTopOfView(this.mContentView));
            int left = Math.max(0, InsetsUpdater.getLeftOfView(this.mContentViewContainer) - InsetsUpdater.getLeftOfView(this.mContentView));
            int right = Math.max(0, InsetsUpdater.getRightOfView(this.mContentView) - InsetsUpdater.getRightOfView(this.mContentViewContainer));
            int bottom = Math.max(0, InsetsUpdater.getBottomOfView(this.mContentView) - InsetsUpdater.getBottomOfView(this.mContentViewContainer));
            if (this.mTopInsetView != null) {
                top += Math.max(0, InsetsUpdater.getBottomOfView(this.mTopInsetView) - InsetsUpdater.getTopOfView(this.mContentViewContainer));
            }
            if (this.mBottomInsetView != null) {
                bottom += Math.max(0, InsetsUpdater.getBottomOfView(this.mContentViewContainer) - InsetsUpdater.getTopOfView(this.mBottomInsetView));
            }
            if (this.mLeftInsetView != null) {
                left += Math.max(0, InsetsUpdater.getRightOfView(this.mLeftInsetView) - InsetsUpdater.getLeftOfView(this.mContentViewContainer));
            }
            if (this.mRightInsetView != null) {
                right += Math.max(0, InsetsUpdater.getRightOfView(this.mContentViewContainer) - InsetsUpdater.getLeftOfView(this.mRightInsetView));
            }
            if (!(insets = new Insets(left, top, right, bottom)).equals(this.mInsets)) {
                this.mInsets = insets;
                this.dispatchNewInsets(insets);
            }
        }

        void dispatchNewInsets(Insets insets) {
            this.mInsets = insets;
            if (this.mInsetsChangedListenerDelegate != null) {
                this.mInsetsChangedListenerDelegate.onCarUiInsetsChanged(insets);
            } else {
                this.mContentView.setPadding(insets.getLeft(), insets.getTop(), insets.getRight(), insets.getBottom());
            }
        }

        private static int getLeftOfView(View v) {
            int[] position = new int[2];
            v.getLocationOnScreen(position);
            return position[0];
        }

        private static int getRightOfView(View v) {
            int[] position = new int[2];
            v.getLocationOnScreen(position);
            return position[0] + v.getWidth();
        }

        private static int getTopOfView(View v) {
            int[] position = new int[2];
            v.getLocationOnScreen(position);
            return position[1];
        }

        private static int getBottomOfView(View v) {
            int[] position = new int[2];
            v.getLocationOnScreen(position);
            return position[1] + v.getHeight();
        }
    }
}

