/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.pluginsupport;

import android.content.pm.PackageInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public final class PluginSpecifier {
    @Nullable
    private final String mPackageName;
    @Nullable
    private final Long mMaxVersion;

    private PluginSpecifier(Builder builder) {
        this.mPackageName = builder.mPackageName;
        this.mMaxVersion = builder.mMaxVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    boolean matches(@NonNull PackageInfo packageInfo) {
        boolean nameMatches = this.mPackageName == null || this.mPackageName.equals(packageInfo.packageName);
        boolean versionMatches = this.mMaxVersion == null || this.mMaxVersion >= packageInfo.getLongVersionCode();
        return nameMatches && versionMatches;
    }

    public static class Builder {
        @Nullable
        private String mPackageName;
        @Nullable
        private Long mMaxVersion;

        private Builder() {
        }

        public Builder setPackageName(String packageName) {
            this.mPackageName = packageName;
            return this;
        }

        public Builder setMaxVersion(long maxVersion) {
            this.mMaxVersion = maxVersion;
            return this;
        }

        public PluginSpecifier build() {
            return new PluginSpecifier(this);
        }
    }
}

