/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.android.car.ui.utils.CarUiUtils;

public abstract class CarUiDialogFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    private static final String SAVE_STATE_TITLE = "CarUiDialogFragment.title";
    private static final String SAVE_STATE_POSITIVE_TEXT = "CarUiDialogFragment.positiveText";
    private static final String SAVE_STATE_NEGATIVE_TEXT = "CarUiDialogFragment.negativeText";
    private static final String SAVE_STATE_MESSAGE = "CarUiDialogFragment.message";
    private static final String SAVE_STATE_LAYOUT = "CarUiDialogFragment.layout";
    private static final String SAVE_STATE_ICON = "CarUiDialogFragment.icon";
    protected CharSequence mDialogTitle;
    protected CharSequence mPositiveButtonText;
    protected CharSequence mNegativeButtonText;
    protected CharSequence mDialogMessage;
    @LayoutRes
    protected int mDialogLayoutRes;
    protected BitmapDrawable mDialogIcon;
    private int mWhichButtonClicked;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mDialogTitle = savedInstanceState.getCharSequence(SAVE_STATE_TITLE);
            this.mPositiveButtonText = savedInstanceState.getCharSequence(SAVE_STATE_POSITIVE_TEXT);
            this.mNegativeButtonText = savedInstanceState.getCharSequence(SAVE_STATE_NEGATIVE_TEXT);
            this.mDialogMessage = savedInstanceState.getCharSequence(SAVE_STATE_MESSAGE);
            this.mDialogLayoutRes = savedInstanceState.getInt(SAVE_STATE_LAYOUT, 0);
            Bitmap bitmap = (Bitmap)savedInstanceState.getParcelable(SAVE_STATE_ICON);
            if (bitmap != null) {
                this.mDialogIcon = new BitmapDrawable(this.getResources(), bitmap);
            }
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putCharSequence(SAVE_STATE_TITLE, this.mDialogTitle);
        outState.putCharSequence(SAVE_STATE_POSITIVE_TEXT, this.mPositiveButtonText);
        outState.putCharSequence(SAVE_STATE_NEGATIVE_TEXT, this.mNegativeButtonText);
        outState.putCharSequence(SAVE_STATE_MESSAGE, this.mDialogMessage);
        outState.putInt(SAVE_STATE_LAYOUT, this.mDialogLayoutRes);
        if (this.mDialogIcon != null) {
            outState.putParcelable(SAVE_STATE_ICON, (Parcelable)this.mDialogIcon.getBitmap());
        }
    }

    @NonNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        FragmentActivity context = this.getActivity();
        this.mWhichButtonClicked = -2;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context).setTitle(this.mDialogTitle).setIcon((Drawable)this.mDialogIcon).setPositiveButton(this.mPositiveButtonText, (DialogInterface.OnClickListener)this).setNegativeButton(this.mNegativeButtonText, (DialogInterface.OnClickListener)this);
        View contentView = this.onCreateDialogView((Context)context);
        if (contentView != null) {
            this.onBindDialogView(contentView);
            builder.setView(contentView);
        } else {
            builder.setMessage(this.mDialogMessage);
        }
        this.onPrepareDialogBuilder(builder);
        AlertDialog dialog = builder.create();
        if (this.needInputMethod()) {
            dialog.setOnShowListener(arg_0 -> this.lambda$onCreateDialog$0((Dialog)dialog, arg_0));
        }
        return dialog;
    }

    protected void onPrepareDialogBuilder(@NonNull AlertDialog.Builder builder) {
    }

    protected boolean needInputMethod() {
        return false;
    }

    private void requestInputMethod(Dialog dialog) {
        Window window = dialog.getWindow();
        window.setSoftInputMode(5);
    }

    protected View onCreateDialogView(Context context) {
        int resId = this.mDialogLayoutRes;
        if (resId == 0) {
            return null;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        return inflater.inflate(resId, null);
    }

    @CallSuper
    protected void onBindDialogView(@NonNull View view) {
        Object dialogMessageView = CarUiUtils.findViewByRefId(view, 16908299);
        if (dialogMessageView != null) {
            CharSequence message = this.mDialogMessage;
            int newVisibility = 8;
            if (!TextUtils.isEmpty((CharSequence)message)) {
                if (dialogMessageView instanceof TextView) {
                    ((TextView)dialogMessageView).setText(message);
                }
                newVisibility = 0;
            }
            if (dialogMessageView.getVisibility() != newVisibility) {
                dialogMessageView.setVisibility(newVisibility);
            }
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        this.mWhichButtonClicked = which;
    }

    public void onDismiss(@NonNull DialogInterface dialog) {
        super.onDismiss(dialog);
        this.onDialogClosed(this.mWhichButtonClicked == -1);
    }

    protected abstract void onDialogClosed(boolean var1);

    private /* synthetic */ void lambda$onCreateDialog$0(Dialog dialog, DialogInterface d) {
        this.requestInputMethod(dialog);
    }
}

