/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.preference.DropDownPreference;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import com.android.car.ui.R;
import com.android.car.ui.preference.UxRestrictablePreference;
import com.android.car.ui.utils.CarUiUtils;
import java.util.function.Consumer;

public class CarUiDropDownPreference
extends DropDownPreference
implements UxRestrictablePreference {
    private Consumer<Preference> mRestrictedClickListener;
    private boolean mUxRestricted = false;

    public CarUiDropDownPreference(Context context) {
        super(context);
    }

    public CarUiDropDownPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CarUiDropDownPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public CarUiDropDownPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onClick() {
        this.getPreferenceManager().showDialog((Preference)this);
    }

    public void onAttached() {
        super.onAttached();
        boolean showChevron = this.getContext().getResources().getBoolean(R.bool.car_ui_preference_show_chevron);
        if (!showChevron) {
            return;
        }
        this.setWidgetLayoutResource(R.layout.car_ui_preference_chevron);
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        CarUiUtils.makeAllViewsUxRestricted(holder.itemView, this.isUxRestricted());
    }

    public void performClick() {
        if ((this.isEnabled() || this.isSelectable()) && this.isUxRestricted()) {
            if (this.mRestrictedClickListener != null) {
                this.mRestrictedClickListener.accept((Preference)this);
            }
        } else {
            super.performClick();
        }
    }

    @Override
    public void setUxRestricted(boolean restricted) {
        if (restricted != this.mUxRestricted) {
            this.mUxRestricted = restricted;
            this.notifyChanged();
        }
    }

    @Override
    public boolean isUxRestricted() {
        return this.mUxRestricted;
    }

    @Override
    public void setOnClickWhileRestrictedListener(@Nullable Consumer<Preference> listener) {
        this.mRestrictedClickListener = listener;
    }

    @Override
    @Nullable
    public Consumer<Preference> getOnClickWhileRestrictedListener() {
        return this.mRestrictedClickListener;
    }
}

