/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.preference.EditTextPreference;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import androidx.preference.R;
import com.android.car.ui.R;
import com.android.car.ui.preference.UxRestrictablePreference;
import com.android.car.ui.utils.CarUiUtils;
import java.util.function.Consumer;

public class CarUiEditTextPreference
extends EditTextPreference
implements UxRestrictablePreference {
    private Consumer<Preference> mRestrictedClickListener;
    private boolean mUxRestricted;
    private boolean mShowChevron;

    public CarUiEditTextPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    public CarUiEditTextPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CarUiEditTextPreference(Context context, AttributeSet attrs) {
        this(context, attrs, CarUiUtils.getAttr(context, R.attr.editTextPreferenceStyle, 16842898));
    }

    public CarUiEditTextPreference(Context context) {
        this(context, null);
    }

    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CarUiPreference, defStyleAttr, defStyleRes);
        this.mShowChevron = a.getBoolean(R.styleable.CarUiPreference_carUiShowChevron, true);
        this.mUxRestricted = a.getBoolean(R.styleable.CarUiPreference_car_ui_ux_restricted, false);
        a.recycle();
    }

    protected void setTwoActionLayout() {
        this.setLayoutResource(R.layout.car_ui_two_action_preference);
    }

    @VisibleForTesting(otherwise=4)
    public View getWidgetActionContainer(PreferenceViewHolder holder) {
        return CarUiUtils.findViewByRefId(holder.itemView, R.id.action_widget_container);
    }

    public void onAttached() {
        super.onAttached();
        boolean allowChevron = this.getContext().getResources().getBoolean(R.bool.car_ui_preference_show_chevron);
        if (!allowChevron || !this.mShowChevron) {
            return;
        }
        this.setWidgetLayoutResource(R.layout.car_ui_preference_chevron);
    }

    public void setShowChevron(boolean showChevron) {
        this.mShowChevron = showChevron;
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        CarUiUtils.makeAllViewsUxRestricted(holder.itemView, this.isUxRestricted());
    }

    public void performClick() {
        if ((this.isEnabled() || this.isSelectable()) && this.isUxRestricted()) {
            if (this.mRestrictedClickListener != null) {
                this.mRestrictedClickListener.accept((Preference)this);
            }
        } else {
            super.performClick();
        }
    }

    @Override
    public void setUxRestricted(boolean restricted) {
        if (restricted != this.mUxRestricted) {
            this.mUxRestricted = restricted;
            this.notifyChanged();
        }
    }

    @Override
    public boolean isUxRestricted() {
        return this.mUxRestricted;
    }

    @Override
    public void setOnClickWhileRestrictedListener(@Nullable Consumer<Preference> listener) {
        this.mRestrictedClickListener = listener;
    }

    @Override
    @Nullable
    public Consumer<Preference> getOnClickWhileRestrictedListener() {
        return this.mRestrictedClickListener;
    }
}

