/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.preference.PreferenceViewHolder;
import com.android.car.ui.R;
import com.android.car.ui.preference.CarUiPreference;
import com.android.car.ui.utils.CarUiUtils;

public class CarUiFooterPreference
extends CarUiPreference {
    private String mLinkText;
    @Nullable
    private Runnable mClickListener;

    public CarUiFooterPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setLayoutResource(R.layout.car_ui_preference_footer);
    }

    public CarUiFooterPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Preference_CarUi_Preference);
    }

    public CarUiFooterPreference(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CarUiFooterPreference(Context context) {
        this(context, null);
    }

    public void setLink(@Nullable String linkText, @Nullable Runnable clickListener) {
        if (linkText == null && clickListener != null || linkText != null && clickListener == null) {
            throw new IllegalArgumentException("Error: Both or neither argument must be null");
        }
        this.mLinkText = linkText;
        this.mClickListener = clickListener;
        this.notifyChanged();
    }

    @Nullable
    public String getLinkText() {
        return this.mLinkText;
    }

    @NonNull
    public boolean isLinkEnabled() {
        return this.mLinkText != null && this.mClickListener != null;
    }

    @Override
    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        TextView link = (TextView)CarUiUtils.findViewByRefId(holder.itemView, R.id.car_ui_link);
        if (this.isLinkEnabled()) {
            link.setText((CharSequence)this.mLinkText);
            link.setOnClickListener(v -> this.mClickListener.run());
            link.setClickable(true);
            link.setVisibility(0);
        } else {
            link.setText((CharSequence)"");
            link.setOnClickListener(null);
            link.setClickable(false);
            link.setVisibility(8);
        }
    }
}

