/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import com.android.car.ui.R;
import com.android.car.ui.preference.ClickableWhileDisabledPreference;
import com.android.car.ui.preference.DisabledPreferenceCallback;
import com.android.car.ui.utils.CarUiUtils;
import java.util.function.Consumer;

public class CarUiPreference
extends Preference
implements DisabledPreferenceCallback,
ClickableWhileDisabledPreference {
    private boolean mShowChevron;
    private Consumer<Preference> mRestrictedClickListener;
    private Consumer<Preference> mDisabledClickListener;
    private boolean mUxRestricted = false;
    private boolean mIsClickableWhileDisabled = false;

    public CarUiPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    public CarUiPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Preference_CarUi_Preference);
    }

    public CarUiPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.carUiPreferenceStyle);
    }

    public CarUiPreference(Context context) {
        this(context, null);
    }

    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CarUiPreference, defStyleAttr, defStyleRes);
        this.mShowChevron = a.getBoolean(R.styleable.CarUiPreference_carUiShowChevron, true);
        this.mUxRestricted = a.getBoolean(R.styleable.CarUiPreference_car_ui_ux_restricted, false);
        this.mIsClickableWhileDisabled = a.getBoolean(R.styleable.CarUiPreference_carUiClickableWhileDisabled, false);
        if (this.mIsClickableWhileDisabled) {
            super.setShouldDisableView(false);
        }
        a.recycle();
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        CarUiUtils.makeAllViewsEnabledAndUxRestricted(holder.itemView, this.isEnabled(), this.isUxRestricted());
    }

    public void onAttached() {
        super.onAttached();
        boolean allowChevron = this.getContext().getResources().getBoolean(R.bool.car_ui_preference_show_chevron);
        if (!allowChevron || !this.mShowChevron) {
            return;
        }
        if (this.getOnPreferenceClickListener() != null || this.getIntent() != null || this.getFragment() != null) {
            this.setWidgetLayoutResource(R.layout.car_ui_preference_chevron);
        }
    }

    void performClickUnrestricted(View v) {
        this.performClick();
    }

    public void performClick() {
        if (!this.isEnabled() && this.mIsClickableWhileDisabled) {
            if (this.mDisabledClickListener != null) {
                this.mDisabledClickListener.accept(this);
            }
        } else if ((this.isEnabled() || this.isSelectable()) && this.isUxRestricted()) {
            if (this.mRestrictedClickListener != null) {
                this.mRestrictedClickListener.accept(this);
            }
        } else {
            super.performClick();
        }
    }

    public void setShouldDisableView(boolean shouldDisableView) {
        throw new UnsupportedOperationException("android:shouldDisableView isunsupported on CarUiPreferences");
    }

    public void setShowChevron(boolean showChevron) {
        this.mShowChevron = showChevron;
    }

    @Override
    public boolean isUxRestricted() {
        return this.mUxRestricted;
    }

    @Override
    public void setOnClickWhileRestrictedListener(@Nullable Consumer<Preference> listener) {
        this.mRestrictedClickListener = listener;
    }

    @Override
    @Nullable
    public Consumer<Preference> getOnClickWhileRestrictedListener() {
        return this.mRestrictedClickListener;
    }

    @Override
    public void setUxRestricted(boolean restricted) {
        this.mUxRestricted = restricted;
        this.notifyChanged();
    }

    @Override
    public void setClickableWhileDisabled(boolean clickableWhileDisabled) {
        if (this.mIsClickableWhileDisabled != clickableWhileDisabled) {
            super.setShouldDisableView(!clickableWhileDisabled);
            this.mIsClickableWhileDisabled = clickableWhileDisabled;
            this.notifyChanged();
        }
    }

    @Override
    public boolean isClickableWhileDisabled() {
        return this.mIsClickableWhileDisabled;
    }

    @Override
    public void setDisabledClickListener(Consumer<Preference> listener) {
        this.mDisabledClickListener = listener;
    }

    @Override
    public Consumer<Preference> getDisabledClickListener() {
        return this.mDisabledClickListener;
    }
}

