/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.android.car.ui.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SuppressLint(value={"Instantiatable"})
public interface CarUiPreferenceViewStub {
    public static final int PREFERENCE = 0;
    public static final int DROPDOWN = 1;
    public static final int SWITCH = 2;
    public static final int TWO_ACTION = 3;
    public static final int TWO_ACTION_TEXT = 4;
    public static final int TWO_ACTION_TEXT_BORDERLESS = 5;
    public static final int TWO_ACTION_ICON = 6;
    public static final int TWO_ACTION_SWITCH = 7;
    public static final int EDIT_TEXT = 8;
    public static final int SEEKBAR_DIALOG = 9;
    public static final int FOOTER = 10;
    public static final int CATEGORY = 11;

    public static View createCarUiPreferenceView(Context sourceContext, AttributeSet attrs) {
        TypedArray a = sourceContext.obtainStyledAttributes(attrs, R.styleable.CarUiPreference, 0, 0);
        int preferenceType = CarUiPreferenceViewStub.getPreferenceType(sourceContext, attrs);
        int layoutResId = CarUiPreferenceViewStub.getPreferenceViewResLayoutId(preferenceType);
        a.recycle();
        LayoutInflater inflater = LayoutInflater.from((Context)sourceContext);
        return inflater.inflate(layoutResId, null, false);
    }

    public static int getPreferenceType(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Preference, 0, 0);
        int preferenceType = a.getInt(R.styleable.Preference_carUiPreferenceType, 0);
        a.recycle();
        return preferenceType;
    }

    public static int getPreferenceViewResLayoutId(int preferenceType) {
        switch (preferenceType) {
            case 2: {
                return R.layout.car_ui_preference_primary_switch_internal;
            }
            case 8: {
                return R.layout.car_ui_preference_dialog_edittext_internal;
            }
            case 11: {
                return R.layout.car_ui_preference_category_internal;
            }
            case 1: {
                return R.layout.car_ui_preference_dropdown_internal;
            }
            case 3: {
                return R.layout.car_ui_two_action_preference_internal;
            }
            case 4: {
                return R.layout.car_ui_preference_two_action_text_internal;
            }
            case 5: {
                return R.layout.car_ui_preference_two_action_text_borderless_internal;
            }
            case 6: {
                return R.layout.car_ui_preference_two_action_icon_internal;
            }
            case 7: {
                return R.layout.car_ui_preference_two_action_switch_internal;
            }
            case 9: {
                return R.layout.car_ui_seekbar_dialog_internal;
            }
            case 10: {
                return R.layout.car_ui_preference_footer_internal;
            }
        }
        return R.layout.car_ui_preference_internal;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PreferenceType {
    }
}

