/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.RadioButton;
import androidx.annotation.Nullable;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import androidx.preference.TwoStatePreference;
import com.android.car.ui.R;
import com.android.car.ui.preference.UxRestrictablePreference;
import com.android.car.ui.utils.CarUiUtils;
import java.util.function.Consumer;

public class CarUiRadioButtonPreference
extends TwoStatePreference
implements UxRestrictablePreference {
    private Consumer<Preference> mRestrictedClickListener;
    private boolean mUxRestricted = false;

    public CarUiRadioButtonPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public CarUiRadioButtonPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CarUiRadioButtonPreference(Context context, AttributeSet attrs) {
        this(context, attrs, CarUiUtils.getAttr(context, R.attr.preferenceStyle, 16842894));
    }

    public CarUiRadioButtonPreference(Context context) {
        this(context, null);
    }

    private void init() {
        this.setLayoutResource(R.layout.car_ui_preference);
        this.setWidgetLayoutResource(R.layout.car_ui_radio_button_preference_widget);
    }

    public void performClick() {
        if ((this.isEnabled() || this.isSelectable()) && this.isUxRestricted()) {
            if (this.mRestrictedClickListener != null) {
                this.mRestrictedClickListener.accept((Preference)this);
            }
        } else {
            super.performClick();
        }
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        RadioButton radioButton = (RadioButton)CarUiUtils.findViewByRefId(holder.itemView, R.id.radio_button);
        radioButton.setChecked(this.isChecked());
        CarUiUtils.makeAllViewsUxRestricted(holder.itemView, this.mUxRestricted);
    }

    @Override
    public void setUxRestricted(boolean restricted) {
        if (restricted != this.mUxRestricted) {
            this.mUxRestricted = restricted;
            this.notifyChanged();
        }
    }

    @Override
    public boolean isUxRestricted() {
        return this.mUxRestricted;
    }

    @Override
    public void setOnClickWhileRestrictedListener(@Nullable Consumer<Preference> listener) {
        this.mRestrictedClickListener = listener;
    }

    @Override
    @Nullable
    public Consumer<Preference> getOnClickWhileRestrictedListener() {
        return this.mRestrictedClickListener;
    }
}

