/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.preference.DialogPreference;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import com.android.car.ui.R;
import com.android.car.ui.preference.DialogFragmentCallbacks;
import com.android.car.ui.preference.UxRestrictablePreference;
import com.android.car.ui.utils.CarUiUtils;
import java.util.function.Consumer;

public class CarUiSeekBarDialogPreference
extends DialogPreference
implements DialogFragmentCallbacks,
UxRestrictablePreference {
    private int mSeekBarProgress;
    private SeekBar mSeekBar;
    private int mSeekBarTopTextViewVisibility;
    private TextView mSeekBarTopTextView;
    private String mSeekBarTopText;
    private int mSeekBarLeftTextViewVisibility;
    private TextView mSeekBarLeftTextView;
    private String mSeekBarLeftText;
    private int mSeekBarRightTextViewVisibility;
    private TextView mSeekBarRightTextView;
    private String mSeekBarRightText;
    private SeekBar.OnSeekBarChangeListener mOnSeekBarChangeListener;
    private int mMaxProgress = 100;
    private Consumer<Preference> mRestrictedClickListener;
    private boolean mUxRestricted = false;

    public CarUiSeekBarDialogPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public CarUiSeekBarDialogPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public CarUiSeekBarDialogPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CarUiSeekBarDialogPreference(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setDialogLayoutResource(R.layout.car_ui_seekbar_dialog);
        this.setPositiveButtonText(R.string.car_ui_dialog_preference_positive);
        this.setNegativeButtonText(R.string.car_ui_dialog_preference_negative);
    }

    public void onAttached() {
        super.onAttached();
        this.mSeekBarProgress = this.getPersistedInt(0);
    }

    @Override
    public void onBindDialogView(@NonNull View view) {
        this.mSeekBar = (SeekBar)CarUiUtils.findViewByRefId(view, R.id.seek_bar);
        this.mSeekBarTopTextView = (TextView)CarUiUtils.findViewByRefId(view, R.id.seek_bar_text_top);
        this.mSeekBarLeftTextView = (TextView)CarUiUtils.findViewByRefId(view, R.id.seek_bar_text_left);
        this.mSeekBarRightTextView = (TextView)CarUiUtils.findViewByRefId(view, R.id.seek_bar_text_right);
        this.setProgress(this.mSeekBarProgress);
        this.setSeekBarTopTextViewVisibility(this.mSeekBarTopTextViewVisibility);
        this.setSeekBarTopTextViewText(this.mSeekBarTopText);
        this.setSeekBarLeftTextViewVisibility(this.mSeekBarLeftTextViewVisibility);
        this.setSeekBarLeftTextViewText(this.mSeekBarLeftText);
        this.setSeekBarRightTextViewVisibility(this.mSeekBarRightTextViewVisibility);
        this.setSeekBarRightTextViewText(this.mSeekBarRightText);
        this.setMaxProgress(this.mMaxProgress);
        this.setOnSeekBarChangeListener(this.mOnSeekBarChangeListener);
    }

    public int getProgress() {
        if (this.mSeekBar != null) {
            return this.mSeekBar.getProgress();
        }
        return this.mSeekBarProgress;
    }

    public void setProgress(int progress) {
        if (this.mSeekBar != null) {
            this.mSeekBar.setProgress(progress);
        }
        this.mSeekBarProgress = progress;
    }

    @Override
    public void onDialogClosed(boolean positiveResult) {
        if (positiveResult) {
            this.mSeekBarProgress = this.mSeekBar.getProgress();
            this.persistInt(this.mSeekBarProgress);
            this.notifyChanged();
        }
        this.mSeekBarTopTextView = null;
        this.mSeekBarRightTextView = null;
        this.mSeekBarLeftTextView = null;
        this.mSeekBar = null;
    }

    public void setSeekBarTopTextViewVisibility(int visibility) {
        if (this.mSeekBarTopTextView != null) {
            this.mSeekBarTopTextView.setVisibility(visibility);
        }
        this.mSeekBarTopTextViewVisibility = visibility;
    }

    @Nullable
    public String getSeekBarTopTextViewText() {
        if (this.mSeekBarTopTextView != null) {
            return this.mSeekBarTopTextView.getText().toString();
        }
        return this.mSeekBarTopText;
    }

    public void setSeekBarTopTextViewText(String text) {
        if (this.mSeekBarTopTextView != null) {
            this.mSeekBarTopTextView.setText((CharSequence)text);
        }
        this.mSeekBarTopText = text;
    }

    public void setSeekBarLeftTextViewVisibility(int visibility) {
        if (this.mSeekBarLeftTextView != null) {
            this.mSeekBarLeftTextView.setVisibility(visibility);
        }
        this.mSeekBarLeftTextViewVisibility = visibility;
    }

    @Nullable
    public String getSeekBarLeftTextViewText() {
        if (this.mSeekBarLeftTextView != null) {
            return this.mSeekBarLeftTextView.getText().toString();
        }
        return this.mSeekBarLeftText;
    }

    public void setSeekBarLeftTextViewText(@Nullable String text) {
        if (this.mSeekBarLeftTextView != null) {
            this.mSeekBarLeftTextView.setText((CharSequence)text);
        }
        this.mSeekBarLeftText = text;
    }

    public void setSeekBarRightTextViewVisibility(int visibility) {
        if (this.mSeekBarRightTextView != null) {
            this.mSeekBarRightTextView.setVisibility(visibility);
        }
        this.mSeekBarRightTextViewVisibility = visibility;
    }

    @Nullable
    public String getSeekBarRightTextViewText() {
        if (this.mSeekBarRightTextView != null) {
            return this.mSeekBarRightTextView.getText().toString();
        }
        return this.mSeekBarRightText;
    }

    public void setSeekBarRightTextViewText(@Nullable String text) {
        if (this.mSeekBarRightTextView != null) {
            this.mSeekBarRightTextView.setText((CharSequence)text);
        }
        this.mSeekBarRightText = text;
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener listener) {
        if (this.mSeekBar != null) {
            this.mSeekBar.setOnSeekBarChangeListener(listener);
        }
        this.mOnSeekBarChangeListener = listener;
    }

    public int getMaxProgress() {
        if (this.mSeekBar != null) {
            return this.mSeekBar.getMax();
        }
        return this.mMaxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        if (this.mSeekBar != null) {
            this.mSeekBar.setMax(maxProgress);
        }
        this.mMaxProgress = maxProgress;
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        CarUiUtils.makeAllViewsUxRestricted(holder.itemView, this.isUxRestricted());
    }

    public void performClick() {
        if ((this.isEnabled() || this.isSelectable()) && this.isUxRestricted()) {
            if (this.mRestrictedClickListener != null) {
                this.mRestrictedClickListener.accept((Preference)this);
            }
        } else {
            super.performClick();
        }
    }

    @Override
    public void setUxRestricted(boolean restricted) {
        if (restricted != this.mUxRestricted) {
            this.mUxRestricted = restricted;
            this.notifyChanged();
        }
    }

    @Override
    public boolean isUxRestricted() {
        return this.mUxRestricted;
    }

    @Override
    public void setOnClickWhileRestrictedListener(@Nullable Consumer<Preference> listener) {
        this.mRestrictedClickListener = listener;
    }

    @Override
    @Nullable
    public Consumer<Preference> getOnClickWhileRestrictedListener() {
        return this.mRestrictedClickListener;
    }
}

