/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.preference.Preference;
import androidx.preference.PreferenceViewHolder;
import androidx.preference.SwitchPreference;
import com.android.car.ui.R;
import com.android.car.ui.preference.ClickableWhileDisabledPreference;
import com.android.car.ui.preference.DisabledPreferenceCallback;
import com.android.car.ui.utils.CarUiUtils;
import java.util.function.Consumer;

public class CarUiSwitchPreference
extends SwitchPreference
implements DisabledPreferenceCallback,
ClickableWhileDisabledPreference {
    private Consumer<Preference> mRestrictedClickListener;
    private Consumer<Preference> mDisabledClickListener;
    private boolean mUxRestricted = false;
    private boolean mIsClickableWhileDisabled = false;

    public CarUiSwitchPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public CarUiSwitchPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public CarUiSwitchPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public CarUiSwitchPreference(Context context) {
        super(context);
        this.init(null);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CarUiPreference);
        this.mUxRestricted = a.getBoolean(R.styleable.CarUiPreference_car_ui_ux_restricted, false);
        this.mIsClickableWhileDisabled = a.getBoolean(R.styleable.CarUiPreference_carUiClickableWhileDisabled, false);
        if (this.mIsClickableWhileDisabled) {
            super.setShouldDisableView(false);
        }
        a.recycle();
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        CarUiUtils.makeAllViewsEnabledAndUxRestricted(holder.itemView, this.isEnabled(), this.isUxRestricted());
    }

    public void performClick() {
        if (!this.isEnabled() && this.mIsClickableWhileDisabled) {
            if (this.mDisabledClickListener != null) {
                this.mDisabledClickListener.accept((Preference)this);
            }
        } else if ((this.isEnabled() || this.isSelectable()) && this.isUxRestricted()) {
            if (this.mRestrictedClickListener != null) {
                this.mRestrictedClickListener.accept((Preference)this);
            }
        } else {
            super.performClick();
        }
    }

    public void setShouldDisableView(boolean shouldDisableView) {
        throw new UnsupportedOperationException("Dynamically setting shouldDisableView isunsupported in CarUiPreferences");
    }

    @Override
    public void setUxRestricted(boolean restricted) {
        if (this.mUxRestricted != restricted) {
            this.mUxRestricted = restricted;
            this.notifyChanged();
        }
    }

    @Override
    public boolean isUxRestricted() {
        return this.mUxRestricted;
    }

    @Override
    public void setOnClickWhileRestrictedListener(@Nullable Consumer<Preference> listener) {
        this.mRestrictedClickListener = listener;
    }

    @Override
    @Nullable
    public Consumer<Preference> getOnClickWhileRestrictedListener() {
        return this.mRestrictedClickListener;
    }

    @Override
    public void setClickableWhileDisabled(boolean clickableWhileDisabled) {
        if (this.mIsClickableWhileDisabled != clickableWhileDisabled) {
            super.setShouldDisableView(!clickableWhileDisabled);
            this.mIsClickableWhileDisabled = clickableWhileDisabled;
            this.notifyChanged();
        }
    }

    @Override
    public boolean isClickableWhileDisabled() {
        return this.mIsClickableWhileDisabled;
    }

    @Override
    public void setDisabledClickListener(Consumer<Preference> listener) {
        this.mDisabledClickListener = listener;
    }

    @Override
    public Consumer<Preference> getDisabledClickListener() {
        return this.mDisabledClickListener;
    }
}

