/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.preference.Preference;
import com.android.car.ui.R;
import com.android.car.ui.preference.CarUiPreference;
import java.util.function.Consumer;

public abstract class CarUiTwoActionBasePreference
extends CarUiPreference {
    protected boolean mSecondaryActionEnabled = true;
    protected boolean mSecondaryActionVisible = true;

    public CarUiTwoActionBasePreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public CarUiTwoActionBasePreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public CarUiTwoActionBasePreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public CarUiTwoActionBasePreference(Context context) {
        super(context);
        this.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    protected void init(@Nullable AttributeSet attrs) {
        this.setShowChevron(false);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CarUiTwoActionBasePreference);
        try {
            CarUiTwoActionBasePreference.disallowResourceIds(a, R.styleable.CarUiTwoActionBasePreference_carUiLayout, R.styleable.CarUiTwoActionBasePreference_android_layout, R.styleable.CarUiTwoActionBasePreference_widgetLayout, R.styleable.CarUiTwoActionBasePreference_android_widgetLayout);
        }
        finally {
            a.recycle();
        }
        a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CarUiTwoActionPreference);
        try {
            this.mSecondaryActionVisible = a.getBoolean(R.styleable.CarUiTwoActionPreference_actionShown, true);
            this.mSecondaryActionEnabled = a.getBoolean(R.styleable.CarUiTwoActionPreference_actionEnabled, true);
        }
        finally {
            a.recycle();
        }
    }

    public boolean isSecondaryActionEnabled() {
        return this.mSecondaryActionEnabled && this.isEnabled();
    }

    public void setSecondaryActionEnabled(boolean enabled) {
        this.mSecondaryActionEnabled = enabled;
        this.notifyChanged();
    }

    public boolean isSecondaryActionVisible() {
        return this.mSecondaryActionVisible;
    }

    public void setSecondaryActionVisible(boolean visible) {
        this.mSecondaryActionVisible = visible;
        this.notifyChanged();
    }

    public void performSecondaryActionClick() {
        if (this.isSecondaryActionEnabled()) {
            if (this.isUxRestricted()) {
                Consumer<Preference> restrictedListener = this.getOnClickWhileRestrictedListener();
                if (restrictedListener != null) {
                    restrictedListener.accept(this);
                }
            } else {
                this.performSecondaryActionClickInternal();
            }
        } else if (this.isClickableWhileDisabled() && this.getDisabledClickListener() != null) {
            this.getDisabledClickListener().accept(this);
        }
    }

    protected abstract void performSecondaryActionClickInternal();

    protected void setLayoutResourceInternal(@LayoutRes int layoutResId) {
        super.setLayoutResource(layoutResId);
    }

    public void setLayoutResource(@LayoutRes int layoutResId) {
        throw new UnsupportedOperationException();
    }

    public void setWidgetLayoutResource(@LayoutRes int widgetLayoutResId) {
        throw new UnsupportedOperationException();
    }

    private static void disallowResourceIds(@NonNull TypedArray a, int ... indices) {
        for (int index : indices) {
            if (a.hasValue(index)) {
                throw new AssertionError((Object)("Setting this attribute is not allowed: " + a.getResources().getResourceName(index)));
            }
        }
    }
}

