/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.preference.PreferenceViewHolder;
import com.android.car.ui.R;
import com.android.car.ui.preference.CarUiTwoActionBasePreference;
import com.android.car.ui.utils.CarUiUtils;

public class CarUiTwoActionIconPreference
extends CarUiTwoActionBasePreference {
    @Nullable
    protected Runnable mSecondaryActionOnClickListener;
    @Nullable
    private Drawable mSecondaryActionIcon;

    public CarUiTwoActionIconPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public CarUiTwoActionIconPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CarUiTwoActionIconPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CarUiTwoActionIconPreference(Context context) {
        super(context);
    }

    @Override
    protected void init(@Nullable AttributeSet attrs) {
        super.init(attrs);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CarUiTwoActionIconPreference);
        try {
            this.mSecondaryActionIcon = a.getDrawable(R.styleable.CarUiTwoActionIconPreference_secondaryActionIcon);
        }
        finally {
            a.recycle();
        }
        this.setLayoutResourceInternal(R.layout.car_ui_preference_two_action_icon);
    }

    @Override
    protected void performSecondaryActionClickInternal() {
        if (this.mSecondaryActionOnClickListener != null) {
            this.mSecondaryActionOnClickListener.run();
        }
    }

    @Override
    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        Object firstActionContainer = CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_first_action_container);
        Object secondActionContainer = CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_second_action_container);
        ViewGroup secondaryButton = (ViewGroup)CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_secondary_action);
        ImageView iconView = (ImageView)CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_secondary_action_concrete);
        holder.itemView.setFocusable(false);
        holder.itemView.setClickable(false);
        firstActionContainer.setOnClickListener(this::performClickUnrestricted);
        firstActionContainer.setEnabled(this.isEnabled() || this.isClickableWhileDisabled());
        firstActionContainer.setFocusable(this.isEnabled() || this.isClickableWhileDisabled());
        secondActionContainer.setVisibility(this.mSecondaryActionVisible ? 0 : 8);
        iconView.setImageDrawable(this.mSecondaryActionIcon);
        iconView.setEnabled(this.isSecondaryActionEnabled() || this.isClickableWhileDisabled());
        secondaryButton.setEnabled(this.isSecondaryActionEnabled() || this.isClickableWhileDisabled());
        secondaryButton.setFocusable(this.isSecondaryActionEnabled() || this.isClickableWhileDisabled());
        secondaryButton.setOnClickListener(v -> this.performSecondaryActionClick());
        CarUiUtils.makeAllViewsEnabledAndUxRestricted((View)secondaryButton, this.isSecondaryActionEnabled(), this.isUxRestricted());
    }

    public void setSecondaryActionIcon(@Nullable Drawable drawable2) {
        this.mSecondaryActionIcon = drawable2;
        this.notifyChanged();
    }

    public void setSecondaryActionIcon(@DrawableRes int resid) {
        this.setSecondaryActionIcon(ContextCompat.getDrawable((Context)this.getContext(), (int)resid));
    }

    public void setOnSecondaryActionClickListener(@Nullable Runnable onClickListener) {
        this.mSecondaryActionOnClickListener = onClickListener;
        this.notifyChanged();
    }
}

