/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.widget.Switch;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.preference.PreferenceViewHolder;
import com.android.car.ui.R;
import com.android.car.ui.preference.CarUiTwoActionBasePreference;
import com.android.car.ui.utils.CarUiUtils;
import java.util.function.Consumer;

public class CarUiTwoActionSwitchPreference
extends CarUiTwoActionBasePreference {
    @Nullable
    protected Consumer<Boolean> mSecondaryActionOnClickListener;
    private boolean mSecondaryActionChecked;
    private final boolean mSwitchWidgetFocusable = this.getContext().getResources().getBoolean(R.bool.car_ui_preference_two_action_switch_widget_focusable);
    @NonNull
    private Switch mSwitchWidget;

    public CarUiTwoActionSwitchPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public CarUiTwoActionSwitchPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CarUiTwoActionSwitchPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CarUiTwoActionSwitchPreference(Context context) {
        super(context);
    }

    @Override
    protected void init(@Nullable AttributeSet attrs) {
        super.init(attrs);
        this.setLayoutResourceInternal(R.layout.car_ui_preference_two_action_switch);
    }

    @Override
    protected void performSecondaryActionClickInternal() {
        this.mSecondaryActionChecked = !this.mSecondaryActionChecked;
        this.notifyChanged();
        if (this.mSecondaryActionOnClickListener != null) {
            this.mSecondaryActionOnClickListener.accept(this.mSecondaryActionChecked);
        }
    }

    @Override
    public void performSecondaryActionClick() {
        super.performSecondaryActionClick();
        if (this.mSwitchWidget.isChecked() != this.isSecondaryActionChecked()) {
            this.mSwitchWidget.setChecked(this.isSecondaryActionChecked());
        }
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        Object firstActionContainer = CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_first_action_container);
        Object secondActionContainer = CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_second_action_container);
        Object secondaryAction = CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_secondary_action);
        this.mSwitchWidget = (Switch)CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_secondary_action_concrete);
        boolean firstActionEnabledViewState = this.isEnabled() || this.isUxRestricted() || this.isClickableWhileDisabled();
        boolean secondaryActionEnabledViewState = this.isSecondaryActionEnabled() || this.isUxRestricted() || this.isClickableWhileDisabled();
        holder.itemView.setFocusable(false);
        holder.itemView.setClickable(false);
        firstActionContainer.setOnClickListener(this::performClickUnrestricted);
        firstActionContainer.setEnabled(firstActionEnabledViewState);
        firstActionContainer.setFocusable(firstActionEnabledViewState);
        secondActionContainer.setVisibility(this.mSecondaryActionVisible ? 0 : 8);
        this.mSwitchWidget.setChecked(this.mSecondaryActionChecked);
        secondaryAction.setEnabled(secondaryActionEnabledViewState);
        this.mSwitchWidget.setEnabled(secondaryActionEnabledViewState);
        secondaryAction.setOnClickListener(v -> this.performSecondaryActionClick());
        this.mSwitchWidget.setOnClickListener(v -> this.performSecondaryActionClick());
        this.mSwitchWidget.setOnTouchListener((view, event) -> {
            if (!this.isSecondaryActionEnabled() && this.isClickableWhileDisabled() || this.isUxRestricted()) {
                if (event.getAction() == 1) {
                    view.performClick();
                }
                return true;
            }
            return false;
        });
        if (this.mSwitchWidgetFocusable) {
            secondaryAction.setFocusable(false);
            this.mSwitchWidget.setFocusable(secondaryActionEnabledViewState);
        } else {
            this.mSwitchWidget.setFocusable(false);
            secondaryAction.setFocusable(secondaryActionEnabledViewState);
        }
        CarUiUtils.makeAllViewsEnabledAndUxRestricted(secondaryAction, this.isSecondaryActionEnabled(), this.isUxRestricted());
    }

    public void setSecondaryActionChecked(boolean checked) {
        this.mSecondaryActionChecked = checked;
        this.notifyChanged();
    }

    public boolean isSecondaryActionChecked() {
        return this.mSecondaryActionChecked;
    }

    public void setOnSecondaryActionClickListener(@Nullable Consumer<Boolean> onClickListener) {
        this.mSecondaryActionOnClickListener = onClickListener;
        this.notifyChanged();
    }
}

