/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.preference.PreferenceViewHolder;
import com.android.car.ui.R;
import com.android.car.ui.preference.CarUiTwoActionBasePreference;
import com.android.car.ui.utils.CarUiUtils;

public class CarUiTwoActionTextPreference
extends CarUiTwoActionBasePreference {
    @Nullable
    protected Runnable mSecondaryActionOnClickListener;
    @Nullable
    private CharSequence mSecondaryActionText;
    public static final int SECONDARY_ACTION_STYLE_BORDERED = 0;
    public static final int SECONDARY_ACTION_STYLE_BORDERLESS = 1;

    public CarUiTwoActionTextPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public CarUiTwoActionTextPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CarUiTwoActionTextPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CarUiTwoActionTextPreference(Context context) {
        super(context);
    }

    public CarUiTwoActionTextPreference(Context context, @SecondaryActionStyle int secondaryActionStyle) {
        super(context);
        this.setLayoutResourceInternal(secondaryActionStyle == 0 ? R.layout.car_ui_preference_two_action_text : R.layout.car_ui_preference_two_action_text_borderless);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init(@Nullable AttributeSet attrs) {
        super.init(attrs);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CarUiTwoActionTextPreference);
        int actionStyle = 0;
        try {
            actionStyle = a.getInteger(R.styleable.CarUiTwoActionTextPreference_secondaryActionStyle, 0);
            this.mSecondaryActionText = a.getString(R.styleable.CarUiTwoActionTextPreference_secondaryActionText);
        }
        finally {
            a.recycle();
        }
        this.setLayoutResourceInternal(actionStyle == 0 ? R.layout.car_ui_preference_two_action_text : R.layout.car_ui_preference_two_action_text_borderless);
    }

    @Override
    protected void performSecondaryActionClickInternal() {
        if (this.mSecondaryActionOnClickListener != null) {
            this.mSecondaryActionOnClickListener.run();
        }
    }

    @Override
    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        Object firstActionContainer = CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_first_action_container);
        Object secondActionContainer = CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_second_action_container);
        Button secondaryButton = (Button)CarUiUtils.requireViewByRefId(holder.itemView, R.id.car_ui_secondary_action);
        holder.itemView.setFocusable(false);
        holder.itemView.setClickable(false);
        firstActionContainer.setOnClickListener(this::performClickUnrestricted);
        firstActionContainer.setEnabled(this.isEnabled() || this.isClickableWhileDisabled());
        firstActionContainer.setFocusable(this.isEnabled() || this.isClickableWhileDisabled());
        secondActionContainer.setVisibility(this.mSecondaryActionVisible ? 0 : 8);
        secondaryButton.setText(this.mSecondaryActionText);
        secondaryButton.setOnClickListener(v -> this.performSecondaryActionClick());
        secondaryButton.setEnabled(this.isSecondaryActionEnabled() || this.isClickableWhileDisabled());
        secondaryButton.setFocusable(this.isSecondaryActionEnabled() || this.isClickableWhileDisabled());
        CarUiUtils.makeAllViewsEnabledAndUxRestricted((View)secondaryButton, this.isSecondaryActionEnabled(), this.isUxRestricted());
    }

    @Nullable
    public CharSequence getSecondaryActionText() {
        return this.mSecondaryActionText;
    }

    public void setSecondaryActionText(@Nullable CharSequence title) {
        this.mSecondaryActionText = title;
        this.notifyChanged();
    }

    public void setSecondaryActionText(@StringRes int resid) {
        this.setSecondaryActionText(this.getContext().getString(resid));
    }

    public void setOnSecondaryActionClickListener(@Nullable Runnable onClickListener) {
        this.mSecondaryActionOnClickListener = onClickListener;
        this.notifyChanged();
    }

    public static @interface SecondaryActionStyle {
    }
}

