/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.preference.EditTextPreference;
import com.android.car.ui.preference.PreferenceDialogFragment;
import com.android.car.ui.utils.CarUiUtils;

public class EditTextPreferenceDialogFragment
extends PreferenceDialogFragment
implements TextView.OnEditorActionListener {
    private static final String SAVE_STATE_TEXT = "EditTextPreferenceDialogFragment.text";
    private EditText mEditText;
    private CharSequence mText;
    private boolean mAllowEnterToSubmit = true;

    @NonNull
    public static EditTextPreferenceDialogFragment newInstance(String key) {
        EditTextPreferenceDialogFragment fragment = new EditTextPreferenceDialogFragment();
        Bundle b = new Bundle(1);
        b.putString("key", key);
        fragment.setArguments(b);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mText = savedInstanceState == null ? this.getEditTextPreference().getText() : savedInstanceState.getCharSequence(SAVE_STATE_TEXT);
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putCharSequence(SAVE_STATE_TEXT, this.mText);
    }

    @Override
    protected void onBindDialogView(@NonNull View view) {
        super.onBindDialogView(view);
        this.mEditText = (EditText)CarUiUtils.findViewByRefId(view, 16908291);
        if (this.mEditText == null) {
            throw new IllegalStateException("Dialog view must contain an EditText with id @android:id/edit");
        }
        this.mEditText.requestFocus();
        this.mEditText.setText(this.mText);
        this.mEditText.setInputType(1);
        this.mEditText.setImeOptions(6);
        this.mEditText.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mEditText.setSelection(this.mEditText.getText().length());
    }

    private EditTextPreference getEditTextPreference() {
        return (EditTextPreference)this.getPreference();
    }

    @Override
    protected boolean needInputMethod() {
        return true;
    }

    @Override
    protected void onDialogClosed(boolean positiveResult) {
        if (positiveResult) {
            String value = this.mEditText.getText().toString();
            if (this.getEditTextPreference().callChangeListener((Object)value)) {
                this.getEditTextPreference().setText(value);
            }
        }
    }

    public void setAllowEnterToSubmit(boolean isAllowed) {
        this.mAllowEnterToSubmit = isAllowed;
    }

    public boolean getAllowEnterToSubmit() {
        return this.mAllowEnterToSubmit;
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 6 && this.mAllowEnterToSubmit) {
            CharSequence newValue = v.getText();
            this.getEditTextPreference().callChangeListener((Object)newValue);
            this.dismiss();
            return true;
        }
        return false;
    }
}

