/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.preference.DialogPreference;
import androidx.preference.ListPreference;
import androidx.preference.Preference;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.FocusArea;
import com.android.car.ui.R;
import com.android.car.ui.baselayout.Insets;
import com.android.car.ui.baselayout.InsetsChangedListener;
import com.android.car.ui.preference.PreferenceFragment;
import com.android.car.ui.recyclerview.CarUiContentListItem;
import com.android.car.ui.recyclerview.CarUiListItemAdapter;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.utils.CarUiUtils;
import java.util.ArrayList;

public class ListPreferenceFragment
extends Fragment
implements InsetsChangedListener {
    private ListPreference mPreference;
    private CarUiContentListItem mSelectedItem;
    private int mSelectedIndex = -1;
    private boolean mUseInstantPreferenceChangeCallback;

    @NonNull
    static ListPreferenceFragment newInstance(String key) {
        ListPreferenceFragment fragment = new ListPreferenceFragment();
        Bundle b = new Bundle(1);
        b.putString("key", key);
        fragment.setArguments(b);
        return fragment;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.car_ui_list_preference, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CarUiRecyclerView carUiRecyclerView = (CarUiRecyclerView)CarUiUtils.requireViewByRefId(view, R.id.list);
        this.mUseInstantPreferenceChangeCallback = this.getResources().getBoolean(R.bool.car_ui_preference_list_instant_change_callback);
        carUiRecyclerView.setClipToPadding(false);
        this.mPreference = this.getListPreference();
        CharSequence[] entries = this.mPreference.getEntries();
        CharSequence[] entryValues = this.mPreference.getEntryValues();
        if (entries == null || entryValues == null) {
            throw new IllegalStateException("ListPreference requires an entries array and an entryValues array.");
        }
        if (entries.length != entryValues.length) {
            throw new IllegalStateException("ListPreference entries array length does not match entryValues array length.");
        }
        this.mSelectedIndex = this.mPreference.findIndexOfValue(this.mPreference.getValue());
        ArrayList<CarUiContentListItem> listItems = new ArrayList<CarUiContentListItem>();
        CarUiListItemAdapter adapter = new CarUiListItemAdapter(listItems);
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i].toString();
            CarUiContentListItem item = new CarUiContentListItem(CarUiContentListItem.Action.RADIO_BUTTON);
            item.setTitle(entry);
            if (i == this.mSelectedIndex) {
                item.setChecked(true);
                this.mSelectedItem = item;
            }
            item.setOnCheckedChangeListener((listItem, isChecked) -> {
                if (!isChecked) {
                    return;
                }
                if (this.mSelectedItem != null) {
                    this.mSelectedItem.setChecked(false);
                    adapter.notifyItemChanged(listItems.indexOf(this.mSelectedItem));
                }
                this.mSelectedItem = listItem;
                this.mSelectedIndex = listItems.indexOf(this.mSelectedItem);
                if (this.mUseInstantPreferenceChangeCallback) {
                    this.updatePreference();
                }
            });
            listItems.add(item);
        }
        carUiRecyclerView.setAdapter(adapter);
        carUiRecyclerView.scrollToPosition(this.mSelectedIndex);
        carUiRecyclerView.post(() -> {
            RecyclerView.ViewHolder viewHolder = carUiRecyclerView.findViewHolderForAdapterPosition(this.mSelectedIndex);
            if (viewHolder != null) {
                viewHolder.itemView.requestFocus();
            }
        });
    }

    public void onStart() {
        Insets insets;
        super.onStart();
        if (this.getTargetFragment() instanceof PreferenceFragment && (insets = ((PreferenceFragment)this.getTargetFragment()).getPreferenceInsets(this)) != null) {
            this.onCarUiInsetsChanged(insets);
        }
    }

    public void onStop() {
        super.onStop();
        if (!this.mUseInstantPreferenceChangeCallback) {
            this.updatePreference();
        }
    }

    private void updatePreference() {
        String entryValue;
        if (this.mSelectedIndex >= 0 && this.mPreference != null && this.mPreference.callChangeListener((Object)(entryValue = this.mPreference.getEntryValues()[this.mSelectedIndex].toString()))) {
            this.mPreference.setValue(entryValue);
        }
    }

    private ListPreference getListPreference() {
        String key = this.requireArguments().getString("key");
        DialogPreference.TargetFragment fragment = (DialogPreference.TargetFragment)this.getTargetFragment();
        if (key == null) {
            throw new IllegalStateException("ListPreference key not found in Fragment arguments");
        }
        if (fragment == null) {
            throw new IllegalStateException("Target fragment must be registered before displaying ListPreference screen.");
        }
        Preference preference = fragment.findPreference((CharSequence)key);
        if (!(preference instanceof ListPreference)) {
            throw new IllegalStateException("Cannot use ListPreferenceFragment with a preference that is not of type ListPreference");
        }
        return (ListPreference)preference;
    }

    @Override
    public void onCarUiInsetsChanged(@NonNull Insets insets) {
        View view = this.requireView();
        CarUiUtils.requireViewByRefId(view, R.id.list).setPadding(0, insets.getTop(), 0, insets.getBottom());
        view.setPadding(insets.getLeft(), 0, insets.getRight(), 0);
        FocusArea focusArea = (FocusArea)view.findViewById(R.id.car_ui_focus_area);
        if (focusArea != null) {
            focusArea.setHighlightPadding(0, insets.getTop(), 0, insets.getBottom());
            focusArea.setBoundsOffset(0, insets.getTop(), 0, insets.getBottom());
        }
    }
}

