/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.preference.DialogPreference;
import androidx.preference.Preference;
import com.android.car.ui.FocusArea;
import com.android.car.ui.R;
import com.android.car.ui.baselayout.Insets;
import com.android.car.ui.baselayout.InsetsChangedListener;
import com.android.car.ui.preference.CarUiMultiSelectListPreference;
import com.android.car.ui.preference.PreferenceFragment;
import com.android.car.ui.recyclerview.CarUiContentListItem;
import com.android.car.ui.recyclerview.CarUiListItemAdapter;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.utils.CarUiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class MultiSelectListPreferenceFragment
extends Fragment
implements InsetsChangedListener {
    private CarUiMultiSelectListPreference mPreference;
    private Set<String> mNewValues;
    private boolean mUseInstantPreferenceChangeCallback;

    @NonNull
    static MultiSelectListPreferenceFragment newInstance(String key) {
        MultiSelectListPreferenceFragment fragment = new MultiSelectListPreferenceFragment();
        Bundle b = new Bundle(1);
        b.putString("key", key);
        fragment.setArguments(b);
        return fragment;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.car_ui_list_preference, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CarUiRecyclerView recyclerView = (CarUiRecyclerView)CarUiUtils.requireViewByRefId(view, R.id.list);
        this.mUseInstantPreferenceChangeCallback = this.getResources().getBoolean(R.bool.car_ui_preference_list_instant_change_callback);
        this.mPreference = this.getPreference();
        recyclerView.setClipToPadding(false);
        this.mNewValues = new HashSet<String>(this.mPreference.getValues());
        CharSequence[] entries = this.mPreference.getEntries();
        CharSequence[] entryValues = this.mPreference.getEntryValues();
        if (entries == null || entryValues == null) {
            throw new IllegalStateException("MultiSelectListPreference requires an entries array and an entryValues array.");
        }
        if (entries.length != entryValues.length) {
            throw new IllegalStateException("MultiSelectListPreference entries array length does not match entryValues array length.");
        }
        ArrayList<CarUiContentListItem> listItems = new ArrayList<CarUiContentListItem>();
        boolean[] selectedItems = this.mPreference.getSelectedItems();
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i].toString();
            String entryValue = entryValues[i].toString();
            CarUiContentListItem item = new CarUiContentListItem(CarUiContentListItem.Action.CHECK_BOX);
            item.setTitle(entry);
            item.setChecked(selectedItems[i]);
            item.setOnCheckedChangeListener((listItem, isChecked) -> {
                if (isChecked) {
                    this.mNewValues.add(entryValue);
                } else {
                    this.mNewValues.remove(entryValue);
                }
                if (this.mUseInstantPreferenceChangeCallback) {
                    this.updatePreference();
                }
            });
            listItems.add(item);
        }
        CarUiListItemAdapter adapter = new CarUiListItemAdapter(listItems);
        recyclerView.setAdapter(adapter);
    }

    public void onStart() {
        Insets insets;
        super.onStart();
        if (this.getTargetFragment() instanceof PreferenceFragment && (insets = ((PreferenceFragment)this.getTargetFragment()).getPreferenceInsets(this)) != null) {
            this.onCarUiInsetsChanged(insets);
        }
    }

    public void onStop() {
        super.onStop();
        if (!this.mUseInstantPreferenceChangeCallback) {
            this.updatePreference();
        }
    }

    private void updatePreference() {
        if (this.mPreference.callChangeListener(this.mNewValues)) {
            this.mPreference.setValues(this.mNewValues);
        }
    }

    private CarUiMultiSelectListPreference getPreference() {
        if (this.getArguments() == null) {
            throw new IllegalStateException("Preference arguments cannot be null");
        }
        String key = this.getArguments().getString("key");
        DialogPreference.TargetFragment fragment = (DialogPreference.TargetFragment)this.getTargetFragment();
        if (key == null) {
            throw new IllegalStateException("MultiSelectListPreference key not found in Fragment arguments");
        }
        if (fragment == null) {
            throw new IllegalStateException("Target fragment must be registered before displaying MultiSelectListPreference screen.");
        }
        Preference preference = fragment.findPreference((CharSequence)key);
        if (!(preference instanceof CarUiMultiSelectListPreference)) {
            throw new IllegalStateException("Cannot use MultiSelectListPreferenceFragment with a preference that is not of type CarUiMultiSelectListPreference");
        }
        return (CarUiMultiSelectListPreference)preference;
    }

    @Override
    public void onCarUiInsetsChanged(@NonNull Insets insets) {
        View view = this.requireView();
        CarUiUtils.requireViewByRefId(view, R.id.list).setPadding(0, insets.getTop(), 0, insets.getBottom());
        view.setPadding(insets.getLeft(), 0, insets.getRight(), 0);
        FocusArea focusArea = (FocusArea)view.findViewById(R.id.car_ui_focus_area);
        if (focusArea != null) {
            focusArea.setHighlightPadding(0, insets.getTop(), 0, insets.getBottom());
            focusArea.setBoundsOffset(0, insets.getTop(), 0, insets.getBottom());
        }
    }
}

