/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.preference.DialogPreference;
import com.android.car.ui.preference.CarUiDialogFragment;

public abstract class PreferenceDialogFragment
extends CarUiDialogFragment
implements DialogInterface.OnClickListener {
    protected static final String ARG_KEY = "key";
    private DialogPreference mPreference;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Fragment rawFragment = this.getTargetFragment();
        if (!(rawFragment instanceof DialogPreference.TargetFragment)) {
            throw new IllegalStateException("Target fragment must implement TargetFragment interface");
        }
        DialogPreference.TargetFragment fragment = (DialogPreference.TargetFragment)rawFragment;
        String key = this.getArguments().getString(ARG_KEY);
        if (savedInstanceState == null) {
            this.mPreference = (DialogPreference)fragment.findPreference((CharSequence)key);
            this.mDialogTitle = this.mPreference.getDialogTitle();
            this.mPositiveButtonText = this.mPreference.getPositiveButtonText();
            this.mNegativeButtonText = this.mPreference.getNegativeButtonText();
            this.mDialogMessage = this.mPreference.getDialogMessage();
            this.mDialogLayoutRes = this.mPreference.getDialogLayoutResource();
            Drawable icon = this.mPreference.getDialogIcon();
            if (icon == null || icon instanceof BitmapDrawable) {
                this.mDialogIcon = (BitmapDrawable)icon;
            } else {
                Bitmap bitmap = Bitmap.createBitmap((int)icon.getIntrinsicWidth(), (int)icon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                icon.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                icon.draw(canvas);
                this.mDialogIcon = new BitmapDrawable(this.getResources(), bitmap);
            }
        }
    }

    public DialogPreference getPreference() {
        if (this.mPreference == null) {
            String key = this.getArguments().getString(ARG_KEY);
            DialogPreference.TargetFragment fragment = (DialogPreference.TargetFragment)this.getTargetFragment();
            this.mPreference = (DialogPreference)fragment.findPreference((CharSequence)key);
        }
        return this.mPreference;
    }
}

