/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.preference;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.preference.DialogPreference;
import androidx.preference.DropDownPreference;
import androidx.preference.EditTextPreference;
import androidx.preference.ListPreference;
import androidx.preference.MultiSelectListPreference;
import androidx.preference.Preference;
import androidx.preference.PreferenceFragmentCompat;
import androidx.preference.PreferenceGroup;
import androidx.preference.PreferenceScreen;
import androidx.preference.SwitchPreference;
import androidx.preference.TwoStatePreference;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.FocusArea;
import com.android.car.ui.R;
import com.android.car.ui.baselayout.Insets;
import com.android.car.ui.baselayout.InsetsChangedListener;
import com.android.car.ui.core.CarUi;
import com.android.car.ui.preference.CarUiDropDownPreference;
import com.android.car.ui.preference.CarUiEditTextPreference;
import com.android.car.ui.preference.CarUiListPreference;
import com.android.car.ui.preference.CarUiMultiSelectListPreference;
import com.android.car.ui.preference.CarUiPreference;
import com.android.car.ui.preference.CarUiSeekBarDialogPreference;
import com.android.car.ui.preference.CarUiSwitchPreference;
import com.android.car.ui.preference.EditTextPreferenceDialogFragment;
import com.android.car.ui.preference.ListPreferenceFragment;
import com.android.car.ui.preference.MultiSelectListPreferenceFragment;
import com.android.car.ui.preference.SeekbarPreferenceDialogFragment;
import com.android.car.ui.preference.UxRestrictablePreference;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.toolbar.NavButtonMode;
import com.android.car.ui.toolbar.Toolbar;
import com.android.car.ui.toolbar.ToolbarController;
import com.android.car.ui.utils.CarUiUtils;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PreferenceFragment
extends PreferenceFragmentCompat
implements InsetsChangedListener {
    private static final String TAG = "CarUiPreferenceFragment";
    private static final String DIALOG_FRAGMENT_TAG = "com.android.car.ui.PreferenceFragment.DIALOG";
    @NonNull
    private CarUiRecyclerView mCarUiRecyclerView;
    @Nullable
    private ViewParent mRecyclerView;
    @Nullable
    private String mLastSelectedPrefKey;
    private int mLastFocusedAndSelectedPrefPosition;
    private static final List<Pair<Class<? extends Preference>, Class<? extends Preference>>> sPreferenceMapping = Arrays.asList(new Pair(DropDownPreference.class, CarUiDropDownPreference.class), new Pair(ListPreference.class, CarUiListPreference.class), new Pair(MultiSelectListPreference.class, CarUiMultiSelectListPreference.class), new Pair(EditTextPreference.class, CarUiEditTextPreference.class), new Pair(SwitchPreference.class, CarUiSwitchPreference.class), new Pair(Preference.class, CarUiPreference.class));

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ToolbarController toolbar = this.getPreferenceToolbar((Fragment)this);
        if (toolbar != null) {
            this.setupToolbar(toolbar);
        }
    }

    protected void setupToolbar(@NonNull ToolbarController toolbar) {
        toolbar.setNavButtonMode(Toolbar.NavButtonMode.BACK);
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            toolbar.setTitle(preferenceScreen.getTitle());
        } else {
            toolbar.setTitle("");
        }
    }

    @Nullable
    protected ToolbarController getPreferenceToolbar(@NonNull Fragment fragment) {
        return CarUi.getToolbar((Activity)this.getActivity());
    }

    @Nullable
    protected Insets getPreferenceInsets(@NonNull Fragment fragment) {
        return CarUi.getInsets((Activity)this.getActivity());
    }

    public void onStart() {
        super.onStart();
        Insets insets = this.getPreferenceInsets((Fragment)this);
        if (insets != null) {
            this.onCarUiInsetsChanged(insets);
        }
    }

    @Override
    public void onCarUiInsetsChanged(@NonNull Insets insets) {
        View view = this.requireView();
        FocusArea focusArea = (FocusArea)CarUiUtils.requireViewByRefId(view, R.id.car_ui_focus_area);
        focusArea.setHighlightPadding(0, insets.getTop(), 0, insets.getBottom());
        focusArea.setBoundsOffset(0, insets.getTop(), 0, insets.getBottom());
        this.getCarUiRecyclerView().setPadding(0, insets.getTop(), 0, insets.getBottom());
        view.setPadding(insets.getLeft(), 0, insets.getRight(), 0);
    }

    public void onDisplayPreferenceDialog(Preference preference) {
        Object f;
        if (this.getActivity() instanceof PreferenceFragmentCompat.OnPreferenceDisplayDialogCallback && ((PreferenceFragmentCompat.OnPreferenceDisplayDialogCallback)this.getActivity()).onPreferenceDisplayDialog((PreferenceFragmentCompat)this, preference)) {
            return;
        }
        if (this.requireFragmentManager().findFragmentByTag(DIALOG_FRAGMENT_TAG) != null) {
            return;
        }
        if (preference instanceof EditTextPreference) {
            f = EditTextPreferenceDialogFragment.newInstance(preference.getKey());
        } else if (preference instanceof ListPreference) {
            f = ListPreferenceFragment.newInstance(preference.getKey());
        } else if (preference instanceof MultiSelectListPreference) {
            f = MultiSelectListPreferenceFragment.newInstance(preference.getKey());
        } else if (preference instanceof CarUiSeekBarDialogPreference) {
            f = SeekbarPreferenceDialogFragment.newInstance(preference.getKey());
        } else {
            throw new IllegalArgumentException("Cannot display dialog for an unknown Preference type: " + preference.getClass().getSimpleName() + ". Make sure to implement onPreferenceDisplayDialog() to handle displaying a custom dialog for this Preference.");
        }
        f.setTargetFragment((Fragment)this, 0);
        if (f instanceof DialogFragment) {
            ((DialogFragment)f).show(this.getFragmentManager(), DIALOG_FRAGMENT_TAG);
        } else {
            if (this.getActivity() == null) {
                throw new IllegalStateException("Preference fragment is not attached to an Activity.");
            }
            if (this.getView() == null) {
                throw new IllegalStateException("Preference fragment must have a layout.");
            }
            Context context = this.getContext();
            this.getParentFragmentManager().beginTransaction().setCustomAnimations(CarUiUtils.getAttrResourceId(context, 16843493), CarUiUtils.getAttrResourceId(context, 16843494), CarUiUtils.getAttrResourceId(context, 16843495), CarUiUtils.getAttrResourceId(context, 16843496)).replace(((ViewGroup)this.getView().getParent()).getId(), (Fragment)f).addToBackStack(null).commit();
            this.setupChildFragmentToolbar(preference);
        }
    }

    protected void setupChildFragmentToolbar(@NonNull Preference preference) {
        ToolbarController toolbar = null;
        toolbar = this.getPreferenceToolbar((Fragment)this);
        if (toolbar != null) {
            toolbar.setTitle(preference.getTitle());
            toolbar.setSubtitle("");
            if (toolbar.isStateSet()) {
                toolbar.setState(Toolbar.State.SUBPAGE);
            } else {
                toolbar.setNavButtonMode(NavButtonMode.BACK);
            }
            toolbar.setLogo(null);
            toolbar.setMenuItems(null);
            toolbar.setTabs(Collections.emptyList());
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mLastSelectedPrefKey != null) {
            this.scrollToPreference(this.mLastSelectedPrefKey);
        }
    }

    public boolean onPreferenceTreeClick(Preference preference) {
        this.mLastSelectedPrefKey = preference.getKey();
        if (this.mRecyclerView != null) {
            View fragmentRoot = this.getView();
            View focusedChild = fragmentRoot.findFocus();
            boolean childHasFocus = false;
            while (focusedChild != null) {
                ViewParent parent = focusedChild.getParent();
                if (parent == this.mRecyclerView) {
                    childHasFocus = true;
                    break;
                }
                if (parent == null || !(parent instanceof View)) break;
                focusedChild = (View)parent;
            }
            if (childHasFocus) {
                this.mLastFocusedAndSelectedPrefPosition = this.mCarUiRecyclerView.getChildLayoutPosition(focusedChild);
                Log.d((String)TAG, (String)("mLastFocusedAndSelectedPrefPosition is set to " + this.mLastFocusedAndSelectedPrefPosition));
            }
        }
        return super.onPreferenceTreeClick(preference);
    }

    public void setPreferenceScreen(PreferenceScreen preferenceScreen) {
        HashMap<Preference, String> dependencies = new HashMap<Preference, String>();
        ArrayList<Preference> children = new ArrayList<Preference>();
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.addFirst(preferenceScreen);
        while (!stack.isEmpty()) {
            Preference preference = (Preference)stack.removeFirst();
            if (!(preference instanceof PreferenceGroup)) continue;
            PreferenceGroup pg = (PreferenceGroup)preference;
            children.clear();
            for (int i = 0; i < pg.getPreferenceCount(); ++i) {
                children.add(pg.getPreference(i));
            }
            pg.removeAll();
            for (Preference child : children) {
                Preference replacement = PreferenceFragment.getReplacementFor(child);
                dependencies.put(replacement, child.getDependency());
                pg.addPreference(replacement);
                stack.addFirst(replacement);
            }
        }
        super.setPreferenceScreen(preferenceScreen);
        for (Map.Entry entry : dependencies.entrySet()) {
            ((Preference)entry.getKey()).setDependency((String)entry.getValue());
        }
    }

    @NonNull
    public CarUiRecyclerView onCreateCarUiRecyclerView(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        return (CarUiRecyclerView)CarUiUtils.requireViewByRefId((View)parent, R.id.recycler_view);
    }

    @NonNull
    public CarUiRecyclerView getCarUiRecyclerView() {
        return this.mCarUiRecyclerView;
    }

    private static Preference getReplacementFor(Preference preference) {
        Class<?> clazz = preference.getClass();
        for (Pair<Class<? extends Preference>, Class<? extends Preference>> replacement : sPreferenceMapping) {
            Class source = (Class)replacement.first;
            Class target = (Class)replacement.second;
            if (!source.isAssignableFrom(clazz)) continue;
            if (clazz == source) {
                try {
                    return PreferenceFragment.copyPreference(preference, (Preference)target.getDeclaredConstructor(Context.class).newInstance(preference.getContext()));
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Failed to copy Preference " + preference, e.getCause() == null ? e : e.getCause());
                }
            }
            if (clazz == target || source == Preference.class) {
                return preference;
            }
            Log.w((String)TAG, (String)("Subclass of " + source.getSimpleName() + " was used, preventing us from substituting it with " + target.getSimpleName()));
            return preference;
        }
        return preference;
    }

    public RecyclerView onCreateRecyclerView(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        this.mCarUiRecyclerView = this.onCreateCarUiRecyclerView(inflater, parent, savedInstanceState);
        RecyclerView recyclerView = null;
        if (this.mCarUiRecyclerView instanceof AndroidxRecyclerViewProvider) {
            recyclerView = ((AndroidxRecyclerViewProvider)((Object)this.mCarUiRecyclerView)).getRecyclerView();
        }
        if (recyclerView == null) {
            recyclerView = super.onCreateRecyclerView(inflater, parent, savedInstanceState);
        }
        if (this.mCarUiRecyclerView != null) {
            this.mCarUiRecyclerView.addOnChildAttachStateChangeListener(new RecyclerView.OnChildAttachStateChangeListener(){

                public void onChildViewAttachedToWindow(View view) {
                    int position;
                    if (PreferenceFragment.this.mRecyclerView == null) {
                        PreferenceFragment.this.mRecyclerView = view.getParent();
                    }
                    if ((position = PreferenceFragment.this.mCarUiRecyclerView.getChildLayoutPosition(view)) == PreferenceFragment.this.mLastFocusedAndSelectedPrefPosition) {
                        view.requestFocus();
                    }
                }

                public void onChildViewDetachedFromWindow(View view) {
                }
            });
        }
        return recyclerView;
    }

    private static boolean getPreferenceDividerAllowedAbove(Preference preference) {
        try {
            Field field = Preference.class.getDeclaredField("mAllowDividerAbove");
            field.setAccessible(true);
            return (Boolean)field.get(preference);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
    }

    private static void setPreferenceDividerAllowedAbove(Preference preference, boolean allowed) {
        try {
            Field field = Preference.class.getDeclaredField("mAllowDividerAbove");
            field.setAccessible(true);
            field.set(preference, allowed);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static boolean getPreferenceDividerAllowedBelow(Preference preference) {
        try {
            Field field = Preference.class.getDeclaredField("mAllowDividerBelow");
            field.setAccessible(true);
            return (Boolean)field.get(preference);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
    }

    private static void setPreferenceDividerAllowedBelow(Preference preference, boolean allowed) {
        try {
            Field field = Preference.class.getDeclaredField("mAllowDividerBelow");
            field.setAccessible(true);
            field.set(preference, allowed);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static Preference copyPreference(Preference from, Preference to) {
        to.setTitle(from.getTitle());
        to.setOnPreferenceClickListener(from.getOnPreferenceClickListener());
        to.setOnPreferenceChangeListener(from.getOnPreferenceChangeListener());
        to.setIcon(from.getIcon());
        to.setFragment(from.getFragment());
        to.setIntent(from.getIntent());
        to.setKey(from.getKey());
        to.setOrder(from.getOrder());
        to.setSelectable(from.isSelectable());
        to.setPersistent(from.isPersistent());
        to.setIconSpaceReserved(from.isIconSpaceReserved());
        to.setWidgetLayoutResource(from.getWidgetLayoutResource());
        to.setPreferenceDataStore(from.getPreferenceDataStore());
        to.setVisible(from.isVisible());
        to.setLayoutResource(from.getLayoutResource());
        to.setCopyingEnabled(from.isCopyingEnabled());
        PreferenceFragment.setPreferenceDividerAllowedBelow(to, PreferenceFragment.getPreferenceDividerAllowedBelow(from));
        PreferenceFragment.setPreferenceDividerAllowedAbove(to, PreferenceFragment.getPreferenceDividerAllowedAbove(from));
        if (!(to instanceof UxRestrictablePreference)) {
            to.setShouldDisableView(from.getShouldDisableView());
        }
        if (from.getSummaryProvider() != null) {
            to.setSummaryProvider(from.getSummaryProvider());
        } else {
            to.setSummary(from.getSummary());
        }
        if (from.peekExtras() != null) {
            to.getExtras().putAll(from.peekExtras());
        }
        if (from instanceof DialogPreference) {
            DialogPreference fromDialog = (DialogPreference)from;
            DialogPreference toDialog = (DialogPreference)to;
            toDialog.setDialogTitle(fromDialog.getDialogTitle());
            toDialog.setDialogIcon(fromDialog.getDialogIcon());
            toDialog.setDialogMessage(fromDialog.getDialogMessage());
            toDialog.setDialogLayoutResource(fromDialog.getDialogLayoutResource());
            toDialog.setNegativeButtonText(fromDialog.getNegativeButtonText());
            toDialog.setPositiveButtonText(fromDialog.getPositiveButtonText());
        }
        if (from instanceof ListPreference) {
            ListPreference fromList = (ListPreference)from;
            ListPreference toList = (ListPreference)to;
            toList.setEntries(fromList.getEntries());
            toList.setEntryValues(fromList.getEntryValues());
            toList.setValue(fromList.getValue());
        } else if (from instanceof EditTextPreference) {
            EditTextPreference fromText = (EditTextPreference)from;
            EditTextPreference toText = (EditTextPreference)to;
            toText.setText(fromText.getText());
        } else if (from instanceof MultiSelectListPreference) {
            MultiSelectListPreference fromMulti = (MultiSelectListPreference)from;
            MultiSelectListPreference toMulti = (MultiSelectListPreference)to;
            toMulti.setEntries(fromMulti.getEntries());
            toMulti.setEntryValues(fromMulti.getEntryValues());
            toMulti.setValues(fromMulti.getValues());
        } else if (from instanceof TwoStatePreference) {
            TwoStatePreference fromTwoState = (TwoStatePreference)from;
            TwoStatePreference toTwoState = (TwoStatePreference)to;
            toTwoState.setSummaryOn(fromTwoState.getSummaryOn());
            toTwoState.setSummaryOff(fromTwoState.getSummaryOff());
            if (from instanceof SwitchPreference) {
                SwitchPreference fromSwitch = (SwitchPreference)from;
                SwitchPreference toSwitch = (SwitchPreference)to;
                toSwitch.setSwitchTextOn(fromSwitch.getSwitchTextOn());
                toSwitch.setSwitchTextOff(fromSwitch.getSwitchTextOff());
            }
        }
        return to;
    }

    public static interface AndroidxRecyclerViewProvider {
        public RecyclerView getRecyclerView();
    }
}

