/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.car.ui.CarUiText;
import com.android.car.ui.recyclerview.CarUiListItem;
import java.util.Collections;
import java.util.List;

public class CarUiContentListItem
extends CarUiListItem {
    @Nullable
    private Drawable mIcon;
    @Nullable
    private Drawable mSupplementalIcon;
    @Nullable
    private CarUiText mTitle;
    @Nullable
    private List<CarUiText> mBody;
    @NonNull
    private final Action mAction;
    @NonNull
    private IconType mPrimaryIconType;
    private boolean mIsActionDividerVisible;
    private boolean mIsChecked;
    private boolean mIsEnabled = true;
    private boolean mIsActivated;
    @Nullable
    private OnClickListener mOnClickListener;
    @Nullable
    private OnCheckedChangeListener mOnCheckedChangeListener;
    @Nullable
    private OnClickListener mSupplementalIconOnClickListener;
    private boolean mIsSecure;

    public CarUiContentListItem(@NonNull Action action) {
        this.mAction = action;
        this.mPrimaryIconType = IconType.STANDARD;
    }

    @Nullable
    public CarUiText getTitle() {
        return this.mTitle;
    }

    public void setTitle(@Nullable CharSequence title) {
        this.mTitle = new CarUiText.Builder(title).build();
    }

    public void setTitle(@Nullable CarUiText text) {
        this.mTitle = text;
    }

    @Nullable
    public List<CarUiText> getBody() {
        return this.mBody;
    }

    public void setBody(@Nullable CharSequence body) {
        if (body == null) {
            this.mBody = null;
            return;
        }
        this.mBody = Collections.singletonList(new CarUiText.Builder(body).build());
    }

    public void setBody(@Nullable CarUiText body) {
        if (body == null) {
            this.mBody = null;
            return;
        }
        this.mBody = Collections.singletonList(body);
    }

    public void setBody(@Nullable List<CarUiText> textList) {
        this.mBody = textList;
    }

    @Nullable
    public Drawable getIcon() {
        return this.mIcon;
    }

    public void setIcon(@Nullable Drawable icon) {
        this.mIcon = icon;
    }

    @NonNull
    public IconType getPrimaryIconType() {
        return this.mPrimaryIconType;
    }

    public void setPrimaryIconType(@NonNull IconType icon) {
        this.mPrimaryIconType = icon;
    }

    public boolean isActivated() {
        return this.mIsActivated;
    }

    public void setActivated(boolean activated) {
        this.mIsActivated = activated;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mIsEnabled = enabled;
    }

    public boolean isChecked() {
        return this.mIsChecked;
    }

    public void setChecked(boolean checked) {
        if (checked == this.mIsChecked) {
            return;
        }
        if (this.mAction == Action.CHECK_BOX || this.mAction == Action.SWITCH || this.mAction == Action.RADIO_BUTTON) {
            this.mIsChecked = checked;
            if (this.mOnCheckedChangeListener != null) {
                this.mOnCheckedChangeListener.onCheckedChanged(this, this.mIsChecked);
            }
        }
    }

    public void setActionDividerVisible(boolean visible) {
        this.mIsActionDividerVisible = visible;
    }

    public boolean isActionDividerVisible() {
        return this.mIsActionDividerVisible;
    }

    @NonNull
    public Action getAction() {
        return this.mAction;
    }

    @Nullable
    public Drawable getSupplementalIcon() {
        if (this.mAction != Action.ICON) {
            return null;
        }
        return this.mSupplementalIcon;
    }

    public void setSupplementalIcon(@Nullable Drawable icon) {
        this.setSupplementalIcon(icon, null);
    }

    public void setSupplementalIcon(@Nullable Drawable icon, @Nullable OnClickListener listener) {
        if (this.mAction != Action.ICON) {
            throw new IllegalStateException("Cannot set supplemental icon on list item that does not have an action of type ICON");
        }
        this.mSupplementalIcon = icon;
        this.mSupplementalIconOnClickListener = listener;
    }

    @Nullable
    public OnClickListener getSupplementalIconOnClickListener() {
        return this.mSupplementalIconOnClickListener;
    }

    public void setOnItemClickedListener(@Nullable OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    @Nullable
    public OnClickListener getOnClickListener() {
        return this.mOnClickListener;
    }

    public void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    @Nullable
    public OnCheckedChangeListener getOnCheckedChangeListener() {
        return this.mOnCheckedChangeListener;
    }

    public void setSecure(boolean secure) {
        this.mIsSecure = secure;
    }

    public boolean isSecure() {
        return this.mIsSecure;
    }

    public static enum Action {
        NONE,
        SWITCH,
        CHECK_BOX,
        RADIO_BUTTON,
        ICON,
        CHEVRON;

    }

    public static enum IconType {
        CONTENT,
        STANDARD,
        AVATAR;

    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(@NonNull CarUiContentListItem var1, boolean var2);
    }

    public static interface OnClickListener {
        public void onClick(@NonNull CarUiContentListItem var1);
    }
}

