/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.ui.recyclerview;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.ui.recyclerview.CarUiLayoutStyle;

public final class CarUiGridLayoutStyle
implements CarUiLayoutStyle {
    private int mSpanCount = 1;
    private int mLayoutOrientation = 1;
    private boolean mReverseLayout = false;
    private int mSize = 2;
    @NonNull
    private GridLayoutManager.SpanSizeLookup mSpanSizeLookup = new GridLayoutManager.DefaultSpanSizeLookup();

    @Nullable
    public static CarUiGridLayoutStyle from(@Nullable RecyclerView.LayoutManager layoutManager) {
        if (layoutManager == null) {
            return null;
        }
        if (!(layoutManager instanceof GridLayoutManager)) {
            throw new AssertionError((Object)"GridLayoutManager required.");
        }
        CarUiGridLayoutStyle layoutStyle = new CarUiGridLayoutStyle();
        layoutStyle.setSpanCount(((GridLayoutManager)layoutManager).getSpanCount());
        layoutStyle.setReverseLayout(((GridLayoutManager)layoutManager).getReverseLayout());
        layoutStyle.setSpanSizeLookup(((GridLayoutManager)layoutManager).getSpanSizeLookup());
        return layoutStyle;
    }

    @Override
    public int getSpanCount() {
        return this.mSpanCount;
    }

    public void setSpanCount(int spanCount) {
        if (spanCount <= 0) {
            throw new AssertionError((Object)"Span count must be bigger than 0");
        }
        this.mSpanCount = spanCount;
    }

    @Override
    public int getLayoutType() {
        return 1;
    }

    @Override
    public int getOrientation() {
        return this.mLayoutOrientation;
    }

    public void setOrientation(int orientation) {
        this.mLayoutOrientation = orientation;
    }

    @Override
    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    public void setReverseLayout(boolean reverseLayout) {
        this.mReverseLayout = reverseLayout;
    }

    @NonNull
    public GridLayoutManager.SpanSizeLookup getSpanSizeLookup() {
        return this.mSpanSizeLookup;
    }

    public void setSpanSizeLookup(@NonNull GridLayoutManager.SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    @Override
    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }
}

